/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine$1;
import javafx.scene.transform.Affine$10;
import javafx.scene.transform.Affine$11;
import javafx.scene.transform.Affine$12;
import javafx.scene.transform.Affine$2;
import javafx.scene.transform.Affine$3;
import javafx.scene.transform.Affine$4;
import javafx.scene.transform.Affine$5;
import javafx.scene.transform.Affine$6;
import javafx.scene.transform.Affine$7;
import javafx.scene.transform.Affine$8;
import javafx.scene.transform.Affine$9;
import javafx.scene.transform.Affine$AffineAtomicChange;
import javafx.scene.transform.Affine$AffineElementProperty;
import javafx.scene.transform.MatrixType;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

public class Affine
extends Transform {
    Affine$AffineAtomicChange atomicChange = new Affine$AffineAtomicChange(this);
    private static final int APPLY_IDENTITY = 0;
    private static final int APPLY_TRANSLATE = 1;
    private static final int APPLY_SCALE = 2;
    private static final int APPLY_SHEAR = 4;
    private static final int APPLY_NON_3D = 0;
    private static final int APPLY_3D_COMPLEX = 4;
    private transient int state2d;
    private transient int state3d;
    private double xx;
    private double xy;
    private double xz;
    private double yx;
    private double yy;
    private double yz;
    private double zx;
    private double zy;
    private double zz;
    private double xt;
    private double yt;
    private double zt;
    private Affine$AffineElementProperty mxx;
    private Affine$AffineElementProperty mxy;
    private Affine$AffineElementProperty mxz;
    private Affine$AffineElementProperty tx;
    private Affine$AffineElementProperty myx;
    private Affine$AffineElementProperty myy;
    private Affine$AffineElementProperty myz;
    private Affine$AffineElementProperty ty;
    private Affine$AffineElementProperty mzx;
    private Affine$AffineElementProperty mzy;
    private Affine$AffineElementProperty mzz;
    private Affine$AffineElementProperty tz;
    private static final int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    public Affine() {
        Affine affine = this;
        this.zz = 1.0;
        affine.yy = 1.0;
        affine.xx = 1.0;
    }

    public Affine(Transform transform) {
        this(transform.getMxx(), transform.getMxy(), transform.getMxz(), transform.getTx(), transform.getMyx(), transform.getMyy(), transform.getMyz(), transform.getTy(), transform.getMzx(), transform.getMzy(), transform.getMzz(), transform.getTz());
    }

    public Affine(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.xx = d2;
        this.xy = d3;
        this.xt = d4;
        this.yx = d5;
        this.yy = d6;
        this.yt = d7;
        this.zz = 1.0;
        this.updateState2D();
    }

    public Affine(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.xx = d2;
        this.xy = d3;
        this.xz = d4;
        this.xt = d5;
        this.yx = d6;
        this.yy = d7;
        this.yz = d8;
        this.yt = d9;
        this.zx = d10;
        this.zy = d11;
        this.zz = d12;
        this.zt = d13;
        this.updateState();
    }

    public Affine(double[] dArray, MatrixType matrixType, int n2) {
        if (dArray.length < n2 + matrixType.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (matrixType) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (dArray[n2 + 6] != 0.0 || dArray[n2 + 7] != 0.0 || dArray[n2 + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.xx = dArray[n2++];
                this.xy = dArray[n2++];
                this.xt = dArray[n2++];
                this.yx = dArray[n2++];
                this.yy = dArray[n2++];
                this.yt = dArray[n2];
                this.zz = 1.0;
                this.updateState2D();
                return;
            }
            case MT_3D_4x4: {
                if (dArray[n2 + 12] == 0.0 && dArray[n2 + 13] == 0.0 && dArray[n2 + 14] == 0.0 && dArray[n2 + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.xx = dArray[n2++];
        this.xy = dArray[n2++];
        this.xz = dArray[n2++];
        this.xt = dArray[n2++];
        this.yx = dArray[n2++];
        this.yy = dArray[n2++];
        this.yz = dArray[n2++];
        this.yt = dArray[n2++];
        this.zx = dArray[n2++];
        this.zy = dArray[n2++];
        this.zz = dArray[n2++];
        this.zt = dArray[n2];
        this.updateState();
    }

    public final void setMxx(double d2) {
        if (this.mxx == null) {
            if (this.xx != d2) {
                this.xx = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.mxxProperty().set(d2);
        }
    }

    @Override
    public final double getMxx() {
        if (this.mxx == null) {
            return this.xx;
        }
        return this.mxx.get();
    }

    public final DoubleProperty mxxProperty() {
        if (this.mxx == null) {
            Affine affine = this;
            this.mxx = new Affine$1(affine, affine.xx);
        }
        return this.mxx;
    }

    public final void setMxy(double d2) {
        if (this.mxy == null) {
            if (this.xy != d2) {
                this.xy = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.mxyProperty().set(d2);
        }
    }

    @Override
    public final double getMxy() {
        if (this.mxy == null) {
            return this.xy;
        }
        return this.mxy.get();
    }

    public final DoubleProperty mxyProperty() {
        if (this.mxy == null) {
            Affine affine = this;
            this.mxy = new Affine$2(affine, affine.xy);
        }
        return this.mxy;
    }

    public final void setMxz(double d2) {
        if (this.mxz == null) {
            if (this.xz != d2) {
                this.xz = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.mxzProperty().set(d2);
        }
    }

    @Override
    public final double getMxz() {
        if (this.mxz == null) {
            return this.xz;
        }
        return this.mxz.get();
    }

    public final DoubleProperty mxzProperty() {
        if (this.mxz == null) {
            Affine affine = this;
            this.mxz = new Affine$3(affine, affine.xz);
        }
        return this.mxz;
    }

    public final void setTx(double d2) {
        if (this.tx == null) {
            if (this.xt != d2) {
                this.xt = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.txProperty().set(d2);
        }
    }

    @Override
    public final double getTx() {
        if (this.tx == null) {
            return this.xt;
        }
        return this.tx.get();
    }

    public final DoubleProperty txProperty() {
        if (this.tx == null) {
            Affine affine = this;
            this.tx = new Affine$4(affine, affine.xt);
        }
        return this.tx;
    }

    public final void setMyx(double d2) {
        if (this.myx == null) {
            if (this.yx != d2) {
                this.yx = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.myxProperty().set(d2);
        }
    }

    @Override
    public final double getMyx() {
        if (this.myx == null) {
            return this.yx;
        }
        return this.myx.get();
    }

    public final DoubleProperty myxProperty() {
        if (this.myx == null) {
            Affine affine = this;
            this.myx = new Affine$5(affine, affine.yx);
        }
        return this.myx;
    }

    public final void setMyy(double d2) {
        if (this.myy == null) {
            if (this.yy != d2) {
                this.yy = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.myyProperty().set(d2);
        }
    }

    @Override
    public final double getMyy() {
        if (this.myy == null) {
            return this.yy;
        }
        return this.myy.get();
    }

    public final DoubleProperty myyProperty() {
        if (this.myy == null) {
            Affine affine = this;
            this.myy = new Affine$6(affine, affine.yy);
        }
        return this.myy;
    }

    public final void setMyz(double d2) {
        if (this.myz == null) {
            if (this.yz != d2) {
                this.yz = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.myzProperty().set(d2);
        }
    }

    @Override
    public final double getMyz() {
        if (this.myz == null) {
            return this.yz;
        }
        return this.myz.get();
    }

    public final DoubleProperty myzProperty() {
        if (this.myz == null) {
            Affine affine = this;
            this.myz = new Affine$7(affine, affine.yz);
        }
        return this.myz;
    }

    public final void setTy(double d2) {
        if (this.ty == null) {
            if (this.yt != d2) {
                this.yt = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.tyProperty().set(d2);
        }
    }

    @Override
    public final double getTy() {
        if (this.ty == null) {
            return this.yt;
        }
        return this.ty.get();
    }

    public final DoubleProperty tyProperty() {
        if (this.ty == null) {
            Affine affine = this;
            this.ty = new Affine$8(affine, affine.yt);
        }
        return this.ty;
    }

    public final void setMzx(double d2) {
        if (this.mzx == null) {
            if (this.zx != d2) {
                this.zx = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.mzxProperty().set(d2);
        }
    }

    @Override
    public final double getMzx() {
        if (this.mzx == null) {
            return this.zx;
        }
        return this.mzx.get();
    }

    public final DoubleProperty mzxProperty() {
        if (this.mzx == null) {
            Affine affine = this;
            this.mzx = new Affine$9(affine, affine.zx);
        }
        return this.mzx;
    }

    public final void setMzy(double d2) {
        if (this.mzy == null) {
            if (this.zy != d2) {
                this.zy = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.mzyProperty().set(d2);
        }
    }

    @Override
    public final double getMzy() {
        if (this.mzy == null) {
            return this.zy;
        }
        return this.mzy.get();
    }

    public final DoubleProperty mzyProperty() {
        if (this.mzy == null) {
            Affine affine = this;
            this.mzy = new Affine$10(affine, affine.zy);
        }
        return this.mzy;
    }

    public final void setMzz(double d2) {
        if (this.mzz == null) {
            if (this.zz != d2) {
                this.zz = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.mzzProperty().set(d2);
        }
    }

    @Override
    public final double getMzz() {
        if (this.mzz == null) {
            return this.zz;
        }
        return this.mzz.get();
    }

    public final DoubleProperty mzzProperty() {
        if (this.mzz == null) {
            Affine affine = this;
            this.mzz = new Affine$11(affine, affine.zz);
        }
        return this.mzz;
    }

    public final void setTz(double d2) {
        if (this.tz == null) {
            if (this.zt != d2) {
                this.zt = d2;
                this.postProcessChange();
                return;
            }
        } else {
            this.tzProperty().set(d2);
        }
    }

    @Override
    public final double getTz() {
        if (this.tz == null) {
            return this.zt;
        }
        return this.tz.get();
    }

    public final DoubleProperty tzProperty() {
        if (this.tz == null) {
            Affine affine = this;
            this.tz = new Affine$12(affine, affine.zt);
        }
        return this.tz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(MatrixType matrixType, int n2, int n3, double d2) {
        if (n2 < 0 || n2 >= matrixType.rows() || n3 < 0 || n3 >= matrixType.columns()) {
            throw new IndexOutOfBoundsException("Index outside of affine matrix " + String.valueOf((Object)matrixType) + ": [" + n2 + ", " + n3 + "]");
        }
        switch (matrixType) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: 
            case MT_2D_2x3: {
                if (!this.isType2D()) {
                    throw new IllegalArgumentException("Cannot access 2D matrix of a 3D transform");
                }
                switch (n2) {
                    case 0: {
                        switch (n3) {
                            case 0: {
                                this.setMxx(d2);
                                return;
                            }
                            case 1: {
                                this.setMxy(d2);
                                return;
                            }
                            case 2: {
                                this.setTx(d2);
                                return;
                            }
                        }
                    }
                    case 1: {
                        switch (n3) {
                            case 0: {
                                this.setMyx(d2);
                                return;
                            }
                            case 1: {
                                this.setMyy(d2);
                                return;
                            }
                            case 2: {
                                this.setTy(d2);
                                return;
                            }
                        }
                    }
                    case 2: {
                        switch (n3) {
                            case 0: {
                                if (d2 != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
                                return;
                            }
                            case 1: {
                                if (d2 != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
                                return;
                            }
                            case 2: {
                                if (d2 != 1.0) throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
                                return;
                            }
                        }
                    }
                }
                throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
            }
            case MT_3D_4x4: 
            case MT_3D_3x4: {
                switch (n2) {
                    case 0: {
                        switch (n3) {
                            case 0: {
                                this.setMxx(d2);
                                return;
                            }
                            case 1: {
                                this.setMxy(d2);
                                return;
                            }
                            case 2: {
                                this.setMxz(d2);
                                return;
                            }
                            case 3: {
                                this.setTx(d2);
                                return;
                            }
                        }
                    }
                    case 1: {
                        switch (n3) {
                            case 0: {
                                this.setMyx(d2);
                                return;
                            }
                            case 1: {
                                this.setMyy(d2);
                                return;
                            }
                            case 2: {
                                this.setMyz(d2);
                                return;
                            }
                            case 3: {
                                this.setTy(d2);
                                return;
                            }
                        }
                    }
                    case 2: {
                        switch (n3) {
                            case 0: {
                                this.setMzx(d2);
                                return;
                            }
                            case 1: {
                                this.setMzy(d2);
                                return;
                            }
                            case 2: {
                                this.setMzz(d2);
                                return;
                            }
                            case 3: {
                                this.setTz(d2);
                                return;
                            }
                        }
                    }
                    case 3: {
                        switch (n3) {
                            case 0: {
                                if (d2 != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
                                return;
                            }
                            case 1: {
                                if (d2 != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
                                return;
                            }
                            case 2: {
                                if (d2 != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
                                return;
                            }
                            case 3: {
                                if (d2 != 1.0) throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
                                return;
                            }
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Cannot set affine matrix " + String.valueOf((Object)matrixType) + " element [" + n2 + ", " + n3 + "] to " + d2);
    }

    private void postProcessChange() {
        if (!this.atomicChange.runs()) {
            this.updateState();
            this.transformChanged();
        }
    }

    @Override
    boolean computeIs2D() {
        return this.state3d == 0;
    }

    @Override
    boolean computeIsIdentity() {
        return this.state3d == 0 && this.state2d == 0;
    }

    @Override
    public double determinant() {
        if (this.state3d == 0) {
            return this.getDeterminant2D();
        }
        return this.getDeterminant3D();
    }

    private double getDeterminant2D() {
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                return ((Transform)this).getMxx() * ((Transform)this).getMyy() - ((Transform)this).getMxy() * ((Transform)this).getMyx();
            }
            case 4: 
            case 5: {
                return -(((Transform)this).getMxy() * ((Transform)this).getMyx());
            }
            case 2: 
            case 3: {
                return ((Transform)this).getMxx() * ((Transform)this).getMyy();
            }
            case 0: 
            case 1: 
        }
        return 1.0;
    }

    private double getDeterminant3D() {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                return 1.0;
            }
            case 2: 
            case 3: {
                return ((Transform)this).getMxx() * ((Transform)this).getMyy() * ((Transform)this).getMzz();
            }
            case 4: 
        }
        double d2 = ((Transform)this).getMyx();
        double d3 = ((Transform)this).getMyy();
        double d4 = ((Transform)this).getMyz();
        double d5 = ((Transform)this).getMzx();
        double d6 = ((Transform)this).getMzy();
        double d7 = ((Transform)this).getMzz();
        return ((Transform)this).getMxx() * (d3 * d7 - d6 * d4) + ((Transform)this).getMxy() * (d4 * d5 - d7 * d2) + ((Transform)this).getMxz() * (d2 * d6 - d5 * d3);
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        Affine affine = this.clone();
        affine.append(transform);
        return affine;
    }

    @Override
    public Affine createInverse() throws NonInvertibleTransformException {
        Affine affine = this.clone();
        affine.invert();
        return affine;
    }

    @Override
    public Affine clone() {
        return new Affine(this);
    }

    public void setToTransform(Transform transform) {
        this.setToTransform(transform.getMxx(), transform.getMxy(), transform.getMxz(), transform.getTx(), transform.getMyx(), transform.getMyy(), transform.getMyz(), transform.getTy(), transform.getMzx(), transform.getMzy(), transform.getMzz(), transform.getTz());
    }

    public void setToTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.setToTransform(d2, d3, 0.0, d4, d5, d6, 0.0, d7, 0.0, 0.0, 1.0, 0.0);
    }

    public void setToTransform(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.atomicChange.start();
        this.setMxx(d2);
        this.setMxy(d3);
        this.setMxz(d4);
        this.setTx(d5);
        this.setMyx(d6);
        this.setMyy(d7);
        this.setMyz(d8);
        this.setTy(d9);
        this.setMzx(d10);
        this.setMzy(d11);
        this.setMzz(d12);
        this.setTz(d13);
        this.updateState();
        this.atomicChange.end();
    }

    public void setToTransform(double[] dArray, MatrixType matrixType, int n2) {
        if (dArray.length < n2 + matrixType.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (matrixType) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (dArray[n2 + 6] != 0.0 || dArray[n2 + 7] != 0.0 || dArray[n2 + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.setToTransform(dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2]);
                return;
            }
            case MT_3D_4x4: {
                if (dArray[n2 + 12] == 0.0 && dArray[n2 + 13] == 0.0 && dArray[n2 + 14] == 0.0 && dArray[n2 + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.setToTransform(dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2]);
    }

    public void setToIdentity() {
        this.atomicChange.start();
        if (this.state3d != 0) {
            this.setMxx(1.0);
            this.setMxy(0.0);
            this.setMxz(0.0);
            this.setTx(0.0);
            this.setMyx(0.0);
            this.setMyy(1.0);
            this.setMyz(0.0);
            this.setTy(0.0);
            this.setMzx(0.0);
            this.setMzy(0.0);
            this.setMzz(1.0);
            this.setTz(0.0);
            this.state3d = 0;
            this.state2d = 0;
        } else if (this.state2d != 0) {
            this.setMxx(1.0);
            this.setMxy(0.0);
            this.setTx(0.0);
            this.setMyx(0.0);
            this.setMyy(1.0);
            this.setTy(0.0);
            this.state2d = 0;
        }
        this.atomicChange.end();
    }

    public void invert() throws NonInvertibleTransformException {
        this.atomicChange.start();
        if (this.state3d == 0) {
            this.invert2D();
            this.updateState2D();
        } else {
            this.invert3D();
            this.updateState();
        }
        this.atomicChange.end();
    }

    private void invert2D() throws NonInvertibleTransformException {
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                double d2 = ((Transform)this).getMxx();
                double d3 = ((Transform)this).getMxy();
                double d4 = ((Transform)this).getTx();
                double d5 = ((Transform)this).getMyx();
                double d6 = ((Transform)this).getMyy();
                double d7 = ((Transform)this).getTy();
                double d8 = this.getDeterminant2D();
                if (d8 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(d6 / d8);
                this.setMyx(-d5 / d8);
                this.setMxy(-d3 / d8);
                this.setMyy(d2 / d8);
                this.setTx((d3 * d7 - d6 * d4) / d8);
                this.setTy((d5 * d4 - d2 * d7) / d8);
                return;
            }
            case 6: {
                double d9 = ((Transform)this).getMxx();
                double d10 = ((Transform)this).getMxy();
                double d11 = ((Transform)this).getMyx();
                double d12 = ((Transform)this).getMyy();
                double d13 = this.getDeterminant2D();
                if (d13 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(d12 / d13);
                this.setMyx(-d11 / d13);
                this.setMxy(-d10 / d13);
                this.setMyy(d9 / d13);
                return;
            }
            case 5: {
                double d14 = ((Transform)this).getMxy();
                double d15 = ((Transform)this).getTx();
                double d16 = ((Transform)this).getMyx();
                double d17 = ((Transform)this).getTy();
                if (d14 == 0.0 || d16 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMyx(1.0 / d14);
                this.setMxy(1.0 / d16);
                this.setTx(-d17 / d16);
                this.setTy(-d15 / d14);
                return;
            }
            case 4: {
                double d18 = ((Transform)this).getMxy();
                double d19 = ((Transform)this).getMyx();
                if (d18 == 0.0 || d19 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMyx(1.0 / d18);
                this.setMxy(1.0 / d19);
                return;
            }
            case 3: {
                double d20 = ((Transform)this).getMxx();
                double d21 = ((Transform)this).getTx();
                double d22 = ((Transform)this).getMyy();
                double d23 = ((Transform)this).getTy();
                if (d20 == 0.0 || d22 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / d20);
                this.setMyy(1.0 / d22);
                this.setTx(-d21 / d20);
                this.setTy(-d23 / d22);
                return;
            }
            case 2: {
                double d24 = ((Transform)this).getMxx();
                double d25 = ((Transform)this).getMyy();
                if (d24 == 0.0 || d25 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / d24);
                this.setMyy(1.0 / d25);
                return;
            }
            case 1: {
                Affine affine = this;
                affine.setTx(-((Transform)affine).getTx());
                Affine affine2 = this;
                affine2.setTy(-((Transform)affine2).getTy());
                return;
            }
            case 0: 
        }
    }

    private void invert3D() throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                Affine affine = this;
                affine.setTx(-((Transform)affine).getTx());
                Affine affine2 = this;
                affine2.setTy(-((Transform)affine2).getTy());
                Affine affine3 = this;
                affine3.setTz(-((Transform)affine3).getTz());
                return;
            }
            case 2: {
                double d2 = ((Transform)this).getMxx();
                double d3 = ((Transform)this).getMyy();
                double d4 = ((Transform)this).getMzz();
                if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / d2);
                this.setMyy(1.0 / d3);
                this.setMzz(1.0 / d4);
                return;
            }
            case 3: {
                double d5 = ((Transform)this).getMxx();
                double d6 = ((Transform)this).getTx();
                double d7 = ((Transform)this).getMyy();
                double d8 = ((Transform)this).getTy();
                double d9 = ((Transform)this).getMzz();
                double d10 = ((Transform)this).getTz();
                if (d5 == 0.0 || d7 == 0.0 || d9 == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / d5);
                this.setMyy(1.0 / d7);
                this.setMzz(1.0 / d9);
                this.setTx(-d6 / d5);
                this.setTy(-d8 / d7);
                this.setTz(-d10 / d9);
                return;
            }
            case 4: 
        }
        double d11 = ((Transform)this).getMxx();
        double d12 = ((Transform)this).getMxy();
        double d13 = ((Transform)this).getMxz();
        double d14 = ((Transform)this).getTx();
        double d15 = ((Transform)this).getMyx();
        double d16 = ((Transform)this).getMyy();
        double d17 = ((Transform)this).getMyz();
        double d18 = ((Transform)this).getTy();
        double d19 = ((Transform)this).getMzy();
        double d20 = ((Transform)this).getMzx();
        double d21 = ((Transform)this).getMzz();
        double d22 = ((Transform)this).getTz();
        double d23 = d11 * (d16 * d21 - d19 * d17) + d12 * (d17 * d20 - d21 * d15) + d13 * (d15 * d19 - d20 * d16);
        if (d23 == 0.0) {
            this.atomicChange.cancel();
            throw new NonInvertibleTransformException("Determinant is 0");
        }
        double d24 = d16 * d21 - d17 * d19;
        double d25 = -d15 * d21 + d17 * d20;
        double d26 = d15 * d19 - d16 * d20;
        double d27 = -d12 * (d17 * d22 - d21 * d18) - d13 * (d18 * d19 - d22 * d16) - d14 * (d16 * d21 - d19 * d17);
        double d28 = -d12 * d21 + d13 * d19;
        double d29 = d11 * d21 - d13 * d20;
        double d30 = -d11 * d19 + d12 * d20;
        double d31 = d11 * (d17 * d22 - d21 * d18) + d13 * (d18 * d20 - d22 * d15) + d14 * (d15 * d21 - d20 * d17);
        double d32 = d12 * d17 - d13 * d16;
        double d33 = -d11 * d17 + d13 * d15;
        double d34 = d11 * d16 - d12 * d15;
        double d35 = -d11 * (d16 * d22 - d19 * d18) - d12 * (d18 * d20 - d22 * d15) - d14 * (d15 * d19 - d20 * d16);
        this.setMxx(d24 / d23);
        this.setMxy(d28 / d23);
        this.setMxz(d32 / d23);
        this.setTx(d27 / d23);
        this.setMyx(d25 / d23);
        this.setMyy(d29 / d23);
        this.setMyz(d33 / d23);
        this.setTy(d31 / d23);
        this.setMzx(d26 / d23);
        this.setMzy(d30 / d23);
        this.setMzz(d34 / d23);
        this.setTz(d35 / d23);
    }

    public void append(Transform transform) {
        transform.appendTo(this);
    }

    public void append(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.state3d == 0) {
            this.atomicChange.start();
            double d8 = ((Transform)this).getMxx();
            double d9 = ((Transform)this).getMxy();
            double d10 = ((Transform)this).getMyx();
            double d11 = ((Transform)this).getMyy();
            this.setMxx(d8 * d2 + d9 * d5);
            this.setMxy(d8 * d3 + d9 * d6);
            this.setTx(d8 * d4 + d9 * d7 + ((Transform)this).getTx());
            this.setMyx(d10 * d2 + d11 * d5);
            this.setMyy(d10 * d3 + d11 * d6);
            this.setTy(d10 * d4 + d11 * d7 + ((Transform)this).getTy());
            this.updateState();
            this.atomicChange.end();
            return;
        }
        this.append(d2, d3, 0.0, d4, d5, d6, 0.0, d7, 0.0, 0.0, 1.0, 0.0);
    }

    public void append(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.atomicChange.start();
        double d14 = ((Transform)this).getMxx();
        double d15 = ((Transform)this).getMxy();
        double d16 = ((Transform)this).getMxz();
        double d17 = ((Transform)this).getTx();
        double d18 = ((Transform)this).getMyx();
        double d19 = ((Transform)this).getMyy();
        double d20 = ((Transform)this).getMyz();
        double d21 = ((Transform)this).getTy();
        double d22 = ((Transform)this).getMzx();
        double d23 = ((Transform)this).getMzy();
        double d24 = ((Transform)this).getMzz();
        double d25 = ((Transform)this).getTz();
        this.setMxx(d14 * d2 + d15 * d6 + d16 * d10);
        this.setMxy(d14 * d3 + d15 * d7 + d16 * d11);
        this.setMxz(d14 * d4 + d15 * d8 + d16 * d12);
        this.setTx(d14 * d5 + d15 * d9 + d16 * d13 + d17);
        this.setMyx(d18 * d2 + d19 * d6 + d20 * d10);
        this.setMyy(d18 * d3 + d19 * d7 + d20 * d11);
        this.setMyz(d18 * d4 + d19 * d8 + d20 * d12);
        this.setTy(d18 * d5 + d19 * d9 + d20 * d13 + d21);
        this.setMzx(d22 * d2 + d23 * d6 + d24 * d10);
        this.setMzy(d22 * d3 + d23 * d7 + d24 * d11);
        this.setMzz(d22 * d4 + d23 * d8 + d24 * d12);
        this.setTz(d22 * d5 + d23 * d9 + d24 * d13 + d25);
        this.updateState();
        this.atomicChange.end();
    }

    public void append(double[] dArray, MatrixType matrixType, int n2) {
        if (dArray.length < n2 + matrixType.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (matrixType) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (dArray[n2 + 6] != 0.0 || dArray[n2 + 7] != 0.0 || dArray[n2 + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.append(dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2]);
                return;
            }
            case MT_3D_4x4: {
                if (dArray[n2 + 12] == 0.0 && dArray[n2 + 13] == 0.0 && dArray[n2 + 14] == 0.0 && dArray[n2 + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.append(dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2]);
    }

    @Override
    void appendTo(Affine affine) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        affine.appendTranslation(((Transform)this).getTx(), ((Transform)this).getTy());
                        return;
                    }
                    case 2: {
                        affine.appendScale(((Transform)this).getMxx(), ((Transform)this).getMyy());
                        return;
                    }
                    case 3: {
                        affine.appendTranslation(((Transform)this).getTx(), ((Transform)this).getTy());
                        affine.appendScale(((Transform)this).getMxx(), ((Transform)this).getMyy());
                        return;
                    }
                }
                affine.append(((Transform)this).getMxx(), ((Transform)this).getMxy(), ((Transform)this).getTx(), ((Transform)this).getMyx(), ((Transform)this).getMyy(), ((Transform)this).getTy());
                return;
            }
            case 1: {
                affine.appendTranslation(((Transform)this).getTx(), ((Transform)this).getTy(), ((Transform)this).getTz());
                return;
            }
            case 2: {
                affine.appendScale(((Transform)this).getMxx(), ((Transform)this).getMyy(), ((Transform)this).getMzz());
                return;
            }
            case 3: {
                affine.appendTranslation(((Transform)this).getTx(), ((Transform)this).getTy(), ((Transform)this).getTz());
                affine.appendScale(((Transform)this).getMxx(), ((Transform)this).getMyy(), ((Transform)this).getMzz());
                return;
            }
            case 4: 
        }
        affine.append(((Transform)this).getMxx(), ((Transform)this).getMxy(), ((Transform)this).getMxz(), ((Transform)this).getTx(), ((Transform)this).getMyx(), ((Transform)this).getMyy(), ((Transform)this).getMyz(), ((Transform)this).getTy(), ((Transform)this).getMzx(), ((Transform)this).getMzy(), ((Transform)this).getMzz(), ((Transform)this).getTz());
    }

    public void prepend(Transform transform) {
        transform.prependTo(this);
    }

    public void prepend(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.state3d == 0) {
            this.atomicChange.start();
            double d8 = ((Transform)this).getMxx();
            double d9 = ((Transform)this).getMxy();
            double d10 = ((Transform)this).getTx();
            double d11 = ((Transform)this).getMyx();
            double d12 = ((Transform)this).getMyy();
            double d13 = ((Transform)this).getTy();
            this.setMxx(d2 * d8 + d3 * d11);
            this.setMxy(d2 * d9 + d3 * d12);
            this.setTx(d2 * d10 + d3 * d13 + d4);
            this.setMyx(d5 * d8 + d6 * d11);
            this.setMyy(d5 * d9 + d6 * d12);
            this.setTy(d5 * d10 + d6 * d13 + d7);
            this.updateState2D();
            this.atomicChange.end();
            return;
        }
        this.prepend(d2, d3, 0.0, d4, d5, d6, 0.0, d7, 0.0, 0.0, 1.0, 0.0);
    }

    public void prepend(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.atomicChange.start();
        double d14 = ((Transform)this).getMxx();
        double d15 = ((Transform)this).getMxy();
        double d16 = ((Transform)this).getMxz();
        double d17 = ((Transform)this).getTx();
        double d18 = ((Transform)this).getMyx();
        double d19 = ((Transform)this).getMyy();
        double d20 = ((Transform)this).getMyz();
        double d21 = ((Transform)this).getTy();
        double d22 = ((Transform)this).getMzx();
        double d23 = ((Transform)this).getMzy();
        double d24 = ((Transform)this).getMzz();
        double d25 = ((Transform)this).getTz();
        this.setMxx(d2 * d14 + d3 * d18 + d4 * d22);
        this.setMxy(d2 * d15 + d3 * d19 + d4 * d23);
        this.setMxz(d2 * d16 + d3 * d20 + d4 * d24);
        this.setTx(d2 * d17 + d3 * d21 + d4 * d25 + d5);
        this.setMyx(d6 * d14 + d7 * d18 + d8 * d22);
        this.setMyy(d6 * d15 + d7 * d19 + d8 * d23);
        this.setMyz(d6 * d16 + d7 * d20 + d8 * d24);
        this.setTy(d6 * d17 + d7 * d21 + d8 * d25 + d9);
        this.setMzx(d10 * d14 + d11 * d18 + d12 * d22);
        this.setMzy(d10 * d15 + d11 * d19 + d12 * d23);
        this.setMzz(d10 * d16 + d11 * d20 + d12 * d24);
        this.setTz(d10 * d17 + d11 * d21 + d12 * d25 + d13);
        this.updateState();
        this.atomicChange.end();
    }

    public void prepend(double[] dArray, MatrixType matrixType, int n2) {
        if (dArray.length < n2 + matrixType.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (matrixType) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (dArray[n2 + 6] != 0.0 || dArray[n2 + 7] != 0.0 || dArray[n2 + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.prepend(dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2]);
                return;
            }
            case MT_3D_4x4: {
                if (dArray[n2 + 12] == 0.0 && dArray[n2 + 13] == 0.0 && dArray[n2 + 14] == 0.0 && dArray[n2 + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.prepend(dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2++], dArray[n2]);
    }

    @Override
    void prependTo(Affine affine) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        affine.prependTranslation(((Transform)this).getTx(), ((Transform)this).getTy());
                        return;
                    }
                    case 2: {
                        affine.prependScale(((Transform)this).getMxx(), ((Transform)this).getMyy());
                        return;
                    }
                    case 3: {
                        affine.prependScale(((Transform)this).getMxx(), ((Transform)this).getMyy());
                        affine.prependTranslation(((Transform)this).getTx(), ((Transform)this).getTy());
                        return;
                    }
                }
                affine.prepend(((Transform)this).getMxx(), ((Transform)this).getMxy(), ((Transform)this).getTx(), ((Transform)this).getMyx(), ((Transform)this).getMyy(), ((Transform)this).getTy());
                return;
            }
            case 1: {
                affine.prependTranslation(((Transform)this).getTx(), ((Transform)this).getTy(), ((Transform)this).getTz());
                return;
            }
            case 2: {
                affine.prependScale(((Transform)this).getMxx(), ((Transform)this).getMyy(), ((Transform)this).getMzz());
                return;
            }
            case 3: {
                affine.prependScale(((Transform)this).getMxx(), ((Transform)this).getMyy(), ((Transform)this).getMzz());
                affine.prependTranslation(((Transform)this).getTx(), ((Transform)this).getTy(), ((Transform)this).getTz());
                return;
            }
            case 4: 
        }
        affine.prepend(((Transform)this).getMxx(), ((Transform)this).getMxy(), ((Transform)this).getMxz(), ((Transform)this).getTx(), ((Transform)this).getMyx(), ((Transform)this).getMyy(), ((Transform)this).getMyz(), ((Transform)this).getTy(), ((Transform)this).getMzx(), ((Transform)this).getMzy(), ((Transform)this).getMzz(), ((Transform)this).getTz());
    }

    public void appendTranslation(double d2, double d3) {
        this.atomicChange.start();
        this.translate2D(d2, d3);
        this.atomicChange.end();
    }

    public void appendTranslation(double d2, double d3, double d4) {
        this.atomicChange.start();
        this.translate3D(d2, d3, d4);
        this.atomicChange.end();
    }

    private void translate2D(double d2, double d3) {
        if (this.state3d != 0) {
            this.translate3D(d2, d3, 0.0);
            return;
        }
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                this.setTx(d2 * ((Transform)this).getMxx() + d3 * ((Transform)this).getMxy() + ((Transform)this).getTx());
                this.setTy(d2 * ((Transform)this).getMyx() + d3 * ((Transform)this).getMyy() + ((Transform)this).getTy());
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = 6;
                }
                return;
            }
            case 6: {
                this.setTx(d2 * ((Transform)this).getMxx() + d3 * ((Transform)this).getMxy());
                this.setTy(d2 * ((Transform)this).getMyx() + d3 * ((Transform)this).getMyy());
                if (((Transform)this).getTx() != 0.0 || ((Transform)this).getTy() != 0.0) {
                    this.state2d = 7;
                }
                return;
            }
            case 5: {
                this.setTx(d3 * ((Transform)this).getMxy() + ((Transform)this).getTx());
                this.setTy(d2 * ((Transform)this).getMyx() + ((Transform)this).getTy());
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = 4;
                }
                return;
            }
            case 4: {
                this.setTx(d3 * ((Transform)this).getMxy());
                this.setTy(d2 * ((Transform)this).getMyx());
                if (((Transform)this).getTx() != 0.0 || ((Transform)this).getTy() != 0.0) {
                    this.state2d = 5;
                }
                return;
            }
            case 3: {
                this.setTx(d2 * ((Transform)this).getMxx() + ((Transform)this).getTx());
                this.setTy(d3 * ((Transform)this).getMyy() + ((Transform)this).getTy());
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = 2;
                }
                return;
            }
            case 2: {
                this.setTx(d2 * ((Transform)this).getMxx());
                this.setTy(d3 * ((Transform)this).getMyy());
                if (((Transform)this).getTx() != 0.0 || ((Transform)this).getTy() != 0.0) {
                    this.state2d = 3;
                }
                return;
            }
            case 1: {
                this.setTx(d2 + ((Transform)this).getTx());
                this.setTy(d3 + ((Transform)this).getTy());
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = 0;
                }
                return;
            }
            case 0: 
        }
        this.setTx(d2);
        this.setTy(d3);
        if (d2 != 0.0 || d3 != 0.0) {
            this.state2d = 1;
        }
    }

    private void translate3D(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.translate2D(d2, d3);
                if (d4 != 0.0) {
                    this.setTz(d4);
                    if ((this.state2d & 4) == 0) {
                        this.state3d = this.state2d & 2 | 1;
                        return;
                    }
                    this.state3d = 4;
                }
                return;
            }
            case 1: {
                this.setTx(d2 + ((Transform)this).getTx());
                this.setTy(d3 + ((Transform)this).getTy());
                this.setTz(d4 + ((Transform)this).getTz());
                if (((Transform)this).getTz() == 0.0) {
                    this.state3d = 0;
                    if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                        this.state2d = 0;
                        return;
                    }
                    this.state2d = 1;
                }
                return;
            }
            case 2: {
                this.setTx(d2 * ((Transform)this).getMxx());
                this.setTy(d3 * ((Transform)this).getMyy());
                this.setTz(d4 * ((Transform)this).getMzz());
                if (((Transform)this).getTx() != 0.0 || ((Transform)this).getTy() != 0.0 || ((Transform)this).getTz() != 0.0) {
                    this.state3d |= 1;
                }
                return;
            }
            case 3: {
                this.setTx(d2 * ((Transform)this).getMxx() + ((Transform)this).getTx());
                this.setTy(d3 * ((Transform)this).getMyy() + ((Transform)this).getTy());
                this.setTz(d4 * ((Transform)this).getMzz() + ((Transform)this).getTz());
                if (((Transform)this).getTz() == 0.0) {
                    if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                        this.state3d = 2;
                    }
                    if (((Transform)this).getMzz() == 1.0) {
                        this.state2d = this.state3d;
                        this.state3d = 0;
                    }
                }
                return;
            }
            case 4: 
        }
        this.setTx(d2 * ((Transform)this).getMxx() + d3 * ((Transform)this).getMxy() + d4 * ((Transform)this).getMxz() + ((Transform)this).getTx());
        this.setTy(d2 * ((Transform)this).getMyx() + d3 * ((Transform)this).getMyy() + d4 * ((Transform)this).getMyz() + ((Transform)this).getTy());
        this.setTz(d2 * ((Transform)this).getMzx() + d3 * ((Transform)this).getMzy() + d4 * ((Transform)this).getMzz() + ((Transform)this).getTz());
        this.updateState();
    }

    public void prependTranslation(double d2, double d3, double d4) {
        this.atomicChange.start();
        this.preTranslate3D(d2, d3, d4);
        this.atomicChange.end();
    }

    public void prependTranslation(double d2, double d3) {
        this.atomicChange.start();
        this.preTranslate2D(d2, d3);
        this.atomicChange.end();
    }

    private void preTranslate2D(double d2, double d3) {
        if (this.state3d != 0) {
            this.preTranslate3D(d2, d3, 0.0);
            return;
        }
        Affine affine = this;
        affine.setTx(((Transform)affine).getTx() + d2);
        Affine affine2 = this;
        affine2.setTy(((Transform)affine2).getTy() + d3);
        if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
            this.state2d &= 0xFFFFFFFE;
            return;
        }
        this.state2d |= 1;
    }

    private void preTranslate3D(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.preTranslate2D(d2, d3);
                if (d4 != 0.0) {
                    this.setTz(d4);
                    if ((this.state2d & 4) == 0) {
                        this.state3d = this.state2d & 2 | 1;
                        return;
                    }
                    this.state3d = 4;
                }
                return;
            }
            case 1: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() + d2);
                Affine affine2 = this;
                affine2.setTy(((Transform)affine2).getTy() + d3);
                Affine affine3 = this;
                affine3.setTz(((Transform)affine3).getTz() + d4);
                if (((Transform)this).getTz() == 0.0) {
                    this.state3d = 0;
                    if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                        this.state2d = 0;
                        return;
                    }
                    this.state2d = 1;
                }
                return;
            }
            case 2: {
                this.setTx(d2);
                this.setTy(d3);
                this.setTz(d4);
                if (d2 != 0.0 || d3 != 0.0 || d4 != 0.0) {
                    this.state3d |= 1;
                }
                return;
            }
            case 3: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() + d2);
                Affine affine4 = this;
                affine4.setTy(((Transform)affine4).getTy() + d3);
                Affine affine5 = this;
                affine5.setTz(((Transform)affine5).getTz() + d4);
                if (((Transform)this).getTz() == 0.0) {
                    if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                        this.state3d = 2;
                    }
                    if (((Transform)this).getMzz() == 1.0) {
                        this.state2d = this.state3d;
                        this.state3d = 0;
                    }
                }
                return;
            }
            case 4: 
        }
        Affine affine = this;
        affine.setTx(((Transform)affine).getTx() + d2);
        Affine affine6 = this;
        affine6.setTy(((Transform)affine6).getTy() + d3);
        Affine affine7 = this;
        affine7.setTz(((Transform)affine7).getTz() + d4);
        if (((Transform)this).getTz() == 0.0 && ((Transform)this).getMxz() == 0.0 && ((Transform)this).getMyz() == 0.0 && ((Transform)this).getMzx() == 0.0 && ((Transform)this).getMzy() == 0.0 && ((Transform)this).getMzz() == 1.0) {
            this.state3d = 0;
            this.updateState2D();
        }
    }

    public void appendScale(double d2, double d3) {
        this.atomicChange.start();
        this.scale2D(d2, d3);
        this.atomicChange.end();
    }

    public void appendScale(double d2, double d3, double d4, double d5) {
        this.atomicChange.start();
        if (d4 != 0.0 || d5 != 0.0) {
            this.translate2D(d4, d5);
            this.scale2D(d2, d3);
            this.translate2D(-d4, -d5);
        } else {
            this.scale2D(d2, d3);
        }
        this.atomicChange.end();
    }

    public void appendScale(double d2, double d3, Point2D point2D) {
        this.appendScale(d2, d3, point2D.getX(), point2D.getY());
    }

    public void appendScale(double d2, double d3, double d4) {
        this.atomicChange.start();
        this.scale3D(d2, d3, d4);
        this.atomicChange.end();
    }

    public void appendScale(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.atomicChange.start();
        if (d5 != 0.0 || d6 != 0.0 || d7 != 0.0) {
            this.translate3D(d5, d6, d7);
            this.scale3D(d2, d3, d4);
            this.translate3D(-d5, -d6, -d7);
        } else {
            this.scale3D(d2, d3, d4);
        }
        this.atomicChange.end();
    }

    public void appendScale(double d2, double d3, double d4, Point3D point3D) {
        this.appendScale(d2, d3, d4, point3D.getX(), point3D.getY(), point3D.getZ());
    }

    private void scale2D(double d2, double d3) {
        if (this.state3d != 0) {
            this.scale3D(d2, d3, 1.0);
            return;
        }
        int n2 = this.state2d;
        switch (n2) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxx() * d2);
                Affine affine2 = this;
                affine2.setMyy(((Transform)affine2).getMyy() * d3);
            }
            case 4: 
            case 5: {
                Affine affine = this;
                affine.setMxy(((Transform)affine).getMxy() * d3);
                Affine affine3 = this;
                affine3.setMyx(((Transform)affine3).getMyx() * d2);
                if (((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
                    n2 &= 1;
                    if (((Transform)this).getMxx() != 1.0 || ((Transform)this).getMyy() != 1.0) {
                        n2 |= 2;
                    }
                    this.state2d = n2;
                    return;
                }
                if (((Transform)this).getMxx() == 0.0 && ((Transform)this).getMyy() == 0.0) {
                    this.state2d &= 0xFFFFFFFD;
                }
                return;
            }
            case 2: 
            case 3: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxx() * d2);
                Affine affine4 = this;
                affine4.setMyy(((Transform)affine4).getMyy() * d3);
                if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
                    this.state2d = n2 & 1;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.setMxx(d2);
        this.setMyy(d3);
        if (d2 != 1.0 || d3 != 1.0) {
            this.state2d = n2 | 2;
        }
    }

    private void scale3D(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.scale2D(d2, d3);
                if (d4 != 1.0) {
                    this.setMzz(d4);
                    if ((this.state2d & 4) == 0) {
                        this.state3d = this.state2d & 1 | 2;
                        return;
                    }
                    this.state3d = 4;
                }
                return;
            }
            case 1: {
                this.setMxx(d2);
                this.setMyy(d3);
                this.setMzz(d4);
                if (d2 != 1.0 || d3 != 1.0 || d4 != 1.0) {
                    this.state3d |= 2;
                }
                return;
            }
            case 2: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxx() * d2);
                Affine affine2 = this;
                affine2.setMyy(((Transform)affine2).getMyy() * d3);
                Affine affine3 = this;
                affine3.setMzz(((Transform)affine3).getMzz() * d4);
                if (((Transform)this).getMzz() == 1.0) {
                    this.state3d = 0;
                    if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
                        this.state2d = 0;
                        return;
                    }
                    this.state2d = 2;
                }
                return;
            }
            case 3: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxx() * d2);
                Affine affine4 = this;
                affine4.setMyy(((Transform)affine4).getMyy() * d3);
                Affine affine5 = this;
                affine5.setMzz(((Transform)affine5).getMzz() * d4);
                if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0 && ((Transform)this).getMzz() == 1.0) {
                    this.state3d &= 0xFFFFFFFD;
                }
                if (((Transform)this).getTz() == 0.0 && ((Transform)this).getMzz() == 1.0) {
                    this.state2d = this.state3d;
                    this.state3d = 0;
                }
                return;
            }
            case 4: 
        }
        Affine affine = this;
        affine.setMxx(((Transform)affine).getMxx() * d2);
        Affine affine6 = this;
        affine6.setMxy(((Transform)affine6).getMxy() * d3);
        Affine affine7 = this;
        affine7.setMxz(((Transform)affine7).getMxz() * d4);
        Affine affine8 = this;
        affine8.setMyx(((Transform)affine8).getMyx() * d2);
        Affine affine9 = this;
        affine9.setMyy(((Transform)affine9).getMyy() * d3);
        Affine affine10 = this;
        affine10.setMyz(((Transform)affine10).getMyz() * d4);
        Affine affine11 = this;
        affine11.setMzx(((Transform)affine11).getMzx() * d2);
        Affine affine12 = this;
        affine12.setMzy(((Transform)affine12).getMzy() * d3);
        Affine affine13 = this;
        affine13.setMzz(((Transform)affine13).getMzz() * d4);
        if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0) {
            this.updateState();
        }
    }

    public void prependScale(double d2, double d3) {
        this.atomicChange.start();
        this.preScale2D(d2, d3);
        this.atomicChange.end();
    }

    public void prependScale(double d2, double d3, double d4, double d5) {
        this.atomicChange.start();
        if (d4 != 0.0 || d5 != 0.0) {
            this.preTranslate2D(-d4, -d5);
            this.preScale2D(d2, d3);
            this.preTranslate2D(d4, d5);
        } else {
            this.preScale2D(d2, d3);
        }
        this.atomicChange.end();
    }

    public void prependScale(double d2, double d3, Point2D point2D) {
        this.prependScale(d2, d3, point2D.getX(), point2D.getY());
    }

    public void prependScale(double d2, double d3, double d4) {
        this.atomicChange.start();
        this.preScale3D(d2, d3, d4);
        this.atomicChange.end();
    }

    public void prependScale(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.atomicChange.start();
        if (d5 != 0.0 || d6 != 0.0 || d7 != 0.0) {
            this.preTranslate3D(-d5, -d6, -d7);
            this.preScale3D(d2, d3, d4);
            this.preTranslate3D(d5, d6, d7);
        } else {
            this.preScale3D(d2, d3, d4);
        }
        this.atomicChange.end();
    }

    public void prependScale(double d2, double d3, double d4, Point3D point3D) {
        this.prependScale(d2, d3, d4, point3D.getX(), point3D.getY(), point3D.getZ());
    }

    private void preScale2D(double d2, double d3) {
        if (this.state3d != 0) {
            this.preScale3D(d2, d3, 1.0);
            return;
        }
        int n2 = this.state2d;
        switch (n2) {
            default: {
                Affine.stateError();
            }
            case 7: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() * d2);
                Affine affine2 = this;
                affine2.setTy(((Transform)affine2).getTy() * d3);
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = n2 &= 0xFFFFFFFE;
                }
            }
            case 6: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxx() * d2);
                Affine affine3 = this;
                affine3.setMyy(((Transform)affine3).getMyy() * d3);
            }
            case 4: {
                Affine affine = this;
                affine.setMxy(((Transform)affine).getMxy() * d2);
                Affine affine4 = this;
                affine4.setMyx(((Transform)affine4).getMyx() * d3);
                if (((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
                    n2 &= 1;
                    if (((Transform)this).getMxx() != 1.0 || ((Transform)this).getMyy() != 1.0) {
                        n2 |= 2;
                    }
                    this.state2d = n2;
                }
                return;
            }
            case 5: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() * d2);
                Affine affine5 = this;
                affine5.setTy(((Transform)affine5).getTy() * d3);
                Affine affine6 = this;
                affine6.setMxy(((Transform)affine6).getMxy() * d2);
                Affine affine7 = this;
                affine7.setMyx(((Transform)affine7).getMyx() * d3);
                if (((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
                    if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                        this.state2d = 2;
                        return;
                    }
                    this.state2d = 3;
                    return;
                }
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = 4;
                }
                return;
            }
            case 3: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() * d2);
                Affine affine8 = this;
                affine8.setTy(((Transform)affine8).getTy() * d3);
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = n2 &= 0xFFFFFFFE;
                }
            }
            case 2: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxx() * d2);
                Affine affine9 = this;
                affine9.setMyy(((Transform)affine9).getMyy() * d3);
                if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
                    this.state2d = n2 & 1;
                }
                return;
            }
            case 1: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() * d2);
                Affine affine10 = this;
                affine10.setTy(((Transform)affine10).getTy() * d3);
                if (((Transform)this).getTx() != 0.0 || ((Transform)this).getTy() != 0.0) break;
                this.state2d = n2 &= 0xFFFFFFFE;
            }
            case 0: 
        }
        this.setMxx(d2);
        this.setMyy(d3);
        if (d2 != 1.0 || d3 != 1.0) {
            this.state2d = n2 | 2;
        }
    }

    private void preScale3D(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.preScale2D(d2, d3);
                if (d4 != 1.0) {
                    this.setMzz(d4);
                    if ((this.state2d & 4) == 0) {
                        this.state3d = this.state2d & 1 | 2;
                        return;
                    }
                    this.state3d = 4;
                }
                return;
            }
            case 3: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() * d2);
                Affine affine2 = this;
                affine2.setTy(((Transform)affine2).getTy() * d3);
                Affine affine3 = this;
                affine3.setTz(((Transform)affine3).getTz() * d4);
                Affine affine4 = this;
                affine4.setMxx(((Transform)affine4).getMxx() * d2);
                Affine affine5 = this;
                affine5.setMyy(((Transform)affine5).getMyy() * d3);
                Affine affine6 = this;
                affine6.setMzz(((Transform)affine6).getMzz() * d4);
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0 && ((Transform)this).getTz() == 0.0) {
                    this.state3d &= 0xFFFFFFFE;
                }
                if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0 && ((Transform)this).getMzz() == 1.0) {
                    this.state3d &= 0xFFFFFFFD;
                }
                if (((Transform)this).getTz() == 0.0 && ((Transform)this).getMzz() == 1.0) {
                    this.state2d = this.state3d;
                    this.state3d = 0;
                }
                return;
            }
            case 2: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxx() * d2);
                Affine affine7 = this;
                affine7.setMyy(((Transform)affine7).getMyy() * d3);
                Affine affine8 = this;
                affine8.setMzz(((Transform)affine8).getMzz() * d4);
                if (((Transform)this).getMzz() == 1.0) {
                    this.state3d = 0;
                    if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
                        this.state2d = 0;
                        return;
                    }
                    this.state2d = 2;
                }
                return;
            }
            case 1: {
                Affine affine = this;
                affine.setTx(((Transform)affine).getTx() * d2);
                Affine affine9 = this;
                affine9.setTy(((Transform)affine9).getTy() * d3);
                Affine affine10 = this;
                affine10.setTz(((Transform)affine10).getTz() * d4);
                this.setMxx(d2);
                this.setMyy(d3);
                this.setMzz(d4);
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0 && ((Transform)this).getTz() == 0.0) {
                    this.state3d &= 0xFFFFFFFE;
                }
                if (d2 != 1.0 || d3 != 1.0 || d4 != 1.0) {
                    this.state3d |= 2;
                }
                return;
            }
            case 4: 
        }
        Affine affine = this;
        affine.setMxx(((Transform)affine).getMxx() * d2);
        Affine affine11 = this;
        affine11.setMxy(((Transform)affine11).getMxy() * d2);
        Affine affine12 = this;
        affine12.setMxz(((Transform)affine12).getMxz() * d2);
        Affine affine13 = this;
        affine13.setTx(((Transform)affine13).getTx() * d2);
        Affine affine14 = this;
        affine14.setMyx(((Transform)affine14).getMyx() * d3);
        Affine affine15 = this;
        affine15.setMyy(((Transform)affine15).getMyy() * d3);
        Affine affine16 = this;
        affine16.setMyz(((Transform)affine16).getMyz() * d3);
        Affine affine17 = this;
        affine17.setTy(((Transform)affine17).getTy() * d3);
        Affine affine18 = this;
        affine18.setMzx(((Transform)affine18).getMzx() * d4);
        Affine affine19 = this;
        affine19.setMzy(((Transform)affine19).getMzy() * d4);
        Affine affine20 = this;
        affine20.setMzz(((Transform)affine20).getMzz() * d4);
        Affine affine21 = this;
        affine21.setTz(((Transform)affine21).getTz() * d4);
        if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0) {
            this.updateState();
        }
    }

    public void appendShear(double d2, double d3) {
        this.atomicChange.start();
        this.shear2D(d2, d3);
        this.atomicChange.end();
    }

    public void appendShear(double d2, double d3, double d4, double d5) {
        this.atomicChange.start();
        if (d4 != 0.0 || d5 != 0.0) {
            this.translate2D(d4, d5);
            this.shear2D(d2, d3);
            this.translate2D(-d4, -d5);
        } else {
            this.shear2D(d2, d3);
        }
        this.atomicChange.end();
    }

    public void appendShear(double d2, double d3, Point2D point2D) {
        this.appendShear(d2, d3, point2D.getX(), point2D.getY());
    }

    private void shear2D(double d2, double d3) {
        if (this.state3d != 0) {
            this.shear3D(d2, d3);
            return;
        }
        int n2 = this.state2d;
        switch (n2) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                double d4 = ((Transform)this).getMxx();
                double d5 = ((Transform)this).getMxy();
                this.setMxx(d4 + d5 * d3);
                this.setMxy(d4 * d2 + d5);
                d4 = ((Transform)this).getMyx();
                d5 = ((Transform)this).getMyy();
                this.setMyx(d4 + d5 * d3);
                this.setMyy(d4 * d2 + d5);
                this.updateState2D();
                return;
            }
            case 4: 
            case 5: {
                Affine affine = this;
                affine.setMxx(((Transform)affine).getMxy() * d3);
                Affine affine2 = this;
                affine2.setMyy(((Transform)affine2).getMyx() * d2);
                if (((Transform)this).getMxx() != 0.0 || ((Transform)this).getMyy() != 0.0) {
                    this.state2d = n2 | 2;
                }
                return;
            }
            case 2: 
            case 3: {
                Affine affine = this;
                affine.setMxy(((Transform)affine).getMxx() * d2);
                Affine affine3 = this;
                affine3.setMyx(((Transform)affine3).getMyy() * d3);
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state2d = n2 | 4;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.setMxy(d2);
        this.setMyx(d3);
        if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
            this.state2d = n2 | 2 | 4;
        }
    }

    private void shear3D(double d2, double d3) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.shear2D(d2, d3);
                return;
            }
            case 1: {
                this.setMxy(d2);
                this.setMyx(d3);
                if (d2 != 0.0 || d3 != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 2: 
            case 3: {
                Affine affine = this;
                affine.setMxy(((Transform)affine).getMxx() * d2);
                Affine affine2 = this;
                affine2.setMyx(((Transform)affine2).getMyy() * d3);
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        double d4 = ((Transform)this).getMxx();
        double d5 = ((Transform)this).getMxy();
        double d6 = ((Transform)this).getMyx();
        double d7 = ((Transform)this).getMyy();
        double d8 = ((Transform)this).getMzx();
        double d9 = ((Transform)this).getMzy();
        this.setMxx(d4 + d5 * d3);
        this.setMxy(d5 + d4 * d2);
        this.setMyx(d6 + d7 * d3);
        this.setMyy(d7 + d6 * d2);
        this.setMzx(d8 + d9 * d3);
        this.setMzy(d9 + d8 * d2);
        this.updateState();
    }

    public void prependShear(double d2, double d3) {
        this.atomicChange.start();
        this.preShear2D(d2, d3);
        this.atomicChange.end();
    }

    public void prependShear(double d2, double d3, double d4, double d5) {
        this.atomicChange.start();
        if (d4 != 0.0 || d5 != 0.0) {
            this.preTranslate2D(-d4, -d5);
            this.preShear2D(d2, d3);
            this.preTranslate2D(d4, d5);
        } else {
            this.preShear2D(d2, d3);
        }
        this.atomicChange.end();
    }

    public void prependShear(double d2, double d3, Point2D point2D) {
        this.prependShear(d2, d3, point2D.getX(), point2D.getY());
    }

    private void preShear2D(double d2, double d3) {
        if (this.state3d != 0) {
            this.preShear3D(d2, d3);
            return;
        }
        int n2 = this.state2d;
        switch (n2) {
            default: {
                Affine.stateError();
            }
            case 5: 
            case 7: {
                double d4 = ((Transform)this).getTx();
                double d5 = ((Transform)this).getTy();
                this.setTx(d4 + d2 * d5);
                this.setTy(d5 + d3 * d4);
            }
            case 4: 
            case 6: {
                double d6 = ((Transform)this).getMxx();
                double d7 = ((Transform)this).getMxy();
                double d8 = ((Transform)this).getMyx();
                double d9 = ((Transform)this).getMyy();
                this.setMxx(d6 + d2 * d8);
                this.setMxy(d7 + d2 * d9);
                this.setMyx(d3 * d6 + d8);
                this.setMyy(d3 * d7 + d9);
                this.updateState2D();
                return;
            }
            case 3: {
                double d10 = ((Transform)this).getTx();
                double d11 = ((Transform)this).getTy();
                this.setTx(d10 + d2 * d11);
                this.setTy(d11 + d3 * d10);
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = n2 &= 0xFFFFFFFE;
                }
            }
            case 2: {
                this.setMxy(d2 * ((Transform)this).getMyy());
                this.setMyx(d3 * ((Transform)this).getMxx());
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state2d = n2 | 4;
                }
                return;
            }
            case 1: {
                double d12 = ((Transform)this).getTx();
                double d13 = ((Transform)this).getTy();
                this.setTx(d12 + d2 * d13);
                this.setTy(d13 + d3 * d12);
                if (((Transform)this).getTx() != 0.0 || ((Transform)this).getTy() != 0.0) break;
                this.state2d = n2 &= 0xFFFFFFFE;
            }
            case 0: 
        }
        this.setMxy(d2);
        this.setMyx(d3);
        if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
            this.state2d = n2 | 2 | 4;
        }
    }

    private void preShear3D(double d2, double d3) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.preShear2D(d2, d3);
                return;
            }
            case 1: {
                double d4 = ((Transform)this).getTx();
                this.setMxy(d2);
                this.setTx(d4 + ((Transform)this).getTy() * d2);
                this.setMyx(d3);
                this.setTy(d4 * d3 + ((Transform)this).getTy());
                if (d2 != 0.0 || d3 != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 2: {
                Affine affine = this;
                affine.setMxy(((Transform)affine).getMyy() * d2);
                Affine affine2 = this;
                affine2.setMyx(((Transform)affine2).getMxx() * d3);
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 3: {
                double d5 = ((Transform)this).getTx();
                Affine affine = this;
                affine.setMxy(((Transform)affine).getMyy() * d2);
                this.setTx(d5 + ((Transform)this).getTy() * d2);
                Affine affine3 = this;
                affine3.setMyx(((Transform)affine3).getMxx() * d3);
                this.setTy(d5 * d3 + ((Transform)this).getTy());
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        double d6 = ((Transform)this).getMxx();
        double d7 = ((Transform)this).getMxy();
        double d8 = ((Transform)this).getMyx();
        double d9 = ((Transform)this).getTx();
        double d10 = ((Transform)this).getMyy();
        double d11 = ((Transform)this).getMxz();
        double d12 = ((Transform)this).getMyz();
        double d13 = ((Transform)this).getTy();
        this.setMxx(d6 + d8 * d2);
        this.setMxy(d7 + d10 * d2);
        this.setMxz(d11 + d12 * d2);
        this.setTx(d9 + d13 * d2);
        this.setMyx(d6 * d3 + d8);
        this.setMyy(d7 * d3 + d10);
        this.setMyz(d11 * d3 + d12);
        this.setTy(d9 * d3 + d13);
        this.updateState();
    }

    public void appendRotation(double d2) {
        this.atomicChange.start();
        this.rotate2D(d2);
        this.atomicChange.end();
    }

    public void appendRotation(double d2, double d3, double d4) {
        this.atomicChange.start();
        if (d3 != 0.0 || d4 != 0.0) {
            this.translate2D(d3, d4);
            this.rotate2D(d2);
            this.translate2D(-d3, -d4);
        } else {
            this.rotate2D(d2);
        }
        this.atomicChange.end();
    }

    public void appendRotation(double d2, Point2D point2D) {
        this.appendRotation(d2, point2D.getX(), point2D.getY());
    }

    public void appendRotation(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.atomicChange.start();
        if (d3 != 0.0 || d4 != 0.0 || d5 != 0.0) {
            this.translate3D(d3, d4, d5);
            this.rotate3D(d2, d6, d7, d8);
            this.translate3D(-d3, -d4, -d5);
        } else {
            this.rotate3D(d2, d6, d7, d8);
        }
        this.atomicChange.end();
    }

    public void appendRotation(double d2, double d3, double d4, double d5, Point3D point3D) {
        this.appendRotation(d2, d3, d4, d5, point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void appendRotation(double d2, Point3D point3D, Point3D point3D2) {
        this.appendRotation(d2, point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ());
    }

    private void rotate3D(double d2, double d3, double d4, double d5) {
        if (d3 == 0.0 && d4 == 0.0) {
            if (d5 > 0.0) {
                this.rotate3D(d2);
                return;
            }
            if (d5 < 0.0) {
                this.rotate3D(-d2);
            }
            return;
        }
        double d6 = d3;
        double d7 = d4;
        double d8 = d5;
        double d9 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8);
        if (d9 == 0.0) {
            return;
        }
        d9 = 1.0 / d9;
        double d10 = d3 * d9;
        double d11 = d4 * d9;
        double d12 = d5 * d9;
        double d13 = Math.sin(Math.toRadians(d2));
        double d14 = Math.cos(Math.toRadians(d2));
        double d15 = 1.0 - d14;
        double d16 = d10 * d12;
        double d17 = d10 * d11;
        double d18 = d11 * d12;
        double d19 = d15 * d10 * d10 + d14;
        double d20 = d15 * d17 - d13 * d12;
        double d21 = d15 * d16 + d13 * d11;
        double d22 = d15 * d17 + d13 * d12;
        double d23 = d15 * d11 * d11 + d14;
        double d24 = d15 * d18 - d13 * d10;
        double d25 = d15 * d16 - d13 * d11;
        double d26 = d15 * d18 + d13 * d10;
        double d27 = d15 * d12 * d12 + d14;
        block0 : switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 6: 
                    case 7: {
                        double d28 = ((Transform)this).getMxx();
                        double d29 = ((Transform)this).getMxy();
                        double d30 = ((Transform)this).getMyx();
                        double d31 = ((Transform)this).getMyy();
                        this.setMxx(d28 * d19 + d29 * d22);
                        this.setMxy(d28 * d20 + d29 * d23);
                        this.setMxz(d28 * d21 + d29 * d24);
                        this.setMyx(d30 * d19 + d31 * d22);
                        this.setMyy(d30 * d20 + d31 * d23);
                        this.setMyz(d30 * d21 + d31 * d24);
                        this.setMzx(d25);
                        this.setMzy(d26);
                        this.setMzz(d27);
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        double d32 = ((Transform)this).getMxy();
                        double d33 = ((Transform)this).getMyx();
                        this.setMxx(d32 * d22);
                        this.setMxy(d32 * d23);
                        this.setMxz(d32 * d24);
                        this.setMyx(d33 * d19);
                        this.setMyy(d33 * d20);
                        this.setMyz(d33 * d21);
                        this.setMzx(d25);
                        this.setMzy(d26);
                        this.setMzz(d27);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        double d34 = ((Transform)this).getMxx();
                        double d35 = ((Transform)this).getMyy();
                        this.setMxx(d34 * d19);
                        this.setMxy(d34 * d20);
                        this.setMxz(d34 * d21);
                        this.setMyx(d35 * d22);
                        this.setMyy(d35 * d23);
                        this.setMyz(d35 * d24);
                        this.setMzx(d25);
                        this.setMzy(d26);
                        this.setMzz(d27);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                }
                this.setMxx(d19);
                this.setMxy(d20);
                this.setMxz(d21);
                this.setMyx(d22);
                this.setMyy(d23);
                this.setMyz(d24);
                this.setMzx(d25);
                this.setMzy(d26);
                this.setMzz(d27);
                break;
            }
            case 1: {
                this.setMxx(d19);
                this.setMxy(d20);
                this.setMxz(d21);
                this.setMyx(d22);
                this.setMyy(d23);
                this.setMyz(d24);
                this.setMzx(d25);
                this.setMzy(d26);
                this.setMzz(d27);
                break;
            }
            case 2: 
            case 3: {
                double d36 = ((Transform)this).getMxx();
                double d37 = ((Transform)this).getMyy();
                double d38 = ((Transform)this).getMzz();
                this.setMxx(d36 * d19);
                this.setMxy(d36 * d20);
                this.setMxz(d36 * d21);
                this.setMyx(d37 * d22);
                this.setMyy(d37 * d23);
                this.setMyz(d37 * d24);
                this.setMzx(d38 * d25);
                this.setMzy(d38 * d26);
                this.setMzz(d38 * d27);
                break;
            }
            case 4: {
                double d39 = ((Transform)this).getMxx();
                double d40 = ((Transform)this).getMxy();
                double d41 = ((Transform)this).getMxz();
                double d42 = ((Transform)this).getMyx();
                double d43 = ((Transform)this).getMyy();
                double d44 = ((Transform)this).getMyz();
                double d45 = ((Transform)this).getMzx();
                double d46 = ((Transform)this).getMzy();
                double d47 = ((Transform)this).getMzz();
                this.setMxx(d39 * d19 + d40 * d22 + d41 * d25);
                this.setMxy(d39 * d20 + d40 * d23 + d41 * d26);
                this.setMxz(d39 * d21 + d40 * d24 + d41 * d27);
                this.setMyx(d42 * d19 + d43 * d22 + d44 * d25);
                this.setMyy(d42 * d20 + d43 * d23 + d44 * d26);
                this.setMyz(d42 * d21 + d43 * d24 + d44 * d27);
                this.setMzx(d45 * d19 + d46 * d22 + d47 * d25);
                this.setMzy(d45 * d20 + d46 * d23 + d47 * d26);
                this.setMzz(d45 * d21 + d46 * d24 + d47 * d27);
            }
        }
        this.updateState();
    }

    private void rotate2D(double d2) {
        if (this.state3d != 0) {
            this.rotate3D(d2);
            return;
        }
        double d3 = Math.sin(Math.toRadians(d2));
        if (d3 == 1.0) {
            this.rotate2D_90();
            return;
        }
        if (d3 == -1.0) {
            this.rotate2D_270();
            return;
        }
        double d4 = Math.cos(Math.toRadians(d2));
        if (d4 == -1.0) {
            this.rotate2D_180();
            return;
        }
        if (d4 != 1.0) {
            double d5 = ((Transform)this).getMxx();
            double d6 = ((Transform)this).getMxy();
            this.setMxx(d4 * d5 + d3 * d6);
            this.setMxy(-d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getMyx();
            d6 = ((Transform)this).getMyy();
            this.setMyx(d4 * d5 + d3 * d6);
            this.setMyy(-d3 * d5 + d4 * d6);
            this.updateState2D();
        }
    }

    private void rotate2D_90() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(((Transform)affine).getMxy());
        this.setMxy(-d2);
        d2 = ((Transform)this).getMyx();
        Affine affine2 = this;
        affine2.setMyx(((Transform)affine2).getMyy());
        this.setMyy(-d2);
        int n2 = rot90conversion[this.state2d];
        if ((n2 & 6) == 2 && ((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
            n2 -= 2;
        } else if ((n2 & 6) == 4 && ((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
            n2 = n2 & 0xFFFFFFFB | 2;
        }
        this.state2d = n2;
    }

    private void rotate2D_180() {
        Affine affine = this;
        affine.setMxx(-((Transform)affine).getMxx());
        Affine affine2 = this;
        affine2.setMyy(-((Transform)affine2).getMyy());
        int n2 = this.state2d;
        if ((n2 & 4) != 0) {
            Affine affine3 = this;
            affine3.setMxy(-((Transform)affine3).getMxy());
            Affine affine4 = this;
            affine4.setMyx(-((Transform)affine4).getMyx());
            return;
        }
        if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
            this.state2d = n2 & 0xFFFFFFFD;
            return;
        }
        this.state2d = n2 | 2;
    }

    private void rotate2D_270() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(-((Transform)affine).getMxy());
        this.setMxy(d2);
        d2 = ((Transform)this).getMyx();
        Affine affine2 = this;
        affine2.setMyx(-((Transform)affine2).getMyy());
        this.setMyy(d2);
        int n2 = rot90conversion[this.state2d];
        if ((n2 & 6) == 2 && ((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
            n2 -= 2;
        } else if ((n2 & 6) == 4 && ((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
            n2 = n2 & 0xFFFFFFFB | 2;
        }
        this.state2d = n2;
    }

    private void rotate3D(double d2) {
        if (this.state3d == 0) {
            this.rotate2D(d2);
            return;
        }
        double d3 = Math.sin(Math.toRadians(d2));
        if (d3 == 1.0) {
            this.rotate3D_90();
            return;
        }
        if (d3 == -1.0) {
            this.rotate3D_270();
            return;
        }
        double d4 = Math.cos(Math.toRadians(d2));
        if (d4 == -1.0) {
            this.rotate3D_180();
            return;
        }
        if (d4 != 1.0) {
            double d5 = ((Transform)this).getMxx();
            double d6 = ((Transform)this).getMxy();
            this.setMxx(d4 * d5 + d3 * d6);
            this.setMxy(-d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getMyx();
            d6 = ((Transform)this).getMyy();
            this.setMyx(d4 * d5 + d3 * d6);
            this.setMyy(-d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getMzx();
            d6 = ((Transform)this).getMzy();
            this.setMzx(d4 * d5 + d3 * d6);
            this.setMzy(-d3 * d5 + d4 * d6);
            this.updateState();
        }
    }

    private void rotate3D_90() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(((Transform)affine).getMxy());
        this.setMxy(-d2);
        d2 = ((Transform)this).getMyx();
        Affine affine2 = this;
        affine2.setMyx(((Transform)affine2).getMyy());
        this.setMyy(-d2);
        d2 = ((Transform)this).getMzx();
        Affine affine3 = this;
        affine3.setMzx(((Transform)affine3).getMzy());
        this.setMzy(-d2);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    private void rotate3D_180() {
        double d2 = ((Transform)this).getMxx();
        double d3 = ((Transform)this).getMyy();
        this.setMxx(-d2);
        this.setMyy(-d3);
        if (this.state3d == 4) {
            Affine affine = this;
            affine.setMxy(-((Transform)affine).getMxy());
            Affine affine2 = this;
            affine2.setMyx(-((Transform)affine2).getMyx());
            Affine affine3 = this;
            affine3.setMzx(-((Transform)affine3).getMzx());
            Affine affine4 = this;
            affine4.setMzy(-((Transform)affine4).getMzy());
            this.updateState();
            return;
        }
        if (d2 == -1.0 && d3 == -1.0 && ((Transform)this).getMzz() == 1.0) {
            this.state3d &= 0xFFFFFFFD;
            return;
        }
        this.state3d |= 2;
    }

    private void rotate3D_270() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(-((Transform)affine).getMxy());
        this.setMxy(d2);
        d2 = ((Transform)this).getMyx();
        Affine affine2 = this;
        affine2.setMyx(-((Transform)affine2).getMyy());
        this.setMyy(d2);
        d2 = ((Transform)this).getMzx();
        Affine affine3 = this;
        affine3.setMzx(-((Transform)affine3).getMzy());
        this.setMzy(d2);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    public void prependRotation(double d2) {
        this.atomicChange.start();
        this.preRotate2D(d2);
        this.atomicChange.end();
    }

    public void prependRotation(double d2, double d3, double d4) {
        this.atomicChange.start();
        if (d3 != 0.0 || d4 != 0.0) {
            this.preTranslate2D(-d3, -d4);
            this.preRotate2D(d2);
            this.preTranslate2D(d3, d4);
        } else {
            this.preRotate2D(d2);
        }
        this.atomicChange.end();
    }

    public void prependRotation(double d2, Point2D point2D) {
        this.prependRotation(d2, point2D.getX(), point2D.getY());
    }

    public void prependRotation(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.atomicChange.start();
        if (d3 != 0.0 || d4 != 0.0 || d5 != 0.0) {
            this.preTranslate3D(-d3, -d4, -d5);
            this.preRotate3D(d2, d6, d7, d8);
            this.preTranslate3D(d3, d4, d5);
        } else {
            this.preRotate3D(d2, d6, d7, d8);
        }
        this.atomicChange.end();
    }

    public void prependRotation(double d2, double d3, double d4, double d5, Point3D point3D) {
        this.prependRotation(d2, d3, d4, d5, point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void prependRotation(double d2, Point3D point3D, Point3D point3D2) {
        this.prependRotation(d2, point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ());
    }

    private void preRotate3D(double d2, double d3, double d4, double d5) {
        if (d3 == 0.0 && d4 == 0.0) {
            if (d5 > 0.0) {
                this.preRotate3D(d2);
                return;
            }
            if (d5 < 0.0) {
                this.preRotate3D(-d2);
            }
            return;
        }
        double d6 = d3;
        double d7 = d4;
        double d8 = d5;
        double d9 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8);
        if (d9 == 0.0) {
            return;
        }
        d9 = 1.0 / d9;
        double d10 = d3 * d9;
        double d11 = d4 * d9;
        double d12 = d5 * d9;
        double d13 = Math.sin(Math.toRadians(d2));
        double d14 = Math.cos(Math.toRadians(d2));
        double d15 = 1.0 - d14;
        double d16 = d10 * d12;
        double d17 = d10 * d11;
        double d18 = d11 * d12;
        double d19 = d15 * d10 * d10 + d14;
        double d20 = d15 * d17 - d13 * d12;
        double d21 = d15 * d16 + d13 * d11;
        double d22 = d15 * d17 + d13 * d12;
        double d23 = d15 * d11 * d11 + d14;
        double d24 = d15 * d18 - d13 * d10;
        double d25 = d15 * d16 - d13 * d11;
        double d26 = d15 * d18 + d13 * d10;
        double d27 = d15 * d12 * d12 + d14;
        block0 : switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 7: {
                        double d28 = ((Transform)this).getMxx();
                        double d29 = ((Transform)this).getMxy();
                        double d30 = ((Transform)this).getTx();
                        double d31 = ((Transform)this).getMyx();
                        double d32 = ((Transform)this).getMyy();
                        double d33 = ((Transform)this).getTy();
                        this.setMxx(d19 * d28 + d20 * d31);
                        this.setMxy(d19 * d29 + d20 * d32);
                        this.setMxz(d21);
                        this.setTx(d19 * d30 + d20 * d33);
                        this.setMyx(d22 * d28 + d23 * d31);
                        this.setMyy(d22 * d29 + d23 * d32);
                        this.setMyz(d24);
                        this.setTy(d22 * d30 + d23 * d33);
                        this.setMzx(d25 * d28 + d26 * d31);
                        this.setMzy(d25 * d29 + d26 * d32);
                        this.setMzz(d27);
                        this.setTz(d25 * d30 + d26 * d33);
                        break block0;
                    }
                    case 6: {
                        double d34 = ((Transform)this).getMxx();
                        double d35 = ((Transform)this).getMxy();
                        double d36 = ((Transform)this).getMyx();
                        double d37 = ((Transform)this).getMyy();
                        this.setMxx(d19 * d34 + d20 * d36);
                        this.setMxy(d19 * d35 + d20 * d37);
                        this.setMxz(d21);
                        this.setMyx(d22 * d34 + d23 * d36);
                        this.setMyy(d22 * d35 + d23 * d37);
                        this.setMyz(d24);
                        this.setMzx(d25 * d34 + d26 * d36);
                        this.setMzy(d25 * d35 + d26 * d37);
                        this.setMzz(d27);
                        break block0;
                    }
                    case 5: {
                        double d38 = ((Transform)this).getMxy();
                        double d39 = ((Transform)this).getTx();
                        double d40 = ((Transform)this).getMyx();
                        double d41 = ((Transform)this).getTy();
                        this.setMxx(d20 * d40);
                        this.setMxy(d19 * d38);
                        this.setMxz(d21);
                        this.setTx(d19 * d39 + d20 * d41);
                        this.setMyx(d23 * d40);
                        this.setMyy(d22 * d38);
                        this.setMyz(d24);
                        this.setTy(d22 * d39 + d23 * d41);
                        this.setMzx(d26 * d40);
                        this.setMzy(d25 * d38);
                        this.setMzz(d27);
                        this.setTz(d25 * d39 + d26 * d41);
                        break block0;
                    }
                    case 4: {
                        double d42 = ((Transform)this).getMxy();
                        double d43 = ((Transform)this).getMyx();
                        this.setMxx(d20 * d43);
                        this.setMxy(d19 * d42);
                        this.setMxz(d21);
                        this.setMyx(d23 * d43);
                        this.setMyy(d22 * d42);
                        this.setMyz(d24);
                        this.setMzx(d26 * d43);
                        this.setMzy(d25 * d42);
                        this.setMzz(d27);
                        break block0;
                    }
                    case 3: {
                        double d44 = ((Transform)this).getMxx();
                        double d45 = ((Transform)this).getTx();
                        double d46 = ((Transform)this).getMyy();
                        double d47 = ((Transform)this).getTy();
                        this.setMxx(d19 * d44);
                        this.setMxy(d20 * d46);
                        this.setMxz(d21);
                        this.setTx(d19 * d45 + d20 * d47);
                        this.setMyx(d22 * d44);
                        this.setMyy(d23 * d46);
                        this.setMyz(d24);
                        this.setTy(d22 * d45 + d23 * d47);
                        this.setMzx(d25 * d44);
                        this.setMzy(d26 * d46);
                        this.setMzz(d27);
                        this.setTz(d25 * d45 + d26 * d47);
                        break block0;
                    }
                    case 2: {
                        double d48 = ((Transform)this).getMxx();
                        double d49 = ((Transform)this).getMyy();
                        this.setMxx(d19 * d48);
                        this.setMxy(d20 * d49);
                        this.setMxz(d21);
                        this.setMyx(d22 * d48);
                        this.setMyy(d23 * d49);
                        this.setMyz(d24);
                        this.setMzx(d25 * d48);
                        this.setMzy(d26 * d49);
                        this.setMzz(d27);
                        break block0;
                    }
                    case 1: {
                        double d50 = ((Transform)this).getTx();
                        double d51 = ((Transform)this).getTy();
                        this.setMxx(d19);
                        this.setMxy(d20);
                        this.setMxz(d21);
                        this.setTx(d19 * d50 + d20 * d51);
                        this.setMyx(d22);
                        this.setMyy(d23);
                        this.setMyz(d24);
                        this.setTy(d22 * d50 + d23 * d51);
                        this.setMzx(d25);
                        this.setMzy(d26);
                        this.setMzz(d27);
                        this.setTz(d25 * d50 + d26 * d51);
                        break block0;
                    }
                    case 0: 
                }
                this.setMxx(d19);
                this.setMxy(d20);
                this.setMxz(d21);
                this.setMyx(d22);
                this.setMyy(d23);
                this.setMyz(d24);
                this.setMzx(d25);
                this.setMzy(d26);
                this.setMzz(d27);
                break;
            }
            case 1: {
                double d52 = ((Transform)this).getTx();
                double d53 = ((Transform)this).getTy();
                double d54 = ((Transform)this).getTz();
                this.setMxx(d19);
                this.setMxy(d20);
                this.setMxz(d21);
                this.setMyx(d22);
                this.setMyy(d23);
                this.setMyz(d24);
                this.setMzx(d25);
                this.setMzy(d26);
                this.setMzz(d27);
                this.setTx(d19 * d52 + d20 * d53 + d21 * d54);
                this.setTy(d22 * d52 + d23 * d53 + d24 * d54);
                this.setTz(d25 * d52 + d26 * d53 + d27 * d54);
                break;
            }
            case 2: {
                double d55 = ((Transform)this).getMxx();
                double d56 = ((Transform)this).getMyy();
                double d57 = ((Transform)this).getMzz();
                this.setMxx(d19 * d55);
                this.setMxy(d20 * d56);
                this.setMxz(d21 * d57);
                this.setMyx(d22 * d55);
                this.setMyy(d23 * d56);
                this.setMyz(d24 * d57);
                this.setMzx(d25 * d55);
                this.setMzy(d26 * d56);
                this.setMzz(d27 * d57);
                break;
            }
            case 3: {
                double d58 = ((Transform)this).getMxx();
                double d59 = ((Transform)this).getTx();
                double d60 = ((Transform)this).getMyy();
                double d61 = ((Transform)this).getTy();
                double d62 = ((Transform)this).getMzz();
                double d63 = ((Transform)this).getTz();
                this.setMxx(d19 * d58);
                this.setMxy(d20 * d60);
                this.setMxz(d21 * d62);
                this.setTx(d19 * d59 + d20 * d61 + d21 * d63);
                this.setMyx(d22 * d58);
                this.setMyy(d23 * d60);
                this.setMyz(d24 * d62);
                this.setTy(d22 * d59 + d23 * d61 + d24 * d63);
                this.setMzx(d25 * d58);
                this.setMzy(d26 * d60);
                this.setMzz(d27 * d62);
                this.setTz(d25 * d59 + d26 * d61 + d27 * d63);
                break;
            }
            case 4: {
                double d64 = ((Transform)this).getMxx();
                double d65 = ((Transform)this).getMxy();
                double d66 = ((Transform)this).getMxz();
                double d67 = ((Transform)this).getTx();
                double d68 = ((Transform)this).getMyx();
                double d69 = ((Transform)this).getMyy();
                double d70 = ((Transform)this).getMyz();
                double d71 = ((Transform)this).getTy();
                double d72 = ((Transform)this).getMzx();
                double d73 = ((Transform)this).getMzy();
                double d74 = ((Transform)this).getMzz();
                double d75 = ((Transform)this).getTz();
                this.setMxx(d19 * d64 + d20 * d68 + d21 * d72);
                this.setMxy(d19 * d65 + d20 * d69 + d21 * d73);
                this.setMxz(d19 * d66 + d20 * d70 + d21 * d74);
                this.setTx(d19 * d67 + d20 * d71 + d21 * d75);
                this.setMyx(d22 * d64 + d23 * d68 + d24 * d72);
                this.setMyy(d22 * d65 + d23 * d69 + d24 * d73);
                this.setMyz(d22 * d66 + d23 * d70 + d24 * d74);
                this.setTy(d22 * d67 + d23 * d71 + d24 * d75);
                this.setMzx(d25 * d64 + d26 * d68 + d27 * d72);
                this.setMzy(d25 * d65 + d26 * d69 + d27 * d73);
                this.setMzz(d25 * d66 + d26 * d70 + d27 * d74);
                this.setTz(d25 * d67 + d26 * d71 + d27 * d75);
            }
        }
        this.updateState();
    }

    private void preRotate2D(double d2) {
        if (this.state3d != 0) {
            this.preRotate3D(d2);
            return;
        }
        double d3 = Math.sin(Math.toRadians(d2));
        if (d3 == 1.0) {
            this.preRotate2D_90();
            return;
        }
        if (d3 == -1.0) {
            this.preRotate2D_270();
            return;
        }
        double d4 = Math.cos(Math.toRadians(d2));
        if (d4 == -1.0) {
            this.preRotate2D_180();
            return;
        }
        if (d4 != 1.0) {
            double d5 = ((Transform)this).getMxx();
            double d6 = ((Transform)this).getMyx();
            this.setMxx(d4 * d5 - d3 * d6);
            this.setMyx(d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getMxy();
            d6 = ((Transform)this).getMyy();
            this.setMxy(d4 * d5 - d3 * d6);
            this.setMyy(d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getTx();
            d6 = ((Transform)this).getTy();
            this.setTx(d4 * d5 - d3 * d6);
            this.setTy(d3 * d5 + d4 * d6);
            this.updateState2D();
        }
    }

    private void preRotate2D_90() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(-((Transform)affine).getMyx());
        this.setMyx(d2);
        d2 = ((Transform)this).getMxy();
        Affine affine2 = this;
        affine2.setMxy(-((Transform)affine2).getMyy());
        this.setMyy(d2);
        d2 = ((Transform)this).getTx();
        Affine affine3 = this;
        affine3.setTx(-((Transform)affine3).getTy());
        this.setTy(d2);
        int n2 = rot90conversion[this.state2d];
        if ((n2 & 6) == 2 && ((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
            n2 -= 2;
        } else if ((n2 & 6) == 4 && ((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
            n2 = n2 & 0xFFFFFFFB | 2;
        }
        this.state2d = n2;
    }

    private void preRotate2D_180() {
        Affine affine = this;
        affine.setMxx(-((Transform)affine).getMxx());
        Affine affine2 = this;
        affine2.setMxy(-((Transform)affine2).getMxy());
        Affine affine3 = this;
        affine3.setTx(-((Transform)affine3).getTx());
        Affine affine4 = this;
        affine4.setMyx(-((Transform)affine4).getMyx());
        Affine affine5 = this;
        affine5.setMyy(-((Transform)affine5).getMyy());
        Affine affine6 = this;
        affine6.setTy(-((Transform)affine6).getTy());
        if ((this.state2d & 4) != 0) {
            if (((Transform)this).getMxx() == 0.0 && ((Transform)this).getMyy() == 0.0) {
                this.state2d &= 0xFFFFFFFD;
                return;
            }
            this.state2d |= 2;
            return;
        }
        if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
            this.state2d &= 0xFFFFFFFD;
            return;
        }
        this.state2d |= 2;
    }

    private void preRotate2D_270() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(((Transform)affine).getMyx());
        this.setMyx(-d2);
        d2 = ((Transform)this).getMxy();
        Affine affine2 = this;
        affine2.setMxy(((Transform)affine2).getMyy());
        this.setMyy(-d2);
        d2 = ((Transform)this).getTx();
        Affine affine3 = this;
        affine3.setTx(((Transform)affine3).getTy());
        this.setTy(-d2);
        int n2 = rot90conversion[this.state2d];
        if ((n2 & 6) == 2 && ((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
            n2 -= 2;
        } else if ((n2 & 6) == 4 && ((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
            n2 = n2 & 0xFFFFFFFB | 2;
        }
        this.state2d = n2;
    }

    private void preRotate3D(double d2) {
        if (this.state3d == 0) {
            this.preRotate2D(d2);
            return;
        }
        double d3 = Math.sin(Math.toRadians(d2));
        if (d3 == 1.0) {
            this.preRotate3D_90();
            return;
        }
        if (d3 == -1.0) {
            this.preRotate3D_270();
            return;
        }
        double d4 = Math.cos(Math.toRadians(d2));
        if (d4 == -1.0) {
            this.preRotate3D_180();
            return;
        }
        if (d4 != 1.0) {
            double d5 = ((Transform)this).getMxx();
            double d6 = ((Transform)this).getMyx();
            this.setMxx(d4 * d5 - d3 * d6);
            this.setMyx(d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getMxy();
            d6 = ((Transform)this).getMyy();
            this.setMxy(d4 * d5 - d3 * d6);
            this.setMyy(d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getMxz();
            d6 = ((Transform)this).getMyz();
            this.setMxz(d4 * d5 - d3 * d6);
            this.setMyz(d3 * d5 + d4 * d6);
            d5 = ((Transform)this).getTx();
            d6 = ((Transform)this).getTy();
            this.setTx(d4 * d5 - d3 * d6);
            this.setTy(d3 * d5 + d4 * d6);
            this.updateState();
        }
    }

    private void preRotate3D_90() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(-((Transform)affine).getMyx());
        this.setMyx(d2);
        d2 = ((Transform)this).getMxy();
        Affine affine2 = this;
        affine2.setMxy(-((Transform)affine2).getMyy());
        this.setMyy(d2);
        d2 = ((Transform)this).getMxz();
        Affine affine3 = this;
        affine3.setMxz(-((Transform)affine3).getMyz());
        this.setMyz(d2);
        d2 = ((Transform)this).getTx();
        Affine affine4 = this;
        affine4.setTx(-((Transform)affine4).getTy());
        this.setTy(d2);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    private void preRotate3D_180() {
        double d2 = ((Transform)this).getMxx();
        double d3 = ((Transform)this).getMyy();
        this.setMxx(-d2);
        this.setMyy(-d3);
        Affine affine = this;
        affine.setTx(-((Transform)affine).getTx());
        Affine affine2 = this;
        affine2.setTy(-((Transform)affine2).getTy());
        if (this.state3d == 4) {
            Affine affine3 = this;
            affine3.setMxy(-((Transform)affine3).getMxy());
            Affine affine4 = this;
            affine4.setMxz(-((Transform)affine4).getMxz());
            Affine affine5 = this;
            affine5.setMyx(-((Transform)affine5).getMyx());
            Affine affine6 = this;
            affine6.setMyz(-((Transform)affine6).getMyz());
            this.updateState();
            return;
        }
        if (d2 == -1.0 && d3 == -1.0 && ((Transform)this).getMzz() == 1.0) {
            this.state3d &= 0xFFFFFFFD;
            return;
        }
        this.state3d |= 2;
    }

    private void preRotate3D_270() {
        double d2 = ((Transform)this).getMxx();
        Affine affine = this;
        affine.setMxx(((Transform)affine).getMyx());
        this.setMyx(-d2);
        d2 = ((Transform)this).getMxy();
        Affine affine2 = this;
        affine2.setMxy(((Transform)affine2).getMyy());
        this.setMyy(-d2);
        d2 = ((Transform)this).getMxz();
        Affine affine3 = this;
        affine3.setMxz(((Transform)affine3).getMyz());
        this.setMyz(-d2);
        d2 = ((Transform)this).getTx();
        Affine affine4 = this;
        affine4.setTx(((Transform)affine4).getTy());
        this.setTy(-d2);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (((Transform)this).getMxy() != 0.0 || ((Transform)this).getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    @Override
    public Point2D transform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                return new Point2D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3 + ((Transform)this).getTx(), ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3 + ((Transform)this).getTy());
            }
            case 6: {
                return new Point2D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3);
            }
            case 5: {
                return new Point2D(((Transform)this).getMxy() * d3 + ((Transform)this).getTx(), ((Transform)this).getMyx() * d2 + ((Transform)this).getTy());
            }
            case 4: {
                return new Point2D(((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2);
            }
            case 3: {
                return new Point2D(((Transform)this).getMxx() * d2 + ((Transform)this).getTx(), ((Transform)this).getMyy() * d3 + ((Transform)this).getTy());
            }
            case 2: {
                return new Point2D(((Transform)this).getMxx() * d2, ((Transform)this).getMyy() * d3);
            }
            case 1: {
                return new Point2D(d2 + ((Transform)this).getTx(), d3 + ((Transform)this).getTy());
            }
            case 0: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D transform(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 7: {
                        return new Point3D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3 + ((Transform)this).getTx(), ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3 + ((Transform)this).getTy(), d4);
                    }
                    case 6: {
                        return new Point3D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3, d4);
                    }
                    case 5: {
                        return new Point3D(((Transform)this).getMxy() * d3 + ((Transform)this).getTx(), ((Transform)this).getMyx() * d2 + ((Transform)this).getTy(), d4);
                    }
                    case 4: {
                        return new Point3D(((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2, d4);
                    }
                    case 3: {
                        return new Point3D(((Transform)this).getMxx() * d2 + ((Transform)this).getTx(), ((Transform)this).getMyy() * d3 + ((Transform)this).getTy(), d4);
                    }
                    case 2: {
                        return new Point3D(((Transform)this).getMxx() * d2, ((Transform)this).getMyy() * d3, d4);
                    }
                    case 1: {
                        return new Point3D(d2 + ((Transform)this).getTx(), d3 + ((Transform)this).getTy(), d4);
                    }
                    case 0: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2 + ((Transform)this).getTx(), d3 + ((Transform)this).getTy(), d4 + ((Transform)this).getTz());
            }
            case 2: {
                return new Point3D(((Transform)this).getMxx() * d2, ((Transform)this).getMyy() * d3, ((Transform)this).getMzz() * d4);
            }
            case 3: {
                return new Point3D(((Transform)this).getMxx() * d2 + ((Transform)this).getTx(), ((Transform)this).getMyy() * d3 + ((Transform)this).getTy(), ((Transform)this).getMzz() * d4 + ((Transform)this).getTz());
            }
            case 4: 
        }
        return new Point3D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3 + ((Transform)this).getMxz() * d4 + ((Transform)this).getTx(), ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3 + ((Transform)this).getMyz() * d4 + ((Transform)this).getTy(), ((Transform)this).getMzx() * d2 + ((Transform)this).getMzy() * d3 + ((Transform)this).getMzz() * d4 + ((Transform)this).getTz());
    }

    @Override
    void transform2DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                double d2 = ((Transform)this).getMxx();
                double d3 = ((Transform)this).getMxy();
                double d4 = ((Transform)this).getTx();
                double d5 = ((Transform)this).getMyx();
                double d6 = ((Transform)this).getMyy();
                double d7 = ((Transform)this).getTy();
                while (--n4 >= 0) {
                    double d8 = dArray[n2++];
                    double d9 = dArray[n2++];
                    dArray2[n3++] = d2 * d8 + d3 * d9 + d4;
                    dArray2[n3++] = d5 * d8 + d6 * d9 + d7;
                }
                return;
            }
            case 6: {
                double d10 = ((Transform)this).getMxx();
                double d11 = ((Transform)this).getMxy();
                double d12 = ((Transform)this).getMyx();
                double d13 = ((Transform)this).getMyy();
                while (--n4 >= 0) {
                    double d14 = dArray[n2++];
                    double d15 = dArray[n2++];
                    dArray2[n3++] = d10 * d14 + d11 * d15;
                    dArray2[n3++] = d12 * d14 + d13 * d15;
                }
                return;
            }
            case 5: {
                double d16 = ((Transform)this).getMxy();
                double d17 = ((Transform)this).getTx();
                double d18 = ((Transform)this).getMyx();
                double d19 = ((Transform)this).getTy();
                while (--n4 >= 0) {
                    double d20 = dArray[n2++];
                    dArray2[n3++] = d16 * dArray[n2++] + d17;
                    dArray2[n3++] = d18 * d20 + d19;
                }
                return;
            }
            case 4: {
                double d21 = ((Transform)this).getMxy();
                double d22 = ((Transform)this).getMyx();
                while (--n4 >= 0) {
                    double d23 = dArray[n2++];
                    dArray2[n3++] = d21 * dArray[n2++];
                    dArray2[n3++] = d22 * d23;
                }
                return;
            }
            case 3: {
                double d24 = ((Transform)this).getMxx();
                double d25 = ((Transform)this).getTx();
                double d26 = ((Transform)this).getMyy();
                double d27 = ((Transform)this).getTy();
                while (--n4 >= 0) {
                    dArray2[n3++] = d24 * dArray[n2++] + d25;
                    dArray2[n3++] = d26 * dArray[n2++] + d27;
                }
                return;
            }
            case 2: {
                double d28 = ((Transform)this).getMxx();
                double d29 = ((Transform)this).getMyy();
                while (--n4 >= 0) {
                    dArray2[n3++] = d28 * dArray[n2++];
                    dArray2[n3++] = d29 * dArray[n2++];
                }
                return;
            }
            case 1: {
                double d30 = ((Transform)this).getTx();
                double d31 = ((Transform)this).getTy();
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] + d30;
                    dArray2[n3++] = dArray[n2++] + d31;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n2 != n3) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 << 1);
        }
    }

    @Override
    void transform3DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 7: {
                        double d2 = ((Transform)this).getMxx();
                        double d3 = ((Transform)this).getMxy();
                        double d4 = ((Transform)this).getTx();
                        double d5 = ((Transform)this).getMyx();
                        double d6 = ((Transform)this).getMyy();
                        double d7 = ((Transform)this).getTy();
                        while (--n4 >= 0) {
                            double d8 = dArray[n2++];
                            double d9 = dArray[n2++];
                            dArray2[n3++] = d2 * d8 + d3 * d9 + d4;
                            dArray2[n3++] = d5 * d8 + d6 * d9 + d7;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 6: {
                        double d10 = ((Transform)this).getMxx();
                        double d11 = ((Transform)this).getMxy();
                        double d12 = ((Transform)this).getMyx();
                        double d13 = ((Transform)this).getMyy();
                        while (--n4 >= 0) {
                            double d14 = dArray[n2++];
                            double d15 = dArray[n2++];
                            dArray2[n3++] = d10 * d14 + d11 * d15;
                            dArray2[n3++] = d12 * d14 + d13 * d15;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 5: {
                        double d16 = ((Transform)this).getMxy();
                        double d17 = ((Transform)this).getTx();
                        double d18 = ((Transform)this).getMyx();
                        double d19 = ((Transform)this).getTy();
                        while (--n4 >= 0) {
                            double d20 = dArray[n2++];
                            dArray2[n3++] = d16 * dArray[n2++] + d17;
                            dArray2[n3++] = d18 * d20 + d19;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 4: {
                        double d21 = ((Transform)this).getMxy();
                        double d22 = ((Transform)this).getMyx();
                        while (--n4 >= 0) {
                            double d23 = dArray[n2++];
                            dArray2[n3++] = d21 * dArray[n2++];
                            dArray2[n3++] = d22 * d23;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 3: {
                        double d24 = ((Transform)this).getMxx();
                        double d25 = ((Transform)this).getTx();
                        double d26 = ((Transform)this).getMyy();
                        double d27 = ((Transform)this).getTy();
                        while (--n4 >= 0) {
                            dArray2[n3++] = d24 * dArray[n2++] + d25;
                            dArray2[n3++] = d26 * dArray[n2++] + d27;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 2: {
                        double d28 = ((Transform)this).getMxx();
                        double d29 = ((Transform)this).getMyy();
                        while (--n4 >= 0) {
                            dArray2[n3++] = d28 * dArray[n2++];
                            dArray2[n3++] = d29 * dArray[n2++];
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 1: {
                        double d30 = ((Transform)this).getTx();
                        double d31 = ((Transform)this).getTy();
                        while (--n4 >= 0) {
                            dArray2[n3++] = dArray[n2++] + d30;
                            dArray2[n3++] = dArray[n2++] + d31;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 0: 
                }
                if (dArray != dArray2 || n2 != n3) {
                    System.arraycopy(dArray, n2, dArray2, n3, n4 * 3);
                }
                return;
            }
            case 1: {
                double d32 = ((Transform)this).getTx();
                double d33 = ((Transform)this).getTy();
                double d34 = ((Transform)this).getTz();
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] + d32;
                    dArray2[n3++] = dArray[n2++] + d33;
                    dArray2[n3++] = dArray[n2++] + d34;
                }
                return;
            }
            case 2: {
                double d35 = ((Transform)this).getMxx();
                double d36 = ((Transform)this).getMyy();
                double d37 = ((Transform)this).getMzz();
                while (--n4 >= 0) {
                    dArray2[n3++] = d35 * dArray[n2++];
                    dArray2[n3++] = d36 * dArray[n2++];
                    dArray2[n3++] = d37 * dArray[n2++];
                }
                return;
            }
            case 3: {
                double d38 = ((Transform)this).getMxx();
                double d39 = ((Transform)this).getTx();
                double d40 = ((Transform)this).getMyy();
                double d41 = ((Transform)this).getTy();
                double d42 = ((Transform)this).getMzz();
                double d43 = ((Transform)this).getTz();
                while (--n4 >= 0) {
                    dArray2[n3++] = d38 * dArray[n2++] + d39;
                    dArray2[n3++] = d40 * dArray[n2++] + d41;
                    dArray2[n3++] = d42 * dArray[n2++] + d43;
                }
                return;
            }
            case 4: 
        }
        double d44 = ((Transform)this).getMxx();
        double d45 = ((Transform)this).getMxy();
        double d46 = ((Transform)this).getMxz();
        double d47 = ((Transform)this).getTx();
        double d48 = ((Transform)this).getMyx();
        double d49 = ((Transform)this).getMyy();
        double d50 = ((Transform)this).getMyz();
        double d51 = ((Transform)this).getTy();
        double d52 = ((Transform)this).getMzx();
        double d53 = ((Transform)this).getMzy();
        double d54 = ((Transform)this).getMzz();
        double d55 = ((Transform)this).getTz();
        while (--n4 >= 0) {
            double d56 = dArray[n2++];
            double d57 = dArray[n2++];
            double d58 = dArray[n2++];
            dArray2[n3++] = d44 * d56 + d45 * d57 + d46 * d58 + d47;
            dArray2[n3++] = d48 * d56 + d49 * d57 + d50 * d58 + d51;
            dArray2[n3++] = d52 * d56 + d53 * d57 + d54 * d58 + d55;
        }
    }

    @Override
    public Point2D deltaTransform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                return new Point2D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3);
            }
            case 4: 
            case 5: {
                return new Point2D(((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2);
            }
            case 2: 
            case 3: {
                return new Point2D(((Transform)this).getMxx() * d2, ((Transform)this).getMyy() * d3);
            }
            case 0: 
            case 1: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D deltaTransform(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 6: 
                    case 7: {
                        return new Point3D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3, d4);
                    }
                    case 4: 
                    case 5: {
                        return new Point3D(((Transform)this).getMxy() * d3, ((Transform)this).getMyx() * d2, d4);
                    }
                    case 2: 
                    case 3: {
                        return new Point3D(((Transform)this).getMxx() * d2, ((Transform)this).getMyy() * d3, d4);
                    }
                    case 0: 
                    case 1: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2, d3, d4);
            }
            case 2: 
            case 3: {
                return new Point3D(((Transform)this).getMxx() * d2, ((Transform)this).getMyy() * d3, ((Transform)this).getMzz() * d4);
            }
            case 4: 
        }
        return new Point3D(((Transform)this).getMxx() * d2 + ((Transform)this).getMxy() * d3 + ((Transform)this).getMxz() * d4, ((Transform)this).getMyx() * d2 + ((Transform)this).getMyy() * d3 + ((Transform)this).getMyz() * d4, ((Transform)this).getMzx() * d2 + ((Transform)this).getMzy() * d3 + ((Transform)this).getMzz() * d4);
    }

    @Override
    public Point2D inverseTransform(double d2, double d3) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                return super.inverseTransform(d2, d3);
            }
            case 5: {
                double d4 = ((Transform)this).getMxy();
                double d5 = ((Transform)this).getMyx();
                if (d4 == 0.0 || d5 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / d5 * d3 - ((Transform)this).getTy() / d5, 1.0 / d4 * d2 - ((Transform)this).getTx() / d4);
            }
            case 4: {
                double d6 = ((Transform)this).getMxy();
                double d7 = ((Transform)this).getMyx();
                if (d6 == 0.0 || d7 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / d7 * d3, 1.0 / d6 * d2);
            }
            case 3: {
                double d8 = ((Transform)this).getMxx();
                double d9 = ((Transform)this).getMyy();
                if (d8 == 0.0 || d9 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / d8 * d2 - ((Transform)this).getTx() / d8, 1.0 / d9 * d3 - ((Transform)this).getTy() / d9);
            }
            case 2: {
                double d10 = ((Transform)this).getMxx();
                double d11 = ((Transform)this).getMyy();
                if (d10 == 0.0 || d11 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / d10 * d2, 1.0 / d11 * d3);
            }
            case 1: {
                return new Point2D(d2 - ((Transform)this).getTx(), d3 - ((Transform)this).getTy());
            }
            case 0: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D inverseTransform(double d2, double d3, double d4) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        return super.inverseTransform(d2, d3, d4);
                    }
                    case 5: {
                        double d5 = ((Transform)this).getMxy();
                        double d6 = ((Transform)this).getMyx();
                        if (d5 == 0.0 || d6 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / d6 * d3 - ((Transform)this).getTy() / d6, 1.0 / d5 * d2 - ((Transform)this).getTx() / d5, d4);
                    }
                    case 4: {
                        double d7 = ((Transform)this).getMxy();
                        double d8 = ((Transform)this).getMyx();
                        if (d7 == 0.0 || d8 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / d8 * d3, 1.0 / d7 * d2, d4);
                    }
                    case 3: {
                        double d9 = ((Transform)this).getMxx();
                        double d10 = ((Transform)this).getMyy();
                        if (d9 == 0.0 || d10 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / d9 * d2 - ((Transform)this).getTx() / d9, 1.0 / d10 * d3 - ((Transform)this).getTy() / d10, d4);
                    }
                    case 2: {
                        double d11 = ((Transform)this).getMxx();
                        double d12 = ((Transform)this).getMyy();
                        if (d11 == 0.0 || d12 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / d11 * d2, 1.0 / d12 * d3, d4);
                    }
                    case 1: {
                        return new Point3D(d2 - ((Transform)this).getTx(), d3 - ((Transform)this).getTy(), d4);
                    }
                    case 0: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2 - ((Transform)this).getTx(), d3 - ((Transform)this).getTy(), d4 - ((Transform)this).getTz());
            }
            case 2: {
                double d13 = ((Transform)this).getMxx();
                double d14 = ((Transform)this).getMyy();
                double d15 = ((Transform)this).getMzz();
                if (d13 == 0.0 || d14 == 0.0 || d15 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / d13 * d2, 1.0 / d14 * d3, 1.0 / d15 * d4);
            }
            case 3: {
                double d16 = ((Transform)this).getMxx();
                double d17 = ((Transform)this).getMyy();
                double d18 = ((Transform)this).getMzz();
                if (d16 == 0.0 || d17 == 0.0 || d18 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / d16 * d2 - ((Transform)this).getTx() / d16, 1.0 / d17 * d3 - ((Transform)this).getTy() / d17, 1.0 / d18 * d4 - ((Transform)this).getTz() / d18);
            }
            case 4: 
        }
        return super.inverseTransform(d2, d3, d4);
    }

    @Override
    void inverseTransform2DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) throws NonInvertibleTransformException {
        switch (this.state2d) {
            default: {
                super.inverseTransform2DPointsImpl(dArray, n2, dArray2, n3, n4);
                return;
            }
            case 5: {
                double d2 = ((Transform)this).getMxy();
                double d3 = ((Transform)this).getTx();
                double d4 = ((Transform)this).getMyx();
                double d5 = ((Transform)this).getTy();
                if (d2 == 0.0 || d4 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                double d6 = d3;
                d3 = -d5 / d4;
                d5 = -d6 / d2;
                d6 = d4;
                d4 = 1.0 / d2;
                d2 = 1.0 / d6;
                while (--n4 >= 0) {
                    double d7 = dArray[n2++];
                    dArray2[n3++] = d2 * dArray[n2++] + d3;
                    dArray2[n3++] = d4 * d7 + d5;
                }
                return;
            }
            case 4: {
                double d8 = ((Transform)this).getMxy();
                double d9 = ((Transform)this).getMyx();
                if (d8 == 0.0 || d9 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                double d10 = d9;
                d9 = 1.0 / d8;
                d8 = 1.0 / d10;
                while (--n4 >= 0) {
                    double d11 = dArray[n2++];
                    dArray2[n3++] = d8 * dArray[n2++];
                    dArray2[n3++] = d9 * d11;
                }
                return;
            }
            case 3: {
                double d12 = ((Transform)this).getMxx();
                double d13 = ((Transform)this).getTx();
                double d14 = ((Transform)this).getMyy();
                double d15 = ((Transform)this).getTy();
                if (d12 == 0.0 || d14 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                d13 = -d13 / d12;
                d15 = -d15 / d14;
                d12 = 1.0 / d12;
                d14 = 1.0 / d14;
                while (--n4 >= 0) {
                    dArray2[n3++] = d12 * dArray[n2++] + d13;
                    dArray2[n3++] = d14 * dArray[n2++] + d15;
                }
                return;
            }
            case 2: {
                double d16 = ((Transform)this).getMxx();
                double d17 = ((Transform)this).getMyy();
                if (d16 == 0.0 || d17 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                d16 = 1.0 / d16;
                d17 = 1.0 / d17;
                while (--n4 >= 0) {
                    dArray2[n3++] = d16 * dArray[n2++];
                    dArray2[n3++] = d17 * dArray[n2++];
                }
                return;
            }
            case 1: {
                double d18 = ((Transform)this).getTx();
                double d19 = ((Transform)this).getTy();
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] - d18;
                    dArray2[n3++] = dArray[n2++] - d19;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n2 != n3) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 << 1);
        }
    }

    @Override
    void inverseTransform3DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        super.inverseTransform3DPointsImpl(dArray, n2, dArray2, n3, n4);
                        return;
                    }
                    case 5: {
                        double d2 = ((Transform)this).getMxy();
                        double d3 = ((Transform)this).getTx();
                        double d4 = ((Transform)this).getMyx();
                        double d5 = ((Transform)this).getTy();
                        if (d2 == 0.0 || d4 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        double d6 = d3;
                        d3 = -d5 / d4;
                        d5 = -d6 / d2;
                        d6 = d4;
                        d4 = 1.0 / d2;
                        d2 = 1.0 / d6;
                        while (--n4 >= 0) {
                            double d7 = dArray[n2++];
                            dArray2[n3++] = d2 * dArray[n2++] + d3;
                            dArray2[n3++] = d4 * d7 + d5;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 4: {
                        double d8 = ((Transform)this).getMxy();
                        double d9 = ((Transform)this).getMyx();
                        if (d8 == 0.0 || d9 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        double d10 = d9;
                        d9 = 1.0 / d8;
                        d8 = 1.0 / d10;
                        while (--n4 >= 0) {
                            double d11 = dArray[n2++];
                            dArray2[n3++] = d8 * dArray[n2++];
                            dArray2[n3++] = d9 * d11;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 3: {
                        double d12 = ((Transform)this).getMxx();
                        double d13 = ((Transform)this).getTx();
                        double d14 = ((Transform)this).getMyy();
                        double d15 = ((Transform)this).getTy();
                        if (d12 == 0.0 || d14 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        d13 = -d13 / d12;
                        d15 = -d15 / d14;
                        d12 = 1.0 / d12;
                        d14 = 1.0 / d14;
                        while (--n4 >= 0) {
                            dArray2[n3++] = d12 * dArray[n2++] + d13;
                            dArray2[n3++] = d14 * dArray[n2++] + d15;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 2: {
                        double d16 = ((Transform)this).getMxx();
                        double d17 = ((Transform)this).getMyy();
                        if (d16 == 0.0 || d17 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        d16 = 1.0 / d16;
                        d17 = 1.0 / d17;
                        while (--n4 >= 0) {
                            dArray2[n3++] = d16 * dArray[n2++];
                            dArray2[n3++] = d17 * dArray[n2++];
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 1: {
                        double d18 = ((Transform)this).getTx();
                        double d19 = ((Transform)this).getTy();
                        while (--n4 >= 0) {
                            dArray2[n3++] = dArray[n2++] - d18;
                            dArray2[n3++] = dArray[n2++] - d19;
                            dArray2[n3++] = dArray[n2++];
                        }
                        return;
                    }
                    case 0: 
                }
                if (dArray != dArray2 || n2 != n3) {
                    System.arraycopy(dArray, n2, dArray2, n3, n4 * 3);
                }
                return;
            }
            case 1: {
                double d20 = ((Transform)this).getTx();
                double d21 = ((Transform)this).getTy();
                double d22 = ((Transform)this).getTz();
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] - d20;
                    dArray2[n3++] = dArray[n2++] - d21;
                    dArray2[n3++] = dArray[n2++] - d22;
                }
                return;
            }
            case 2: {
                double d23 = ((Transform)this).getMxx();
                double d24 = ((Transform)this).getMyy();
                double d25 = ((Transform)this).getMzz();
                if (d23 == 0.0 || d24 == 0.0 | d25 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                d23 = 1.0 / d23;
                d24 = 1.0 / d24;
                d25 = 1.0 / d25;
                while (--n4 >= 0) {
                    dArray2[n3++] = d23 * dArray[n2++];
                    dArray2[n3++] = d24 * dArray[n2++];
                    dArray2[n3++] = d25 * dArray[n2++];
                }
                return;
            }
            case 3: {
                double d26 = ((Transform)this).getMxx();
                double d27 = ((Transform)this).getTx();
                double d28 = ((Transform)this).getMyy();
                double d29 = ((Transform)this).getTy();
                double d30 = ((Transform)this).getMzz();
                double d31 = ((Transform)this).getTz();
                if (d26 == 0.0 || d28 == 0.0 || d30 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                d27 = -d27 / d26;
                d29 = -d29 / d28;
                d31 = -d31 / d30;
                d26 = 1.0 / d26;
                d28 = 1.0 / d28;
                d30 = 1.0 / d30;
                while (--n4 >= 0) {
                    dArray2[n3++] = d26 * dArray[n2++] + d27;
                    dArray2[n3++] = d28 * dArray[n2++] + d29;
                    dArray2[n3++] = d30 * dArray[n2++] + d31;
                }
                return;
            }
            case 4: 
        }
        super.inverseTransform3DPointsImpl(dArray, n2, dArray2, n3, n4);
    }

    @Override
    public Point2D inverseDeltaTransform(double d2, double d3) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                return super.inverseDeltaTransform(d2, d3);
            }
            case 4: 
            case 5: {
                double d4 = ((Transform)this).getMxy();
                double d5 = ((Transform)this).getMyx();
                if (d4 == 0.0 || d5 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / d5 * d3, 1.0 / d4 * d2);
            }
            case 2: 
            case 3: {
                double d6 = ((Transform)this).getMxx();
                double d7 = ((Transform)this).getMyy();
                if (d6 == 0.0 || d7 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / d6 * d2, 1.0 / d7 * d3);
            }
            case 0: 
            case 1: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D inverseDeltaTransform(double d2, double d3, double d4) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        return super.inverseDeltaTransform(d2, d3, d4);
                    }
                    case 4: 
                    case 5: {
                        double d5 = ((Transform)this).getMxy();
                        double d6 = ((Transform)this).getMyx();
                        if (d5 == 0.0 || d6 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / d6 * d3, 1.0 / d5 * d2, d4);
                    }
                    case 2: 
                    case 3: {
                        double d7 = ((Transform)this).getMxx();
                        double d8 = ((Transform)this).getMyy();
                        if (d7 == 0.0 || d8 == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / d7 * d2, 1.0 / d8 * d3, d4);
                    }
                    case 0: 
                    case 1: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2, d3, d4);
            }
            case 2: 
            case 3: {
                double d9 = ((Transform)this).getMxx();
                double d10 = ((Transform)this).getMyy();
                double d11 = ((Transform)this).getMzz();
                if (d9 == 0.0 || d10 == 0.0 || d11 == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / d9 * d2, 1.0 / d10 * d3, 1.0 / d11 * d4);
            }
            case 4: 
        }
        return super.inverseDeltaTransform(d2, d3, d4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Affine [\n");
        stringBuilder.append("\t").append(((Transform)this).getMxx());
        stringBuilder.append(", ").append(((Transform)this).getMxy());
        stringBuilder.append(", ").append(((Transform)this).getMxz());
        stringBuilder.append(", ").append(((Transform)this).getTx());
        stringBuilder.append('\n');
        stringBuilder.append("\t").append(((Transform)this).getMyx());
        stringBuilder.append(", ").append(((Transform)this).getMyy());
        stringBuilder.append(", ").append(((Transform)this).getMyz());
        stringBuilder.append(", ").append(((Transform)this).getTy());
        stringBuilder.append('\n');
        stringBuilder.append("\t").append(((Transform)this).getMzx());
        stringBuilder.append(", ").append(((Transform)this).getMzy());
        stringBuilder.append(", ").append(((Transform)this).getMzz());
        stringBuilder.append(", ").append(((Transform)this).getTz());
        return stringBuilder.append("\n]").toString();
    }

    private void updateState() {
        this.updateState2D();
        this.state3d = 0;
        if (((Transform)this).getMxz() != 0.0 || ((Transform)this).getMyz() != 0.0 || ((Transform)this).getMzx() != 0.0 || ((Transform)this).getMzy() != 0.0) {
            this.state3d = 4;
            return;
        }
        if ((this.state2d & 4) == 0) {
            if (((Transform)this).getTz() != 0.0) {
                this.state3d |= 1;
            }
            if (((Transform)this).getMzz() != 1.0) {
                this.state3d |= 2;
            }
            if (this.state3d != 0) {
                this.state3d |= this.state2d & 3;
                return;
            }
        } else if (((Transform)this).getMzz() != 1.0 || ((Transform)this).getTz() != 0.0) {
            this.state3d = 4;
        }
    }

    private void updateState2D() {
        if (((Transform)this).getMxy() == 0.0 && ((Transform)this).getMyx() == 0.0) {
            if (((Transform)this).getMxx() == 1.0 && ((Transform)this).getMyy() == 1.0) {
                if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                    this.state2d = 0;
                    return;
                }
                this.state2d = 1;
                return;
            }
            if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                this.state2d = 2;
                return;
            }
            this.state2d = 3;
            return;
        }
        if (((Transform)this).getMxx() == 0.0 && ((Transform)this).getMyy() == 0.0) {
            if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
                this.state2d = 4;
                return;
            }
            this.state2d = 5;
            return;
        }
        if (((Transform)this).getTx() == 0.0 && ((Transform)this).getTy() == 0.0) {
            this.state2d = 6;
            return;
        }
        this.state2d = 7;
    }

    private static void stateError() {
        throw new InternalError("missing case in a switch");
    }

    @Override
    void apply(Affine3D affine3D) {
        affine3D.concatenate(((Transform)this).getMxx(), ((Transform)this).getMxy(), ((Transform)this).getMxz(), ((Transform)this).getTx(), ((Transform)this).getMyx(), ((Transform)this).getMyy(), ((Transform)this).getMyz(), ((Transform)this).getTy(), ((Transform)this).getMzx(), ((Transform)this).getMzy(), ((Transform)this).getMzz(), ((Transform)this).getTz());
    }

    @Override
    BaseTransform derive(BaseTransform baseTransform) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    case 0: {
                        return baseTransform;
                    }
                    case 1: {
                        return baseTransform.deriveWithTranslation(((Transform)this).getTx(), ((Transform)this).getTy());
                    }
                    case 2: {
                        return baseTransform.deriveWithScale(((Transform)this).getMxx(), ((Transform)this).getMyy(), 1.0);
                    }
                }
                return baseTransform.deriveWithConcatenation(((Transform)this).getMxx(), ((Transform)this).getMyx(), ((Transform)this).getMxy(), ((Transform)this).getMyy(), ((Transform)this).getTx(), ((Transform)this).getTy());
            }
            case 1: {
                return baseTransform.deriveWithTranslation(((Transform)this).getTx(), ((Transform)this).getTy(), ((Transform)this).getTz());
            }
            case 2: {
                return baseTransform.deriveWithScale(((Transform)this).getMxx(), ((Transform)this).getMyy(), ((Transform)this).getMzz());
            }
            case 3: 
            case 4: 
        }
        return baseTransform.deriveWithConcatenation(((Transform)this).getMxx(), ((Transform)this).getMxy(), ((Transform)this).getMxz(), ((Transform)this).getTx(), ((Transform)this).getMyx(), ((Transform)this).getMyy(), ((Transform)this).getMyz(), ((Transform)this).getTy(), ((Transform)this).getMzx(), ((Transform)this).getMzy(), ((Transform)this).getMzz(), ((Transform)this).getTz());
    }

    int getState2d() {
        return this.state2d;
    }

    int getState3d() {
        return this.state3d;
    }

    boolean atomicChangeRuns() {
        return this.atomicChange.runs();
    }
}

