/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.glass.ui.CommonDialogs$ExtensionFilter;
import com.sun.glass.ui.CommonDialogs$FileChooserResult;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.Toolkit;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser$ExtensionFilter;
import javafx.stage.Window;

public final class FileChooser {
    private StringProperty title;
    private ObjectProperty<File> initialDirectory;
    private ObjectProperty<String> initialFileName;
    private ObservableList<FileChooser$ExtensionFilter> extensionFilters = FXCollections.observableArrayList();
    private ObjectProperty<FileChooser$ExtensionFilter> selectedExtensionFilter;

    public final void setTitle(String string) {
        this.titleProperty().set(string);
    }

    public final String getTitle() {
        if (this.title != null) {
            return (String)this.title.get();
        }
        return null;
    }

    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty(this, "title");
        }
        return this.title;
    }

    public final void setInitialDirectory(File file) {
        this.initialDirectoryProperty().set(file);
    }

    public final File getInitialDirectory() {
        if (this.initialDirectory != null) {
            return (File)this.initialDirectory.get();
        }
        return null;
    }

    public final ObjectProperty<File> initialDirectoryProperty() {
        if (this.initialDirectory == null) {
            this.initialDirectory = new SimpleObjectProperty<File>(this, "initialDirectory");
        }
        return this.initialDirectory;
    }

    public final void setInitialFileName(String string) {
        this.initialFileNameProperty().set(string);
    }

    public final String getInitialFileName() {
        if (this.initialFileName != null) {
            return (String)this.initialFileName.get();
        }
        return null;
    }

    public final ObjectProperty<String> initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleObjectProperty<String>(this, "initialFileName");
        }
        return this.initialFileName;
    }

    public final ObservableList<FileChooser$ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public final ObjectProperty<FileChooser$ExtensionFilter> selectedExtensionFilterProperty() {
        if (this.selectedExtensionFilter == null) {
            this.selectedExtensionFilter = new SimpleObjectProperty<FileChooser$ExtensionFilter>(this, "selectedExtensionFilter");
        }
        return this.selectedExtensionFilter;
    }

    public final void setSelectedExtensionFilter(FileChooser$ExtensionFilter fileChooser$ExtensionFilter) {
        this.selectedExtensionFilterProperty().setValue(fileChooser$ExtensionFilter);
    }

    public final FileChooser$ExtensionFilter getSelectedExtensionFilter() {
        if (this.selectedExtensionFilter != null) {
            return (FileChooser$ExtensionFilter)this.selectedExtensionFilter.get();
        }
        return null;
    }

    public final File showOpenDialog(Window object) {
        if ((object = this.showDialog((Window)object, FileChooserType.OPEN)) != null && object.size() > 0) {
            return (File)object.get(0);
        }
        return null;
    }

    public final List<File> showOpenMultipleDialog(Window object) {
        if ((object = this.showDialog((Window)object, FileChooserType.OPEN_MULTIPLE)) != null && object.size() > 0) {
            return Collections.unmodifiableList(object);
        }
        return null;
    }

    public final File showSaveDialog(Window object) {
        if ((object = this.showDialog((Window)object, FileChooserType.SAVE)) != null && object.size() > 0) {
            return (File)object.get(0);
        }
        return null;
    }

    private FileChooser$ExtensionFilter findSelectedFilter(CommonDialogs$ExtensionFilter object) {
        if (object != null) {
            String string = ((CommonDialogs$ExtensionFilter)object).getDescription();
            object = ((CommonDialogs$ExtensionFilter)object).getExtensions();
            for (FileChooser$ExtensionFilter fileChooser$ExtensionFilter : this.extensionFilters) {
                if (!string.equals(fileChooser$ExtensionFilter.getDescription()) || !object.equals(fileChooser$ExtensionFilter.getExtensions())) continue;
                return fileChooser$ExtensionFilter;
            }
        }
        return null;
    }

    private List<File> showDialog(Window object, FileChooserType object2) {
        object = Toolkit.getToolkit().showFileChooser(object != null ? ((Window)object).getPeer() : null, this.getTitle(), this.getInitialDirectory(), this.getInitialFileName(), (FileChooserType)((Object)object2), this.extensionFilters, this.getSelectedExtensionFilter());
        if (object == null) {
            return null;
        }
        object2 = ((CommonDialogs$FileChooserResult)object).getFiles();
        if (object2 != null && object2.size() > 0) {
            this.selectedExtensionFilterProperty().set(this.findSelectedFilter(((CommonDialogs$FileChooserResult)object).getExtensionFilter()));
        }
        return object2;
    }
}

