/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.FXPermissions;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.event.EventRedirector;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.TreeShowingProperty;
import com.sun.javafx.stage.PopupWindowHelper;
import com.sun.javafx.stage.PopupWindowPeerListener;
import com.sun.javafx.stage.WindowCloseRequestHandler;
import com.sun.javafx.stage.WindowEventDispatcher;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow$1;
import javafx.stage.PopupWindow$2;
import javafx.stage.PopupWindow$3;
import javafx.stage.PopupWindow$4;
import javafx.stage.PopupWindow$5;
import javafx.stage.PopupWindow$6;
import javafx.stage.PopupWindow$AnchorLocation;
import javafx.stage.PopupWindow$PopupEventRedirector;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class PopupWindow
extends Window {
    private final List<PopupWindow> children = new ArrayList<PopupWindow>();
    private final InvalidationListener popupWindowUpdater = new PopupWindow$2(this);
    private ChangeListener<Boolean> changeListener = (observableValue, bl2, bl3) -> {
        if (bl2.booleanValue() && !bl3.booleanValue()) {
            ((Window)this).hide();
        }
    };
    private WeakChangeListener<Boolean> weakOwnerNodeListener = new WeakChangeListener<Boolean>(this.changeListener);
    private TreeShowingProperty treeShowingProperty;
    private ReadOnlyObjectWrapper<Window> ownerWindow = new ReadOnlyObjectWrapper(this, "ownerWindow");
    private ReadOnlyObjectWrapper<Node> ownerNode = new ReadOnlyObjectWrapper(this, "ownerNode");
    private BooleanProperty autoFix = new PopupWindow$4(this, true);
    private BooleanProperty autoHide = new PopupWindow$5(this);
    private ObjectProperty<EventHandler<Event>> onAutoHide = new SimpleObjectProperty<EventHandler<Event>>(this, "onAutoHide");
    private BooleanProperty hideOnEscape = new SimpleBooleanProperty(this, "hideOnEscape", true);
    private BooleanProperty consumeAutoHidingEvents = new SimpleBooleanProperty(this, "consumeAutoHidingEvents", true);
    private Window rootWindow;
    private final ReadOnlyDoubleWrapper anchorX = new ReadOnlyDoubleWrapper(this, "anchorX", Double.NaN);
    private final ReadOnlyDoubleWrapper anchorY = new ReadOnlyDoubleWrapper(this, "anchorY", Double.NaN);
    private final ObjectProperty<PopupWindow$AnchorLocation> anchorLocation = new PopupWindow$6(this, PopupWindow$AnchorLocation.WINDOW_TOP_LEFT);
    private Bounds cachedExtendedBounds;
    private Bounds cachedAnchorBounds;
    private ChangeListener<Boolean> ownerFocusedListener;
    private boolean autofixActive;
    private boolean autohideActive;

    public PopupWindow() {
        Pane pane = new Pane();
        pane.setBackground(Background.EMPTY);
        pane.getStyleClass().add("popup");
        Scene scene = SceneHelper.createPopupScene(pane);
        scene.setFill(null);
        super.setScene(scene);
        pane.layoutBoundsProperty().addListener(this.popupWindowUpdater);
        pane.boundsInLocalProperty().addListener(this.popupWindowUpdater);
        scene.rootProperty().addListener(new PopupWindow$3(this, scene));
        PopupWindowHelper.initHelper(this);
    }

    ObservableList<Node> getContent() {
        Parent parent = this.getScene().getRoot();
        if (parent instanceof Group) {
            return ((Group)parent).getChildren();
        }
        if (parent instanceof Pane) {
            return ((Pane)parent).getChildren();
        }
        throw new IllegalStateException("The content of the Popup can't be accessed");
    }

    public final Window getOwnerWindow() {
        return (Window)this.ownerWindow.get();
    }

    public final ReadOnlyObjectProperty<Window> ownerWindowProperty() {
        return this.ownerWindow.getReadOnlyProperty();
    }

    public final Node getOwnerNode() {
        return (Node)this.ownerNode.get();
    }

    public final ReadOnlyObjectProperty<Node> ownerNodeProperty() {
        return this.ownerNode.getReadOnlyProperty();
    }

    @Override
    protected final void setScene(Scene scene) {
        throw new UnsupportedOperationException();
    }

    public final void setAutoFix(boolean bl2) {
        this.autoFix.set(bl2);
    }

    public final boolean isAutoFix() {
        return this.autoFix.get();
    }

    public final BooleanProperty autoFixProperty() {
        return this.autoFix;
    }

    public final void setAutoHide(boolean bl2) {
        this.autoHide.set(bl2);
    }

    public final boolean isAutoHide() {
        return this.autoHide.get();
    }

    public final BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public final void setOnAutoHide(EventHandler<Event> eventHandler) {
        this.onAutoHide.set(eventHandler);
    }

    public final EventHandler<Event> getOnAutoHide() {
        return (EventHandler)this.onAutoHide.get();
    }

    public final ObjectProperty<EventHandler<Event>> onAutoHideProperty() {
        return this.onAutoHide;
    }

    public final void setHideOnEscape(boolean bl2) {
        this.hideOnEscape.set(bl2);
    }

    public final boolean isHideOnEscape() {
        return this.hideOnEscape.get();
    }

    public final BooleanProperty hideOnEscapeProperty() {
        return this.hideOnEscape;
    }

    public final void setConsumeAutoHidingEvents(boolean bl2) {
        this.consumeAutoHidingEvents.set(bl2);
    }

    public final boolean getConsumeAutoHidingEvents() {
        return this.consumeAutoHidingEvents.get();
    }

    public final BooleanProperty consumeAutoHidingEventsProperty() {
        return this.consumeAutoHidingEvents;
    }

    public void show(Window window) {
        this.validateOwnerWindow(window);
        this.showImpl(window);
    }

    public void show(Node node, double d2, double d3) {
        if (node == null) {
            throw new NullPointerException("The owner node must not be null");
        }
        EventTarget eventTarget = node.getScene();
        if (eventTarget == null || eventTarget.getWindow() == null) {
            throw new IllegalArgumentException("The owner node needs to be associated with a window");
        }
        eventTarget = eventTarget.getWindow();
        this.validateOwnerWindow((Window)eventTarget);
        this.ownerNode.set(node);
        if (node != null) {
            this.treeShowingProperty = new TreeShowingProperty(node);
            this.treeShowingProperty.addListener((ChangeListener<? super Boolean>)this.weakOwnerNodeListener);
        }
        this.updateWindow(d2, d3);
        this.showImpl((Window)eventTarget);
    }

    public void show(Window window, double d2, double d3) {
        this.validateOwnerWindow(window);
        this.updateWindow(d2, d3);
        this.showImpl(window);
    }

    private void showImpl(Window window) {
        this.ownerWindow.set(window);
        if (window instanceof PopupWindow) {
            ((PopupWindow)window).children.add(this);
        }
        if (window != null) {
            window.showingProperty().addListener(this.weakOwnerNodeListener);
        }
        Scene scene = this.getScene();
        SceneHelper.parentEffectiveOrientationInvalidated(scene);
        Scene scene2 = PopupWindow.getRootWindow(window).getScene();
        if (scene2 != null) {
            if (scene2.getUserAgentStylesheet() != null) {
                scene.setUserAgentStylesheet(scene2.getUserAgentStylesheet());
            }
            scene.getStylesheets().setAll((Collection<String>)scene2.getStylesheets());
            if (scene.getCursor() == null) {
                scene.setCursor(scene2.getCursor());
            }
        }
        if (PopupWindow.getRootWindow(window).isShowing()) {
            this.show();
        }
    }

    @Override
    public void hide() {
        for (PopupWindow popupWindow : this.children) {
            if (!popupWindow.isShowing()) continue;
            ((Window)popupWindow).hide();
        }
        this.children.clear();
        super.hide();
        if (this.getOwnerWindow() != null) {
            this.getOwnerWindow().showingProperty().removeListener(this.weakOwnerNodeListener);
        }
        if (this.treeShowingProperty != null) {
            this.treeShowingProperty.removeListener((ChangeListener<? super Boolean>)this.weakOwnerNodeListener);
            this.treeShowingProperty.dispose();
            this.treeShowingProperty = null;
        }
    }

    private void doVisibleChanging(boolean bl2) {
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow]");
        Toolkit toolkit = Toolkit.getToolkit();
        if (bl2 && this.getPeer() == null) {
            Object object;
            try {
                object = System.getSecurityManager();
                if (object != null) {
                    object.checkPermission(FXPermissions.CREATE_TRANSPARENT_WINDOW_PERMISSION);
                }
                object = StageStyle.TRANSPARENT;
            }
            catch (SecurityException securityException) {
                object = StageStyle.UNDECORATED;
            }
            this.setPeer(toolkit.createTKPopupStage(this, (StageStyle)((Object)object), this.getOwnerWindow().getPeer(), this.acc));
            this.setPeerListener(new PopupWindowPeerListener(this));
        }
    }

    private void doVisibleChanged(boolean bl2) {
        Window window = this.getOwnerWindow();
        if (bl2) {
            this.rootWindow = PopupWindow.getRootWindow(window);
            this.startMonitorOwnerEvents(window);
            this.bindOwnerFocusedProperty(window);
            WindowHelper.setFocused(this, window.isFocused());
            this.handleAutofixActivation(true, this.isAutoFix());
            this.handleAutohideActivation(true, this.isAutoHide());
        } else {
            this.stopMonitorOwnerEvents(window);
            this.unbindOwnerFocusedProperty(window);
            WindowHelper.setFocused(this, false);
            this.handleAutofixActivation(false, this.isAutoFix());
            this.handleAutohideActivation(false, this.isAutoHide());
            this.rootWindow = null;
        }
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow] finished");
    }

    public final void setAnchorX(double d2) {
        this.updateWindow(d2, this.getAnchorY());
    }

    public final double getAnchorX() {
        return this.anchorX.get();
    }

    public final ReadOnlyDoubleProperty anchorXProperty() {
        return this.anchorX.getReadOnlyProperty();
    }

    public final void setAnchorY(double d2) {
        PopupWindow popupWindow = this;
        popupWindow.updateWindow(popupWindow.getAnchorX(), d2);
    }

    public final double getAnchorY() {
        return this.anchorY.get();
    }

    public final ReadOnlyDoubleProperty anchorYProperty() {
        return this.anchorY.getReadOnlyProperty();
    }

    public final void setAnchorLocation(PopupWindow$AnchorLocation popupWindow$AnchorLocation) {
        this.anchorLocation.set(popupWindow$AnchorLocation);
    }

    public final PopupWindow$AnchorLocation getAnchorLocation() {
        return (PopupWindow$AnchorLocation)((Object)this.anchorLocation.get());
    }

    public final ObjectProperty<PopupWindow$AnchorLocation> anchorLocationProperty() {
        return this.anchorLocation;
    }

    @Override
    void setXInternal(double d2) {
        PopupWindow popupWindow = this;
        popupWindow.updateWindow(popupWindow.windowToAnchorX(d2), this.getAnchorY());
    }

    @Override
    void setYInternal(double d2) {
        PopupWindow popupWindow = this;
        popupWindow.updateWindow(popupWindow.getAnchorX(), this.windowToAnchorY(d2));
    }

    @Override
    void notifyLocationChanged(double d2, double d3) {
        super.notifyLocationChanged(d2, d3);
        this.anchorX.set(this.windowToAnchorX(d2));
        this.anchorY.set(this.windowToAnchorY(d3));
    }

    private Bounds getExtendedBounds() {
        if (this.cachedExtendedBounds == null) {
            Parent parent = this.getScene().getRoot();
            this.cachedExtendedBounds = this.union(parent.getLayoutBounds(), parent.getBoundsInLocal());
        }
        return this.cachedExtendedBounds;
    }

    private Bounds getAnchorBounds() {
        if (this.cachedAnchorBounds == null) {
            this.cachedAnchorBounds = this.getAnchorLocation().isContentLocation() ? this.getScene().getRoot().getLayoutBounds() : this.getExtendedBounds();
        }
        return this.cachedAnchorBounds;
    }

    private void updateWindow(double d2, double d3) {
        PopupWindow$AnchorLocation popupWindow$AnchorLocation = this.getAnchorLocation();
        Parent parent = this.getScene().getRoot();
        Bounds bounds = this.getExtendedBounds();
        Bounds bounds2 = this.getAnchorBounds();
        double d4 = popupWindow$AnchorLocation.getXCoef();
        double d5 = popupWindow$AnchorLocation.getYCoef();
        double d6 = d4 * bounds2.getWidth();
        double d7 = d5 * bounds2.getHeight();
        double d8 = d2 - d6;
        double d9 = d3 - d7;
        if (this.autofixActive) {
            Rectangle2D rectangle2D;
            Screen screen = Utils.getScreenForPoint(d2, d3);
            Rectangle2D rectangle2D2 = rectangle2D = Utils.hasFullScreenStage(screen) ? screen.getBounds() : screen.getVisualBounds();
            if (d4 <= 0.5) {
                d8 = Math.min(d8, rectangle2D.getMaxX() - bounds2.getWidth());
                d8 = Math.max(d8, rectangle2D.getMinX());
            } else {
                d8 = Math.max(d8, rectangle2D.getMinX());
                d8 = Math.min(d8, rectangle2D.getMaxX() - bounds2.getWidth());
            }
            if (d5 <= 0.5) {
                d9 = Math.min(d9, rectangle2D.getMaxY() - bounds2.getHeight());
                d9 = Math.max(d9, rectangle2D.getMinY());
            } else {
                d9 = Math.max(d9, rectangle2D.getMinY());
                d9 = Math.min(d9, rectangle2D.getMaxY() - bounds2.getHeight());
            }
        }
        double d10 = d8 - bounds2.getMinX() + bounds.getMinX();
        double d11 = d9 - bounds2.getMinY() + bounds.getMinY();
        this.setWidth(bounds.getWidth());
        this.setHeight(bounds.getHeight());
        parent.setTranslateX(-bounds.getMinX());
        parent.setTranslateY(-bounds.getMinY());
        if (!Double.isNaN(d10)) {
            super.setXInternal(d10);
        }
        if (!Double.isNaN(d11)) {
            super.setYInternal(d11);
        }
        this.anchorX.set(d8 + d6);
        this.anchorY.set(d9 + d7);
    }

    private Bounds union(Bounds bounds, Bounds bounds2) {
        double d2 = Math.min(bounds.getMinX(), bounds2.getMinX());
        double d3 = Math.min(bounds.getMinY(), bounds2.getMinY());
        double d4 = Math.max(bounds.getMaxX(), bounds2.getMaxX());
        double d5 = Math.max(bounds.getMaxY(), bounds2.getMaxY());
        return new BoundingBox(d2, d3, d4 - d2, d5 - d3);
    }

    private double windowToAnchorX(double d2) {
        Bounds bounds = this.getAnchorBounds();
        return d2 - this.getExtendedBounds().getMinX() + bounds.getMinX() + this.getAnchorLocation().getXCoef() * bounds.getWidth();
    }

    private double windowToAnchorY(double d2) {
        Bounds bounds = this.getAnchorBounds();
        return d2 - this.getExtendedBounds().getMinY() + bounds.getMinY() + this.getAnchorLocation().getYCoef() * bounds.getHeight();
    }

    private static Window getRootWindow(Window window) {
        while (window instanceof PopupWindow) {
            window = ((PopupWindow)window).getOwnerWindow();
        }
        return window;
    }

    void doAutoHide() {
        ((Window)this).hide();
        if (this.getOnAutoHide() != null) {
            PopupWindow popupWindow = this;
            this.getOnAutoHide().handle(new Event(popupWindow, popupWindow, Event.ANY));
        }
    }

    @Override
    WindowEventDispatcher createInternalEventDispatcher() {
        return new WindowEventDispatcher(new PopupWindow$PopupEventRedirector(this), new WindowCloseRequestHandler(this), new EventHandlerManager(this));
    }

    @Override
    Window getWindowOwner() {
        return this.getOwnerWindow();
    }

    private void startMonitorOwnerEvents(Window object) {
        object = ((Window)object).getInternalEventDispatcher().getEventRedirector();
        ((EventRedirector)object).addEventDispatcher(this.getEventDispatcher());
    }

    private void stopMonitorOwnerEvents(Window object) {
        object = ((Window)object).getInternalEventDispatcher().getEventRedirector();
        ((EventRedirector)object).removeEventDispatcher(this.getEventDispatcher());
    }

    private void bindOwnerFocusedProperty(Window window) {
        this.ownerFocusedListener = (observableValue, bl2, bl3) -> WindowHelper.setFocused(this, bl3);
        window.focusedProperty().addListener(this.ownerFocusedListener);
    }

    private void unbindOwnerFocusedProperty(Window window) {
        window.focusedProperty().removeListener(this.ownerFocusedListener);
        this.ownerFocusedListener = null;
    }

    private void handleAutofixActivation(boolean bl2, boolean bl3) {
        boolean bl4 = bl2 = bl2 && bl3;
        if (this.autofixActive != bl2) {
            this.autofixActive = bl2;
            if (bl2) {
                Screen.getScreens().addListener(this.popupWindowUpdater);
                PopupWindow popupWindow = this;
                popupWindow.updateWindow(popupWindow.getAnchorX(), this.getAnchorY());
                return;
            }
            Screen.getScreens().removeListener(this.popupWindowUpdater);
        }
    }

    private void handleAutohideActivation(boolean bl2, boolean bl3) {
        boolean bl4 = bl2 = bl2 && bl3;
        if (this.autohideActive != bl2) {
            this.autohideActive = bl2;
            if (bl2) {
                this.rootWindow.increaseFocusGrabCounter();
                return;
            }
            this.rootWindow.decreaseFocusGrabCounter();
        }
    }

    private void validateOwnerWindow(Window window) {
        if (window == null) {
            throw new NullPointerException("Owner window must not be null");
        }
        if (PopupWindow.wouldCreateCycle(window, this)) {
            throw new IllegalArgumentException("Specified owner window would create cycle in the window hierarchy");
        }
        if (this.isShowing() && this.getOwnerWindow() != window) {
            throw new IllegalStateException("Popup is already shown with different owner window");
        }
    }

    private static boolean wouldCreateCycle(Window window, Window window2) {
        while (window != null) {
            if (window == window2) {
                return true;
            }
            window = window.getWindowOwner();
        }
        return false;
    }

    static {
        PopupWindowHelper.setPopupWindowAccessor(new PopupWindow$1());
    }
}

