/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.Toolkit;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;

public final class Screen {
    private static final AtomicBoolean configurationDirty = new AtomicBoolean(true);
    private static final ScreenConfigurationAccessor accessor;
    private static Screen primary;
    private static final ObservableList<Screen> screens;
    private static final ObservableList<Screen> unmodifiableScreens;
    private Rectangle2D bounds = Rectangle2D.EMPTY;
    private Rectangle2D visualBounds = Rectangle2D.EMPTY;
    private double dpi;
    private float outputScaleX;
    private float outputScaleY;

    private Screen() {
    }

    private static void checkDirty() {
        if (configurationDirty.compareAndSet(true, false)) {
            Screen.updateConfiguration();
        }
    }

    private static void updateConfiguration() {
        List<?> list = Toolkit.getToolkit().getPrimaryScreen();
        if ((list = Screen.nativeToScreen(list, primary)) != null) {
            primary = list;
        }
        list = Toolkit.getToolkit().getScreens();
        ObservableList<Object> observableList = FXCollections.observableArrayList();
        boolean bl2 = screens.size() == list.size();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            Screen screen = null;
            if (bl2) {
                screen = (Screen)screens.get(i2);
            }
            if ((object = Screen.nativeToScreen(object, screen)) == null) continue;
            if (bl2) {
                bl2 = false;
                observableList.setAll(screens.subList(0, i2));
            }
            observableList.add(object);
        }
        if (!bl2) {
            screens.setAll((Collection<Screen>)observableList);
        }
        configurationDirty.set(false);
    }

    private static Screen nativeToScreen(Object object, Screen screen) {
        int n2 = accessor.getMinX(object);
        int n3 = accessor.getMinY(object);
        int n4 = accessor.getWidth(object);
        int n5 = accessor.getHeight(object);
        int n6 = accessor.getVisualMinX(object);
        int n7 = accessor.getVisualMinY(object);
        int n8 = accessor.getVisualWidth(object);
        int n9 = accessor.getVisualHeight(object);
        double d2 = accessor.getDPI(object);
        float f2 = accessor.getRecommendedOutputScaleX(object);
        float f3 = accessor.getRecommendedOutputScaleY(object);
        if (screen == null || screen.bounds.getMinX() != (double)n2 || screen.bounds.getMinY() != (double)n3 || screen.bounds.getWidth() != (double)n4 || screen.bounds.getHeight() != (double)n5 || screen.visualBounds.getMinX() != (double)n6 || screen.visualBounds.getMinY() != (double)n7 || screen.visualBounds.getWidth() != (double)n8 || screen.visualBounds.getHeight() != (double)n9 || screen.dpi != d2 || screen.outputScaleX != f2 || screen.outputScaleY != f3) {
            screen = new Screen();
            new Screen().bounds = new Rectangle2D(n2, n3, n4, n5);
            screen.visualBounds = new Rectangle2D(n6, n7, n8, n9);
            screen.dpi = d2;
            screen.outputScaleX = f2;
            screen.outputScaleY = f3;
            return screen;
        }
        return null;
    }

    static Screen getScreenForNative(Object object) {
        double d2 = accessor.getMinX(object);
        double d3 = accessor.getMinY(object);
        double d4 = accessor.getWidth(object);
        double d5 = accessor.getHeight(object);
        object = null;
        for (int i2 = 0; i2 < screens.size(); ++i2) {
            Screen screen = (Screen)screens.get(i2);
            if (screen.bounds.contains(d2, d3, d4, d5)) {
                return screen;
            }
            if (object != null || !screen.bounds.intersects(d2, d3, d4, d5)) continue;
            object = screen;
        }
        if (object == null) {
            return Screen.getPrimary();
        }
        return object;
    }

    public static Screen getPrimary() {
        Screen.checkDirty();
        return primary;
    }

    public static ObservableList<Screen> getScreens() {
        Screen.checkDirty();
        return unmodifiableScreens;
    }

    public static ObservableList<Screen> getScreensForRectangle(double d2, double d3, double d4, double d5) {
        Screen.checkDirty();
        ObservableList<Screen> observableList = FXCollections.observableArrayList();
        for (Screen screen : screens) {
            if (!screen.bounds.intersects(d2, d3, d4, d5)) continue;
            observableList.add(screen);
        }
        return observableList;
    }

    public static ObservableList<Screen> getScreensForRectangle(Rectangle2D rectangle2D) {
        Screen.checkDirty();
        return Screen.getScreensForRectangle(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public final Rectangle2D getBounds() {
        return this.bounds;
    }

    public final Rectangle2D getVisualBounds() {
        return this.visualBounds;
    }

    public final double getDpi() {
        return this.dpi;
    }

    public final double getOutputScaleX() {
        return this.outputScaleX;
    }

    public final double getOutputScaleY() {
        return this.outputScaleY;
    }

    public final int hashCode() {
        long l2 = 259L + (long)this.bounds.hashCode();
        l2 = 37L * l2 + (long)this.visualBounds.hashCode();
        l2 = 37L * l2 + Double.doubleToLongBits(this.dpi);
        l2 = 37L * l2 + (long)Float.floatToIntBits(this.outputScaleX);
        l2 = 37L * l2 + (long)Float.floatToIntBits(this.outputScaleY);
        return (int)(l2 ^ l2 >> 32);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Screen) {
            object = (Screen)object;
            return (this.bounds == null ? ((Screen)object).bounds == null : this.bounds.equals(((Screen)object).bounds)) && (this.visualBounds == null ? ((Screen)object).visualBounds == null : this.visualBounds.equals(((Screen)object).visualBounds)) && ((Screen)object).dpi == this.dpi && ((Screen)object).outputScaleX == this.outputScaleX && ((Screen)object).outputScaleY == this.outputScaleY;
        }
        return false;
    }

    public final String toString() {
        return super.toString() + " bounds:" + String.valueOf(this.bounds) + " visualBounds:" + String.valueOf(this.visualBounds) + " dpi:" + this.dpi + " outputScale:(" + this.outputScaleX + "," + this.outputScaleY + ")";
    }

    static {
        screens = FXCollections.observableArrayList();
        unmodifiableScreens = FXCollections.unmodifiableObservableList(screens);
        accessor = Toolkit.getToolkit().setScreenConfigurationListener(() -> Screen.updateConfiguration());
    }
}

