/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine$1;
import org.apache.commons.cli.CommandLine$Builder;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Util;

public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args;
    private final List<Option> options;
    private final transient Consumer<Option> deprecatedHandler;

    public static CommandLine$Builder builder() {
        return new CommandLine$Builder();
    }

    protected CommandLine() {
        this(new LinkedList<String>(), new ArrayList<Option>(), CommandLine$Builder.DEPRECATED_HANDLER);
    }

    private CommandLine(List<String> list, List<Option> list2, Consumer<Option> consumer) {
        this.args = Objects.requireNonNull(list, "args");
        this.options = Objects.requireNonNull(list2, "options");
        this.deprecatedHandler = consumer;
    }

    protected void addArg(String string) {
        if (string != null) {
            this.args.add(string);
        }
    }

    protected void addOption(Option option) {
        if (option != null) {
            this.options.add(option);
        }
    }

    private <T> T get(Supplier<T> supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    public List<String> getArgList() {
        return this.args;
    }

    public String[] getArgs() {
        return this.args.toArray(Util.EMPTY_STRING_ARRAY);
    }

    @Deprecated
    public Object getOptionObject(char c2) {
        return this.getOptionObject(String.valueOf(c2));
    }

    @Deprecated
    public Object getOptionObject(String string) {
        try {
            return this.getParsedOptionValue(string);
        }
        catch (ParseException parseException) {
            System.err.println("Exception found converting " + string + " to desired type: " + parseException.getMessage());
            return null;
        }
    }

    public Properties getOptionProperties(Option option) {
        Properties properties = new Properties();
        for (Option option2 : this.options) {
            if (!option2.equals(option)) continue;
            this.processPropertiesFromValues(properties, option2.getValuesList());
        }
        return properties;
    }

    public Properties getOptionProperties(String string) {
        Properties properties = new Properties();
        for (Option option : this.options) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            this.processPropertiesFromValues(properties, option.getValuesList());
        }
        return properties;
    }

    public Option[] getOptions() {
        return this.options.toArray(Option.EMPTY_ARRAY);
    }

    public String getOptionValue(char c2) {
        return this.getOptionValue(String.valueOf(c2));
    }

    public String getOptionValue(char c2, String string) {
        return this.getOptionValue(String.valueOf(c2), () -> string);
    }

    public String getOptionValue(char c2, Supplier<String> supplier) {
        return this.getOptionValue(String.valueOf(c2), supplier);
    }

    public String getOptionValue(Option stringArray) {
        if ((stringArray = this.getOptionValues((Option)stringArray)) == null) {
            return null;
        }
        return stringArray[0];
    }

    public String getOptionValue(Option option, String string) {
        return this.getOptionValue(option, () -> string);
    }

    public String getOptionValue(Option object, Supplier<String> supplier) {
        if ((object = this.getOptionValue((Option)object)) != null) {
            return object;
        }
        return this.get(supplier);
    }

    public String getOptionValue(OptionGroup stringArray) {
        if ((stringArray = this.getOptionValues((OptionGroup)stringArray)) == null) {
            return null;
        }
        return stringArray[0];
    }

    public String getOptionValue(OptionGroup optionGroup, String string) {
        return this.getOptionValue(optionGroup, () -> string);
    }

    public String getOptionValue(OptionGroup object, Supplier<String> supplier) {
        if ((object = this.getOptionValue((OptionGroup)object)) != null) {
            return object;
        }
        return this.get(supplier);
    }

    public String getOptionValue(String string) {
        CommandLine commandLine = this;
        return commandLine.getOptionValue(commandLine.resolveOption(string));
    }

    public String getOptionValue(String string, String string2) {
        CommandLine commandLine = this;
        return commandLine.getOptionValue(commandLine.resolveOption(string), () -> string2);
    }

    public String getOptionValue(String string, Supplier<String> supplier) {
        CommandLine commandLine = this;
        return commandLine.getOptionValue(commandLine.resolveOption(string), supplier);
    }

    public String[] getOptionValues(char c2) {
        return this.getOptionValues(String.valueOf(c2));
    }

    public String[] getOptionValues(Option option) {
        if (option == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Option option2 : this.options) {
            if (!option2.equals(option)) continue;
            if (option.isDeprecated()) {
                this.handleDeprecated(option);
            }
            arrayList.addAll(option2.getValuesList());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(Util.EMPTY_STRING_ARRAY);
    }

    public String[] getOptionValues(OptionGroup optionGroup) {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return null;
        }
        return this.getOptionValues(optionGroup.getSelected());
    }

    public String[] getOptionValues(String string) {
        CommandLine commandLine = this;
        return commandLine.getOptionValues(commandLine.resolveOption(string));
    }

    public <T> T getParsedOptionValue(char c2) throws ParseException {
        return this.getParsedOptionValue(String.valueOf(c2));
    }

    public <T> T getParsedOptionValue(char c2, Supplier<T> supplier) throws ParseException {
        return (T)this.getParsedOptionValue(String.valueOf(c2), (T)supplier);
    }

    public <T> T getParsedOptionValue(char c2, T t2) throws ParseException {
        return this.getParsedOptionValue(String.valueOf(c2), t2);
    }

    public <T> T getParsedOptionValue(Option option) throws ParseException {
        return (T)this.getParsedOptionValue(option, (T)((Supplier<Object>)() -> null));
    }

    public <T> T getParsedOptionValue(Option serializable, Supplier<T> supplier) throws ParseException {
        if (serializable == null) {
            return this.get(supplier);
        }
        String string = this.getOptionValue((Option)serializable);
        try {
            if (string == null) {
                return this.get(supplier);
            }
            return (T)serializable.getConverter().apply(string);
        }
        catch (Exception exception) {
            serializable = exception;
            throw ParseException.wrap(exception);
        }
    }

    public <T> T getParsedOptionValue(Option option, T t2) throws ParseException {
        return (T)this.getParsedOptionValue(option, (T)((Supplier<Object>)() -> t2));
    }

    public <T> T getParsedOptionValue(OptionGroup optionGroup) throws ParseException {
        return (T)this.getParsedOptionValue(optionGroup, (T)((Supplier<Object>)() -> null));
    }

    public <T> T getParsedOptionValue(OptionGroup optionGroup, Supplier<T> supplier) throws ParseException {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return this.get(supplier);
        }
        return (T)this.getParsedOptionValue(optionGroup.getSelected(), (T)supplier);
    }

    public <T> T getParsedOptionValue(OptionGroup optionGroup, T t2) throws ParseException {
        return (T)this.getParsedOptionValue(optionGroup, (T)((Supplier<Object>)() -> t2));
    }

    public <T> T getParsedOptionValue(String string) throws ParseException {
        CommandLine commandLine = this;
        return commandLine.getParsedOptionValue(commandLine.resolveOption(string));
    }

    public <T> T getParsedOptionValue(String string, Supplier<T> supplier) throws ParseException {
        CommandLine commandLine = this;
        return (T)commandLine.getParsedOptionValue(commandLine.resolveOption(string), (T)supplier);
    }

    public <T> T getParsedOptionValue(String string, T t2) throws ParseException {
        CommandLine commandLine = this;
        return commandLine.getParsedOptionValue(commandLine.resolveOption(string), t2);
    }

    public <T> T[] getParsedOptionValues(char c2) throws ParseException {
        return this.getParsedOptionValues(String.valueOf(c2));
    }

    public <T> T[] getParsedOptionValues(char c2, Supplier<T[]> supplier) throws ParseException {
        return this.getParsedOptionValues(String.valueOf(c2), supplier);
    }

    public <T> T[] getParsedOptionValues(char c2, T[] TArray) throws ParseException {
        return this.getParsedOptionValues(String.valueOf(c2), TArray);
    }

    public <T> T[] getParsedOptionValues(Option option) throws ParseException {
        return this.getParsedOptionValues(option, () -> null);
    }

    public <T> T[] getParsedOptionValues(Option option, Supplier<T[]> objectArray) throws ParseException {
        if (option == null) {
            return this.get((Supplier<T>)objectArray);
        }
        Class clazz = (Class)option.getType();
        String[] stringArray = this.getOptionValues(option);
        if (stringArray == null) {
            return this.get((Supplier<T>)objectArray);
        }
        objectArray = (Object[])Array.newInstance(clazz, stringArray.length);
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                objectArray[i2] = clazz.cast(option.getConverter().apply(stringArray[i2]));
            }
            return objectArray;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw ParseException.wrap(exception);
        }
    }

    public <T> T[] getParsedOptionValues(Option option, T[] TArray) throws ParseException {
        return this.getParsedOptionValues(option, () -> TArray);
    }

    public <T> T[] getParsedOptionValues(OptionGroup optionGroup) throws ParseException {
        return this.getParsedOptionValues(optionGroup, () -> null);
    }

    public <T> T[] getParsedOptionValues(OptionGroup optionGroup, Supplier<T[]> supplier) throws ParseException {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return this.get(supplier);
        }
        return this.getParsedOptionValues(optionGroup.getSelected(), supplier);
    }

    public <T> T[] getParsedOptionValues(OptionGroup optionGroup, T[] TArray) throws ParseException {
        return this.getParsedOptionValues(optionGroup, () -> TArray);
    }

    public <T> T[] getParsedOptionValues(String string) throws ParseException {
        CommandLine commandLine = this;
        return commandLine.getParsedOptionValues(commandLine.resolveOption(string));
    }

    public <T> T[] getParsedOptionValues(String string, Supplier<T[]> supplier) throws ParseException {
        CommandLine commandLine = this;
        return commandLine.getParsedOptionValues(commandLine.resolveOption(string), supplier);
    }

    public <T> T[] getParsedOptionValues(String string, T[] TArray) throws ParseException {
        CommandLine commandLine = this;
        return commandLine.getParsedOptionValues(commandLine.resolveOption(string), TArray);
    }

    private void handleDeprecated(Option option) {
        if (this.deprecatedHandler != null) {
            this.deprecatedHandler.accept(option);
        }
    }

    public boolean hasOption(char c2) {
        return this.hasOption(String.valueOf(c2));
    }

    public boolean hasOption(Option option) {
        boolean bl2 = this.options.contains(option);
        if (bl2 && option.isDeprecated()) {
            this.handleDeprecated(option);
        }
        return bl2;
    }

    public boolean hasOption(OptionGroup optionGroup) {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return false;
        }
        return this.hasOption(optionGroup.getSelected());
    }

    public boolean hasOption(String string) {
        CommandLine commandLine = this;
        return commandLine.hasOption(commandLine.resolveOption(string));
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    private void processPropertiesFromValues(Properties properties, List<String> list) {
        for (int i2 = 0; i2 < list.size(); i2 += 2) {
            if (i2 + 1 < list.size()) {
                properties.put(list.get(i2), list.get(i2 + 1));
                continue;
            }
            properties.put(list.get(i2), "true");
        }
    }

    private Option resolveOption(String string) {
        if ((string = Util.stripLeadingHyphens(string)) != null) {
            for (Option option : this.options) {
                if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
                return option;
            }
        }
        return null;
    }

    /* synthetic */ CommandLine(List list, List list2, Consumer consumer, CommandLine$1 commandLine$1) {
        this(list, list2, consumer);
    }
}

