/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@FunctionalInterface
public interface Converter<T, E extends Exception> {
    public static final Converter<?, RuntimeException> DEFAULT = string -> string;
    public static final Converter<Class<?>, ClassNotFoundException> CLASS = Class::forName;
    public static final Converter<File, NullPointerException> FILE = File::new;
    public static final Converter<Path, InvalidPathException> PATH = string -> Paths.get(string, new String[0]);
    public static final Converter<Number, NumberFormatException> NUMBER = string -> {
        if (string.indexOf(46) != -1) {
            return Double.valueOf(string);
        }
        return Long.valueOf(string);
    };
    public static final Converter<Object, ReflectiveOperationException> OBJECT = string -> CLASS.apply(string).getConstructor(new Class[0]).newInstance(new Object[0]);
    public static final Converter<URL, MalformedURLException> URL = URL::new;
    public static final Converter<Date, ParseException> DATE = string -> new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(string);

    public T apply(String var1) throws E;
}

