/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.AmbiguousOptionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLine$Builder;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser$1;
import org.apache.commons.cli.DefaultParser$Builder;
import org.apache.commons.cli.DefaultParser$NonOptionAction;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.Util;

public class DefaultParser
implements CommandLineParser {
    protected CommandLine cmd;
    protected Options options;
    @Deprecated
    protected boolean stopAtNonOption;
    protected DefaultParser$NonOptionAction nonOptionAction;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List expectedOpts;
    private final boolean allowPartialMatching;
    private final Boolean stripLeadingAndTrailingQuotes;
    private final Consumer<Option> deprecatedHandler;

    public static DefaultParser$Builder builder() {
        return new DefaultParser$Builder(null);
    }

    static int indexOfEqual(String string) {
        return string.indexOf(61);
    }

    public DefaultParser() {
        this.allowPartialMatching = true;
        this.stripLeadingAndTrailingQuotes = null;
        this.deprecatedHandler = CommandLine$Builder.DEPRECATED_HANDLER;
    }

    public DefaultParser(boolean bl2) {
        this.allowPartialMatching = bl2;
        this.stripLeadingAndTrailingQuotes = null;
        this.deprecatedHandler = CommandLine$Builder.DEPRECATED_HANDLER;
    }

    private DefaultParser(boolean bl2, Boolean bl3, Consumer<Option> consumer) {
        this.allowPartialMatching = bl2;
        this.stripLeadingAndTrailingQuotes = bl3;
        this.deprecatedHandler = consumer;
    }

    protected void addArg(String string) {
        this.cmd.addArg(string);
    }

    private void checkRequiredArgs() throws ParseException {
        if (this.currentOption != null && this.currentOption.requiresArg()) {
            DefaultParser defaultParser = this;
            if (defaultParser.isJavaProperty(defaultParser.currentOption.getKey()) && this.currentOption.getValuesList().size() == 1) {
                return;
            }
            throw new MissingArgumentException(this.currentOption);
        }
    }

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private String getLongPrefix(String string) {
        string = Util.stripLeadingHyphens(string);
        String string2 = null;
        for (int i2 = string.length() - 2; i2 > 1; --i2) {
            String string3 = string.substring(0, i2);
            if (!this.options.hasLongOption(string3)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private List<String> getMatchingLongOptions(String string) {
        if (this.allowPartialMatching) {
            return this.options.getMatchingOptions(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (this.options.hasLongOption(string)) {
            arrayList.add(this.options.getOption(string).getLongOpt());
        }
        return arrayList;
    }

    protected void handleConcatenatedOptions(String string) throws ParseException {
        for (int i2 = 1; i2 < string.length(); ++i2) {
            String string2 = String.valueOf(string.charAt(i2));
            if (!this.options.hasOption(string2)) {
                DefaultParser defaultParser = this;
                defaultParser.handleUnknownToken(defaultParser.nonOptionAction == DefaultParser$NonOptionAction.STOP && i2 > 1 ? string.substring(i2) : string);
                return;
            }
            DefaultParser defaultParser = this;
            defaultParser.handleOption(defaultParser.options.getOption(string2));
            if (this.currentOption == null || string.length() == i2 + 1) continue;
            this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(string.substring(i2 + 1)));
            return;
        }
    }

    private void handleLongOption(String string) throws ParseException {
        if (DefaultParser.indexOfEqual(string) == -1) {
            this.handleLongOptionWithoutEqual(string);
            return;
        }
        this.handleLongOptionWithEqual(string);
    }

    private void handleLongOptionWithEqual(String object) throws ParseException {
        int n2 = DefaultParser.indexOfEqual((String)object);
        String string = ((String)object).substring(n2 + 1);
        List<String> list = this.getMatchingLongOptions((String)(object = ((String)object).substring(0, n2)));
        if (!list.isEmpty()) {
            if (list.size() > 1 && !this.options.hasLongOption((String)object)) {
                throw new AmbiguousOptionException((String)object, list);
            }
            object = this.options.hasLongOption((String)object) ? object : list.get(0);
            if (((Option)(object = this.options.getOption((String)object))).acceptsArg()) {
                this.handleOption((Option)object);
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(string));
                this.currentOption = null;
                return;
            }
        }
        DefaultParser defaultParser = this;
        defaultParser.handleUnknownToken(defaultParser.currentToken);
    }

    private void handleLongOptionWithoutEqual(String string) throws ParseException {
        List<String> list = this.getMatchingLongOptions(string);
        if (list.isEmpty()) {
            DefaultParser defaultParser = this;
            defaultParser.handleUnknownToken(defaultParser.currentToken);
            return;
        }
        if (list.size() > 1 && !this.options.hasLongOption(string)) {
            throw new AmbiguousOptionException(string, list);
        }
        string = this.options.hasLongOption(string) ? string : list.get(0);
        DefaultParser defaultParser = this;
        defaultParser.handleOption(defaultParser.options.getOption(string));
    }

    private void handleOption(Option option) throws ParseException {
        this.checkRequiredArgs();
        option = (Option)option.clone();
        this.updateRequiredOptions(option);
        this.cmd.addOption(option);
        this.currentOption = option.hasArg() ? option : null;
    }

    private void handleProperties(Properties properties) throws ParseException {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            String string = enumeration.nextElement().toString();
            Option option = this.options.getOption(string);
            if (option == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", string);
            }
            OptionGroup optionGroup = this.options.getOptionGroup(option);
            boolean bl3 = bl2 = optionGroup != null && optionGroup.isSelected();
            if (this.cmd.hasOption(string) || bl2) continue;
            string = properties.getProperty(string);
            if (option.hasArg()) {
                if (Util.isEmpty(option.getValues())) {
                    option.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(string));
                }
            } else if (!"yes".equalsIgnoreCase(string) && !"true".equalsIgnoreCase(string) && !"1".equalsIgnoreCase(string)) continue;
            this.handleOption(option);
            this.currentOption = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleShortAndLongOption(String string) throws ParseException {
        String string2 = Util.stripLeadingHyphens(string);
        int n2 = DefaultParser.indexOfEqual(string2);
        if (string2.length() == 1) {
            if (this.options.hasShortOption(string2)) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption(defaultParser.options.getOption(string2));
                return;
            }
            this.handleUnknownToken(string);
            return;
        }
        if (n2 == -1) {
            if (this.options.hasShortOption(string2)) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption(defaultParser.options.getOption(string2));
                return;
            }
            if (!this.getMatchingLongOptions(string2).isEmpty()) {
                this.handleLongOptionWithoutEqual(string);
                return;
            }
            String string3 = this.getLongPrefix(string2);
            if (string3 != null && this.options.getOption(string3).acceptsArg()) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption(defaultParser.options.getOption(string3));
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(string2.substring(string3.length())));
                this.currentOption = null;
                return;
            }
            if (this.isJavaProperty(string2)) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption(defaultParser.options.getOption(string2.substring(0, 1)));
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(string2.substring(1)));
                this.currentOption = null;
                return;
            }
            this.handleConcatenatedOptions(string);
            return;
        }
        String string4 = string2.substring(0, n2);
        string2 = string2.substring(n2 + 1);
        if (string4.length() == 1) {
            Option option = this.options.getOption(string4);
            if (option != null && option.acceptsArg()) {
                this.handleOption(option);
                this.currentOption.processValue(string2);
                this.currentOption = null;
                return;
            }
            this.handleUnknownToken(string);
            return;
        }
        if (this.isJavaProperty(string4)) {
            DefaultParser defaultParser = this;
            defaultParser.handleOption(defaultParser.options.getOption(string4.substring(0, 1)));
            this.currentOption.processValue(string4.substring(1));
            this.currentOption.processValue(string2);
            this.currentOption = null;
            return;
        }
        this.handleLongOptionWithEqual(string);
    }

    private void handleToken(String string) throws ParseException {
        if (string != null) {
            this.currentToken = string;
            if (this.skipParsing) {
                this.addArg(string);
            } else if ("--".equals(string)) {
                this.skipParsing = true;
            } else if (this.currentOption != null && this.currentOption.acceptsArg() && this.isArgument(string)) {
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOn(string));
            } else if (string.startsWith("--")) {
                this.handleLongOption(string);
            } else if (string.startsWith("-") && !"-".equals(string)) {
                this.handleShortAndLongOption(string);
            } else {
                this.handleUnknownToken(string);
            }
            if (this.currentOption != null && !this.currentOption.acceptsArg()) {
                this.currentOption = null;
            }
        }
    }

    protected void handleUnknownToken(String string) throws ParseException {
        if (string.startsWith("-") && string.length() > 1 && this.nonOptionAction == DefaultParser$NonOptionAction.THROW) {
            throw new UnrecognizedOptionException("Unrecognized option: " + string, string);
        }
        if (!string.startsWith("-") || string.equals("-") || string.length() > 1 && this.nonOptionAction != DefaultParser$NonOptionAction.IGNORE) {
            this.addArg(string);
        }
        if (this.nonOptionAction == DefaultParser$NonOptionAction.STOP) {
            this.skipParsing = true;
        }
    }

    private boolean isArgument(String string) {
        return !this.isOption(string) || this.isNegativeNumber(string);
    }

    private boolean isJavaProperty(String object) {
        object = ((String)object).isEmpty() ? null : ((String)object).substring(0, 1);
        return (object = this.options.getOption((String)object)) != null && (((Option)object).getArgs() >= 2 || ((Option)object).getArgs() == -2);
    }

    private boolean isLongOption(String string) {
        String string2;
        if (string == null || !string.startsWith("-") || string.length() == 1) {
            return false;
        }
        int n2 = DefaultParser.indexOfEqual(string);
        String string3 = string2 = n2 == -1 ? string : string.substring(0, n2);
        if (!this.getMatchingLongOptions(string2).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(string) != null && !string.startsWith("--");
    }

    private boolean isNegativeNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isOption(String string) {
        return this.isLongOption(string) || this.isShortOption(string);
    }

    private boolean isShortOption(String string) {
        if (string == null || !string.startsWith("-") || string.length() == 1) {
            return false;
        }
        int n2 = DefaultParser.indexOfEqual(string);
        String string2 = string = n2 == -1 ? string.substring(1) : string.substring(1, n2);
        if (this.options.hasShortOption(string)) {
            return true;
        }
        return !string.isEmpty() && this.options.hasShortOption(String.valueOf(string.charAt(0)));
    }

    /*
     * WARNING - void declaration
     */
    public CommandLine parse(Options stringArray, Properties properties, DefaultParser$NonOptionAction object2, String ... stringArray2) throws ParseException {
        void var4_7;
        this.options = (Options)Objects.requireNonNull(stringArray, "options");
        this.nonOptionAction = object2;
        this.skipParsing = false;
        this.currentOption = null;
        this.expectedOpts = new ArrayList(((Options)stringArray).getRequiredOptions());
        for (OptionGroup optionGroup : ((Options)stringArray).getOptionGroups()) {
            optionGroup.setSelected(null);
        }
        this.cmd = CommandLine.builder().setDeprecatedHandler(this.deprecatedHandler).get();
        if (var4_7 != null) {
            for (Object object : var4_7) {
                this.handleToken((String)object);
            }
        }
        this.checkRequiredArgs();
        this.handleProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    @Override
    public CommandLine parse(Options options, String[] stringArray) throws ParseException {
        return this.parse(options, stringArray, null);
    }

    @Override
    public CommandLine parse(Options options, String[] stringArray, boolean bl2) throws ParseException {
        return this.parse(options, stringArray, null, bl2);
    }

    public CommandLine parse(Options options, String[] stringArray, Properties properties) throws ParseException {
        return this.parse(options, stringArray, properties, false);
    }

    public CommandLine parse(Options options, String[] stringArray, Properties properties, boolean bl2) throws ParseException {
        return this.parse(options, properties, bl2 ? DefaultParser$NonOptionAction.STOP : DefaultParser$NonOptionAction.THROW, stringArray);
    }

    private String stripLeadingAndTrailingQuotesDefaultOff(String string) {
        if (this.stripLeadingAndTrailingQuotes != null && this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(string);
        }
        return string;
    }

    private String stripLeadingAndTrailingQuotesDefaultOn(String string) {
        if (this.stripLeadingAndTrailingQuotes == null || this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(string);
        }
        return string;
    }

    private void updateRequiredOptions(Option option) throws AlreadySelectedException {
        if (option.isRequired()) {
            this.expectedOpts.remove(option.getKey());
        }
        if (this.options.getOptionGroup(option) != null) {
            OptionGroup optionGroup = this.options.getOptionGroup(option);
            if (optionGroup.isRequired()) {
                this.expectedOpts.remove(optionGroup);
            }
            optionGroup.setSelected(option);
        }
    }

    /* synthetic */ DefaultParser(boolean bl2, Boolean bl3, Consumer consumer, DefaultParser$1 defaultParser$1) {
        this(bl2, bl3, consumer);
    }
}

