/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.cli.HelpFormatter$1;
import org.apache.commons.cli.HelpFormatter$Builder;
import org.apache.commons.cli.HelpFormatter$OptionComparator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Util;

@Deprecated
public class HelpFormatter {
    private static final String HEADER_OPTIONS = "Options";
    private static final String HEADER_SINCE = "Since";
    private static final String HEADER_DESCRIPTION = "Description";
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    public static final String DEFAULT_ARG_NAME = "arg";
    @Deprecated
    public int defaultWidth = 74;
    @Deprecated
    public int defaultLeftPad = 1;
    @Deprecated
    public int defaultDescPad = 3;
    @Deprecated
    public String defaultSyntaxPrefix = "usage: ";
    @Deprecated
    public String defaultNewLine = System.lineSeparator();
    @Deprecated
    public String defaultOptPrefix = "-";
    @Deprecated
    public String defaultLongOptPrefix = "--";
    @Deprecated
    public String defaultArgName = "arg";
    protected Comparator<Option> optionComparator = new HelpFormatter$OptionComparator(null);
    private final Function<Option, String> deprecatedFormatFunction;
    private final PrintWriter printWriter;
    private final boolean showSince;
    private String longOptSeparator = " ";

    public static HelpFormatter$Builder builder() {
        return new HelpFormatter$Builder();
    }

    private static PrintWriter createDefaultPrintWriter() {
        return new PrintWriter(System.out);
    }

    public static String getDescription(Option object) {
        if ((object = ((Option)object).getDescription()) == null) {
            return "";
        }
        return object;
    }

    public HelpFormatter() {
        this(null, HelpFormatter.createDefaultPrintWriter(), false);
    }

    private HelpFormatter(Function<Option, String> function, PrintWriter printWriter, boolean bl2) {
        this.deprecatedFormatFunction = function;
        this.printWriter = printWriter;
        this.showSince = bl2;
    }

    private void appendOption(StringBuilder stringBuilder, Option option, boolean bl2) {
        if (!bl2) {
            stringBuilder.append("[");
        }
        if (option.getOpt() != null) {
            stringBuilder.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
        } else {
            stringBuilder.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
        }
        if (option.hasArg() && (option.getArgName() == null || !option.getArgName().isEmpty())) {
            stringBuilder.append(option.getOpt() == null ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
            stringBuilder.append("<").append(option.getArgName() != null ? option.getArgName() : this.getArgName()).append(">");
        }
        if (!bl2) {
            stringBuilder.append("]");
        }
    }

    private void appendOptionGroup(StringBuilder stringBuilder, OptionGroup optionGroup) {
        if (!optionGroup.isRequired()) {
            stringBuilder.append("[");
        }
        Object object = new ArrayList<Option>(optionGroup.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(object, this.getOptionComparator());
        }
        object = object.iterator();
        while (object.hasNext()) {
            this.appendOption(stringBuilder, (Option)object.next(), true);
            if (!object.hasNext()) continue;
            stringBuilder.append(" | ");
        }
        if (!optionGroup.isRequired()) {
            stringBuilder.append("]");
        }
    }

    <A extends Appendable> A appendOptions(A a2, int n2, Options object, int n3, int n4) throws IOException {
        Object object2;
        Object object3;
        Serializable serializable;
        String string = this.createPadding(n3);
        String string2 = this.createPadding(n4);
        int n5 = 0;
        int n6 = this.showSince ? this.determineMaxSinceLength((Options)object) + n3 : 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = ((Options)object).helpOptions();
        if (this.getOptionComparator() != null) {
            Collections.sort(object, this.getOptionComparator());
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            serializable = (Option)iterator.next();
            object3 = new StringBuilder();
            if (((Option)serializable).getOpt() == null) {
                ((StringBuilder)object3).append(string).append("   ").append(this.getLongOptPrefix()).append(((Option)serializable).getLongOpt());
            } else {
                ((StringBuilder)object3).append(string).append(this.getOptPrefix()).append(((Option)serializable).getOpt());
                if (((Option)serializable).hasLongOpt()) {
                    ((StringBuilder)object3).append(',').append(this.getLongOptPrefix()).append(((Option)serializable).getLongOpt());
                }
            }
            if (((Option)serializable).hasArg()) {
                object2 = ((Option)serializable).getArgName();
                if (object2 != null && ((String)object2).isEmpty()) {
                    ((StringBuilder)object3).append(' ');
                } else {
                    ((StringBuilder)object3).append(((Option)serializable).hasLongOpt() ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
                    ((StringBuilder)object3).append("<").append(object2 != null ? ((Option)serializable).getArgName() : this.getArgName()).append(">");
                }
            }
            arrayList.add(object3);
            n5 = Math.max(((StringBuilder)object3).length() + n6, n5);
        }
        int n7 = n5 + n4;
        if (this.showSince) {
            serializable = new StringBuilder(HEADER_OPTIONS).append(this.createPadding(n5 - n6 - 7 + n3)).append(HEADER_SINCE);
            ((StringBuilder)serializable).append(this.createPadding(n5 - ((StringBuilder)serializable).length())).append(string).append(HEADER_DESCRIPTION);
            this.appendWrappedText(a2, n2, n7, ((StringBuilder)serializable).toString());
            a2.append(this.getNewLine());
        }
        int n8 = 0;
        object3 = object.iterator();
        while (object3.hasNext()) {
            object2 = (Option)object3.next();
            if (((StringBuilder)(object = new StringBuilder(((StringBuilder)arrayList.get(n8++)).toString()))).length() < n5) {
                ((StringBuilder)object).append(this.createPadding(n5 - n6 - ((StringBuilder)object).length()));
                if (this.showSince) {
                    ((StringBuilder)object).append(string).append(((Option)object2).getSince() == null ? DEFAULT_OPT_PREFIX : ((Option)object2).getSince());
                }
                ((StringBuilder)object).append(this.createPadding(n5 - ((StringBuilder)object).length()));
            }
            ((StringBuilder)object).append(string2);
            if (this.deprecatedFormatFunction != null && ((Option)object2).isDeprecated()) {
                ((StringBuilder)object).append(this.deprecatedFormatFunction.apply((Option)object2).trim());
            } else if (((Option)object2).getDescription() != null) {
                ((StringBuilder)object).append(((Option)object2).getDescription());
            }
            this.appendWrappedText(a2, n2, n7, ((StringBuilder)object).toString());
            if (!object3.hasNext()) continue;
            a2.append(this.getNewLine());
        }
        return a2;
    }

    <A extends Appendable> A appendWrappedText(A a2, int n2, int n3, String string) throws IOException {
        if (n2 <= 0) {
            return a2;
        }
        int n4 = this.findWrapPos(string, n2, 0);
        if (n4 == -1) {
            a2.append(this.rtrim(string));
            return a2;
        }
        a2.append(this.rtrim(string.substring(0, n4))).append(this.getNewLine());
        if (n3 >= n2) {
            n3 = 1;
        }
        String string2 = this.createPadding(n3);
        while (true) {
            if ((n4 = this.findWrapPos(string = string2 + string.substring(n4).trim(), n2, 0)) == -1) {
                a2.append(string);
                return a2;
            }
            if (string.length() > n2 && n4 == n3 - 1) {
                n4 = n2;
            }
            a2.append(this.rtrim(string.substring(0, n4))).append(this.getNewLine());
        }
    }

    protected String createPadding(int n2) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private int determineMaxSinceLength(Options options) {
        int n2 = 5;
        int n3 = options.getOptions().stream().map(option -> option.getSince() == null ? n2 : option.getSince().length()).max(Integer::compareTo).orElse(n2);
        if (n3 < n2) {
            return n2;
        }
        return n3;
    }

    protected int findWrapPos(String string, int n2, int n3) {
        char c2;
        int n4 = string.indexOf(10, n3);
        if (n4 != -1 && n4 <= n2) {
            return n4 + 1;
        }
        n4 = string.indexOf(9, n3);
        if (n4 != -1 && n4 <= n2) {
            return n4 + 1;
        }
        if (n3 + n2 >= string.length()) {
            return -1;
        }
        for (n4 = n3 + n2; n4 >= n3 && (c2 = string.charAt(n4)) != ' ' && c2 != '\n' && c2 != '\r'; --n4) {
        }
        if (n4 > n3) {
            return n4;
        }
        n4 = n3 + n2;
        if (n4 == string.length()) {
            return -1;
        }
        return n4;
    }

    public String getArgName() {
        return this.defaultArgName;
    }

    public int getDescPadding() {
        return this.defaultDescPad;
    }

    public int getLeftPadding() {
        return this.defaultLeftPad;
    }

    public String getLongOptPrefix() {
        return this.defaultLongOptPrefix;
    }

    public String getLongOptSeparator() {
        return this.longOptSeparator;
    }

    public String getNewLine() {
        return this.defaultNewLine;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public String getOptPrefix() {
        return this.defaultOptPrefix;
    }

    public String getSyntaxPrefix() {
        return this.defaultSyntaxPrefix;
    }

    public int getWidth() {
        return this.defaultWidth;
    }

    public void printHelp(int n2, String string, String string2, Options options, String string3) {
        this.printHelp(n2, string, string2, options, string3, false);
    }

    public void printHelp(int n2, String string, String string2, Options options, String string3, boolean bl2) {
        PrintWriter printWriter = new PrintWriter(this.printWriter);
        this.printHelp(printWriter, n2, string, string2, options, this.getLeftPadding(), this.getDescPadding(), string3, bl2);
        printWriter.flush();
    }

    public void printHelp(PrintWriter printWriter, int n2, String string, String string2, Options options, int n3, int n4, String string3) {
        this.printHelp(printWriter, n2, string, string2, options, n3, n4, string3, false);
    }

    public void printHelp(PrintWriter printWriter, int n2, String string, String string2, Options options, int n3, int n4, String string3, boolean bl2) {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (bl2) {
            this.printUsage(printWriter, n2, string, options);
        } else {
            this.printUsage(printWriter, n2, string);
        }
        if (string2 != null && !string2.isEmpty()) {
            this.printWrapped(printWriter, n2, string2);
        }
        this.printOptions(printWriter, n2, options, n3, n4);
        if (string3 != null && !string3.isEmpty()) {
            this.printWrapped(printWriter, n2, string3);
        }
    }

    public void printHelp(String string, Options options) {
        HelpFormatter helpFormatter = this;
        helpFormatter.printHelp(helpFormatter.getWidth(), string, null, options, null, false);
    }

    public void printHelp(String string, Options options, boolean bl2) {
        HelpFormatter helpFormatter = this;
        helpFormatter.printHelp(helpFormatter.getWidth(), string, null, options, null, bl2);
    }

    public void printHelp(String string, String string2, Options options, String string3) {
        this.printHelp(string, string2, options, string3, false);
    }

    public void printHelp(String string, String string2, Options options, String string3, boolean bl2) {
        HelpFormatter helpFormatter = this;
        helpFormatter.printHelp(helpFormatter.getWidth(), string, string2, options, string3, bl2);
    }

    public void printOptions(PrintWriter printWriter, int n2, Options options, int n3, int n4) {
        try {
            printWriter.println(this.appendOptions(new StringBuilder(), n2, options, n3, n4));
            return;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public void printUsage(PrintWriter printWriter, int n2, String string) {
        int n3 = string.indexOf(32) + 1;
        this.printWrapped(printWriter, n2, this.getSyntaxPrefix().length() + n3, this.getSyntaxPrefix() + string);
    }

    public void printUsage(PrintWriter printWriter, int n2, String charSequence, Options options) {
        charSequence = new StringBuilder(this.getSyntaxPrefix()).append((String)charSequence).append(' ');
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>();
        Object object = new ArrayList<Option>(options.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(object, this.getOptionComparator());
        }
        object = object.iterator();
        while (object.hasNext()) {
            Option option = (Option)object.next();
            OptionGroup optionGroup = options.getOptionGroup(option);
            if (optionGroup != null) {
                if (!arrayList.contains(optionGroup)) {
                    arrayList.add(optionGroup);
                    this.appendOptionGroup((StringBuilder)charSequence, optionGroup);
                }
            } else {
                Option option2 = option;
                this.appendOption((StringBuilder)charSequence, option2, option2.isRequired());
            }
            if (!object.hasNext()) continue;
            ((StringBuilder)charSequence).append(' ');
        }
        this.printWrapped(printWriter, n2, ((StringBuilder)charSequence).toString().indexOf(32) + 1, ((StringBuilder)charSequence).toString());
    }

    public void printWrapped(PrintWriter printWriter, int n2, int n3, String string) {
        printWriter.println(this.renderWrappedTextBlock(new StringBuilder(string.length()), n2, n3, string));
    }

    public void printWrapped(PrintWriter printWriter, int n2, String string) {
        this.printWrapped(printWriter, n2, 0, string);
    }

    protected StringBuffer renderOptions(StringBuffer stringBuffer, int n2, Options options, int n3, int n4) {
        try {
            return this.appendOptions(stringBuffer, n2, options, n3, n4);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    protected StringBuffer renderWrappedText(StringBuffer stringBuffer, int n2, int n3, String string) {
        try {
            return this.appendWrappedText(stringBuffer, n2, n3, string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private <A extends Appendable> A renderWrappedTextBlock(A a2, int n2, int n3, String object) {
        try {
            String string;
            object = new BufferedReader(new StringReader((String)object));
            boolean bl2 = true;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (!bl2) {
                    a2.append(this.getNewLine());
                } else {
                    bl2 = false;
                }
                this.appendWrappedText(a2, n2, n3, string);
            }
        }
        catch (IOException iOException) {}
        return a2;
    }

    protected String rtrim(String string) {
        int n2;
        if (Util.isEmpty(string)) {
            return string;
        }
        for (n2 = string.length(); n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        return string.substring(0, n2);
    }

    public void setArgName(String string) {
        this.defaultArgName = string;
    }

    public void setDescPadding(int n2) {
        this.defaultDescPad = n2;
    }

    public void setLeftPadding(int n2) {
        this.defaultLeftPad = n2;
    }

    public void setLongOptPrefix(String string) {
        this.defaultLongOptPrefix = string;
    }

    public void setLongOptSeparator(String string) {
        this.longOptSeparator = string;
    }

    public void setNewLine(String string) {
        this.defaultNewLine = string;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    public void setOptPrefix(String string) {
        this.defaultOptPrefix = string;
    }

    public void setSyntaxPrefix(String string) {
        this.defaultSyntaxPrefix = string;
    }

    public void setWidth(int n2) {
        this.defaultWidth = n2;
    }

    static /* synthetic */ PrintWriter access$000() {
        return HelpFormatter.createDefaultPrintWriter();
    }

    /* synthetic */ HelpFormatter(Function function, PrintWriter printWriter, boolean bl2, HelpFormatter$1 helpFormatter$1) {
        this(function, printWriter, bl2);
    }
}

