/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.function.Supplier;
import org.apache.commons.cli.Converter;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Option$1;
import org.apache.commons.cli.OptionValidator;

public final class Option$Builder
implements Supplier<Option> {
    private static final Class<String> DEFAULT_TYPE = String.class;
    private int argCount = -1;
    private String argName;
    private Converter<?, ?> converter;
    private DeprecatedAttributes deprecated;
    private String description;
    private String longOption;
    private String option;
    private boolean optionalArg;
    private boolean required;
    private String since;
    private Class<?> type = DEFAULT_TYPE;
    private char valueSeparator;

    private static Class<?> toType(Class<?> clazz) {
        if (clazz != null) {
            return clazz;
        }
        return DEFAULT_TYPE;
    }

    private Option$Builder(String string) throws IllegalArgumentException {
        this.option(string);
    }

    public final Option$Builder argName(String string) {
        this.argName = string;
        return this;
    }

    @Deprecated
    public final Option build() {
        return this.get();
    }

    public final Option$Builder converter(Converter<?, ?> converter) {
        this.converter = converter;
        return this;
    }

    public final Option$Builder deprecated() {
        return this.deprecated(DeprecatedAttributes.DEFAULT);
    }

    public final Option$Builder deprecated(DeprecatedAttributes deprecatedAttributes) {
        this.deprecated = deprecatedAttributes;
        return this;
    }

    public final Option$Builder desc(String string) {
        this.description = string;
        return this;
    }

    @Override
    public final Option get() {
        return new Option(this, null);
    }

    public final Option$Builder hasArg() {
        return this.hasArg(true);
    }

    public final Option$Builder hasArg(boolean bl2) {
        this.argCount = bl2 ? 1 : -1;
        return this;
    }

    public final Option$Builder hasArgs() {
        this.argCount = -2;
        return this;
    }

    public final Option$Builder longOpt(String string) {
        this.longOption = string;
        return this;
    }

    public final Option$Builder numberOfArgs(int n2) {
        this.argCount = n2;
        return this;
    }

    public final Option$Builder option(String string) throws IllegalArgumentException {
        this.option = OptionValidator.validate(string);
        return this;
    }

    public final Option$Builder optionalArg(boolean bl2) {
        if (bl2 && this.argCount == -1) {
            this.argCount = 1;
        }
        this.optionalArg = bl2;
        return this;
    }

    public final Option$Builder required() {
        return this.required(true);
    }

    public final Option$Builder required(boolean bl2) {
        this.required = bl2;
        return this;
    }

    public final Option$Builder since(String string) {
        this.since = string;
        return this;
    }

    public final Option$Builder type(Class<?> clazz) {
        this.type = Option$Builder.toType(clazz);
        return this;
    }

    public final Option$Builder valueSeparator() {
        return this.valueSeparator('=');
    }

    public final Option$Builder valueSeparator(char c2) {
        this.valueSeparator = c2;
        return this;
    }

    /* synthetic */ Option$Builder(String string, Option$1 option$1) throws IllegalArgumentException {
        this(string);
    }

    static /* synthetic */ String access$200(Option$Builder option$Builder) {
        return option$Builder.option;
    }

    static /* synthetic */ String access$300(Option$Builder option$Builder) {
        return option$Builder.longOption;
    }

    static /* synthetic */ String access$400(Option$Builder option$Builder) {
        return option$Builder.argName;
    }

    static /* synthetic */ String access$500(Option$Builder option$Builder) {
        return option$Builder.description;
    }

    static /* synthetic */ int access$600(Option$Builder option$Builder) {
        return option$Builder.argCount;
    }

    static /* synthetic */ boolean access$700(Option$Builder option$Builder) {
        return option$Builder.optionalArg;
    }

    static /* synthetic */ DeprecatedAttributes access$800(Option$Builder option$Builder) {
        return option$Builder.deprecated;
    }

    static /* synthetic */ boolean access$900(Option$Builder option$Builder) {
        return option$Builder.required;
    }

    static /* synthetic */ String access$1000(Option$Builder option$Builder) {
        return option$Builder.since;
    }

    static /* synthetic */ Class access$1100(Option$Builder option$Builder) {
        return option$Builder.type;
    }

    static /* synthetic */ char access$1200(Option$Builder option$Builder) {
        return option$Builder.valueSeparator;
    }

    static /* synthetic */ Converter access$1300(Option$Builder option$Builder) {
        return option$Builder.converter;
    }

    static /* synthetic */ Class access$1400(Class clazz) {
        return Option$Builder.toType(clazz);
    }
}

