/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Util;

public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Option> shortOpts = new LinkedHashMap<String, Option>();
    private final Map<String, Option> longOpts = new LinkedHashMap<String, Option>();
    private final List<Object> requiredOpts = new ArrayList<Object>();
    private final Map<String, OptionGroup> optionGroups = new LinkedHashMap<String, OptionGroup>();

    public Options addOption(Option option) {
        String string = option.getKey();
        if (option.hasLongOpt()) {
            this.longOpts.put(option.getLongOpt(), option);
        }
        if (option.isRequired()) {
            if (this.requiredOpts.contains(string)) {
                this.requiredOpts.remove(this.requiredOpts.indexOf(string));
            }
            this.requiredOpts.add(string);
        }
        this.shortOpts.put(string, option);
        return this;
    }

    public Options addOption(String string, boolean bl2, String string2) {
        this.addOption(string, null, bl2, string2);
        return this;
    }

    public Options addOption(String string, String string2) {
        this.addOption(string, null, false, string2);
        return this;
    }

    public Options addOption(String string, String string2, boolean bl2, String string3) {
        this.addOption(new Option(string, string2, bl2, string3));
        return this;
    }

    public Options addOptionGroup(OptionGroup optionGroup) {
        if (optionGroup.isRequired()) {
            this.requiredOpts.add(optionGroup);
        }
        for (Option option : optionGroup.getOptions()) {
            option.setRequired(false);
            String string = option.getKey();
            this.requiredOpts.remove(string);
            this.addOption(option);
            this.optionGroups.put(string, optionGroup);
        }
        return this;
    }

    public Options addOptions(Options options) {
        for (Option option : options.getOptions()) {
            if (this.hasOption(option.getKey())) {
                throw new IllegalArgumentException("Duplicate key: " + option.getKey());
            }
            this.addOption(option);
        }
        options.getOptionGroups().forEach(this::addOptionGroup);
        return this;
    }

    public Options addRequiredOption(String object, String string, boolean bl2, String string2) {
        object = new Option((String)object, string, bl2, string2);
        ((Option)object).setRequired(true);
        this.addOption((Option)object);
        return this;
    }

    public List<String> getMatchingOptions(String string) {
        string = Util.stripLeadingHyphens(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.longOpts.containsKey(string)) {
            return Collections.singletonList(string);
        }
        for (String string2 : this.longOpts.keySet()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Option getOption(String string) {
        Option option = this.shortOpts.get(string = Util.stripLeadingHyphens(string));
        if (option != null) {
            return option;
        }
        return this.longOpts.get(string);
    }

    public OptionGroup getOptionGroup(Option option) {
        return this.optionGroups.get(option.getKey());
    }

    Collection<OptionGroup> getOptionGroups() {
        return new HashSet<OptionGroup>(this.optionGroups.values());
    }

    public Collection<Option> getOptions() {
        return Collections.unmodifiableCollection(this.helpOptions());
    }

    public List<?> getRequiredOptions() {
        return Collections.unmodifiableList(this.requiredOpts);
    }

    public boolean hasLongOption(String string) {
        return this.longOpts.containsKey(Util.stripLeadingHyphens(string));
    }

    public boolean hasOption(String string) {
        return this.shortOpts.containsKey(string = Util.stripLeadingHyphens(string)) || this.longOpts.containsKey(string);
    }

    public boolean hasShortOption(String string) {
        string = Util.stripLeadingHyphens(string);
        return this.shortOpts.containsKey(string);
    }

    List<Option> helpOptions() {
        return new ArrayList<Option>(this.shortOpts.values());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ Options: [ short ");
        stringBuilder.append(this.shortOpts.toString());
        stringBuilder.append(" ] [ long ");
        stringBuilder.append(this.longOpts);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

