/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import org.apache.commons.cli.help.TextStyle$1;
import org.apache.commons.cli.help.TextStyle$Alignment;
import org.apache.commons.cli.help.TextStyle$Builder;
import org.apache.commons.cli.help.Util;

public final class TextStyle {
    public static final int UNSET_MAX_WIDTH = Integer.MAX_VALUE;
    public static final TextStyle DEFAULT = TextStyle.builder().get();
    private final TextStyle$Alignment alignment;
    private final int leftPad;
    private final int indent;
    private final boolean scalable;
    private final int minWidth;
    private final int maxWidth;

    public static TextStyle$Builder builder() {
        return new TextStyle$Builder(null);
    }

    private TextStyle(TextStyle$Builder textStyle$Builder) {
        this.alignment = TextStyle$Builder.access$800(textStyle$Builder);
        this.leftPad = TextStyle$Builder.access$900(textStyle$Builder);
        this.indent = TextStyle$Builder.access$1000(textStyle$Builder);
        this.scalable = TextStyle$Builder.access$1100(textStyle$Builder);
        this.minWidth = TextStyle$Builder.access$1200(textStyle$Builder);
        this.maxWidth = TextStyle$Builder.access$1300(textStyle$Builder);
    }

    public final TextStyle$Alignment getAlignment() {
        return this.alignment;
    }

    public final int getIndent() {
        return this.indent;
    }

    public final int getLeftPad() {
        return this.leftPad;
    }

    public final int getMaxWidth() {
        return this.maxWidth;
    }

    public final int getMinWidth() {
        return this.minWidth;
    }

    public final boolean isScalable() {
        return this.scalable;
    }

    public final CharSequence pad(boolean bl2, CharSequence charSequence) {
        if (charSequence.length() >= this.maxWidth) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.alignment.ordinal()) {
            case 1: {
                int n2 = this.maxWidth == Integer.MAX_VALUE ? (bl2 ? this.indent : 0) : this.maxWidth - charSequence.length();
                int n3 = n2 / 2;
                String string = Util.repeatSpace(n3);
                String string2 = Util.repeatSpace(n2 - n3);
                stringBuilder.append(string).append(charSequence).append(string2);
                break;
            }
            default: {
                String string;
                String string3;
                if (this.maxWidth == Integer.MAX_VALUE) {
                    string3 = bl2 ? Util.repeatSpace(this.indent) : "";
                    string = "";
                } else {
                    int n4 = this.maxWidth - charSequence.length();
                    if (bl2 && n4 > this.indent) {
                        string3 = Util.repeatSpace(this.indent);
                        n4 -= this.indent;
                    } else {
                        string3 = "";
                    }
                    string = Util.repeatSpace(n4);
                }
                if (this.alignment == TextStyle$Alignment.LEFT) {
                    stringBuilder.append(string3).append(charSequence).append(string);
                    break;
                }
                stringBuilder.append(string3).append(string).append(charSequence);
            }
        }
        return stringBuilder.toString();
    }

    public final String toString() {
        return String.format("TextStyle{%s, l:%s, i:%s, %s, min:%s, max:%s}", new Object[]{this.alignment, this.leftPad, this.indent, this.scalable, this.minWidth, this.maxWidth == Integer.MAX_VALUE ? "unset" : Integer.valueOf(this.maxWidth)});
    }

    /* synthetic */ TextStyle(TextStyle$Builder textStyle$Builder, TextStyle$1 textStyle$1) {
        this(textStyle$Builder);
    }

    static /* synthetic */ TextStyle$Alignment access$100(TextStyle textStyle) {
        return textStyle.alignment;
    }

    static /* synthetic */ int access$200(TextStyle textStyle) {
        return textStyle.leftPad;
    }

    static /* synthetic */ int access$300(TextStyle textStyle) {
        return textStyle.indent;
    }

    static /* synthetic */ boolean access$400(TextStyle textStyle) {
        return textStyle.scalable;
    }

    static /* synthetic */ int access$500(TextStyle textStyle) {
        return textStyle.minWidth;
    }

    static /* synthetic */ int access$600(TextStyle textStyle) {
        return textStyle.maxWidth;
    }
}

