/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.Arrays;

final class Util {
    private static final int NOT_FOUND = -1;

    static <T extends CharSequence> T defaultValue(T t2, T t3) {
        if (Util.isEmpty(t2)) {
            return t3;
        }
        return t2;
    }

    static int indexOfNonWhitespace(CharSequence charSequence, int n2) {
        if (Util.isEmpty(charSequence)) {
            return -1;
        }
        while (n2 < charSequence.length() && Util.isWhitespace(charSequence.charAt(n2))) {
            ++n2;
        }
        if (n2 < charSequence.length()) {
            return n2;
        }
        return -1;
    }

    static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    static boolean isWhitespace(char c2) {
        return Character.isWhitespace(c2) || '\u000e' == c2;
    }

    static String ltrim(String string) {
        int n2 = Util.indexOfNonWhitespace(string, 0);
        if (n2 == -1) {
            return "";
        }
        return string.substring(n2);
    }

    static String repeat(int n2, char c2) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c2);
        return new String(cArray);
    }

    static String repeatSpace(int n2) {
        return Util.repeat(n2, ' ');
    }

    static String rtrim(String string) {
        int n2;
        if (Util.isEmpty(string)) {
            return string;
        }
        for (n2 = string.length(); n2 > 0 && Util.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        return string.substring(0, n2);
    }

    private Util() {
    }
}

