/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.util.Objects;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNCodec$Context;

public class Base16
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 4;
    private static final int BYTES_PER_ENCODED_BLOCK = 2;
    private static final int BYTES_PER_UNENCODED_BLOCK = 1;
    private static final byte[] UPPER_CASE_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] UPPER_CASE_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] LOWER_CASE_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] LOWER_CASE_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final int MASK_4_BITS = 15;
    private final byte[] decodeTable;
    private final byte[] encodeTable;

    public Base16() {
        this(false);
    }

    public Base16(boolean bl2) {
        this(bl2, DECODING_POLICY_DEFAULT);
    }

    private Base16(byte[] byArray, CodecPolicy codecPolicy) {
        super(1, 2, 0, 0, (byte)61, codecPolicy);
        Objects.requireNonNull(byArray, "encodeTable");
        this.encodeTable = byArray;
        this.decodeTable = byArray == LOWER_CASE_ENCODE_TABLE ? LOWER_CASE_DECODE_TABLE : UPPER_CASE_DECODE_TABLE;
    }

    public Base16(boolean bl2, CodecPolicy codecPolicy) {
        this(bl2 ? LOWER_CASE_ENCODE_TABLE : UPPER_CASE_ENCODE_TABLE, codecPolicy);
    }

    @Override
    void decode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof || n3 < 0) {
            baseNCodec$Context.eof = true;
            if (baseNCodec$Context.ibitWorkArea != 0) {
                this.validateTrailingCharacter();
            }
            return;
        }
        int n4 = (baseNCodec$Context.ibitWorkArea != 0 ? 1 : 0) + (n3 = Math.min(byArray.length - n2, n3));
        if (n4 == 1 && n4 == n3) {
            baseNCodec$Context.ibitWorkArea = this.decodeOctet(byArray[n2]) + 1;
            return;
        }
        int n5 = n4 % 2 == 0 ? n4 : n4 - 1;
        int n6 = n2 + n3;
        byte[] byArray2 = this.ensureBufferSize(n5 / 2, baseNCodec$Context);
        if (n3 < n4) {
            n3 = baseNCodec$Context.ibitWorkArea - 1 << 4;
            byArray2[baseNCodec$Context.pos++] = (byte)(n3 |= this.decodeOctet(byArray[n2++]));
            baseNCodec$Context.ibitWorkArea = 0;
        }
        n4 = n6 - 1;
        while (n2 < n4) {
            n3 = this.decodeOctet(byArray[n2++]) << 4;
            byArray2[baseNCodec$Context.pos++] = (byte)(n3 |= this.decodeOctet(byArray[n2++]));
        }
        if (n2 < n6) {
            baseNCodec$Context.ibitWorkArea = this.decodeOctet(byArray[n2]) + 1;
        }
    }

    private int decodeOctet(byte by2) {
        int n2 = -1;
        if ((by2 & 0xFF) < this.decodeTable.length) {
            n2 = this.decodeTable[by2];
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid octet in encoded value: " + by2);
        }
        return n2;
    }

    @Override
    void encode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof) {
            return;
        }
        if (n3 < 0) {
            baseNCodec$Context.eof = true;
            return;
        }
        int n4 = n3 << 1;
        if (n4 < 0) {
            throw new IllegalArgumentException("Input length exceeds maximum size for encoded data: " + n3);
        }
        byte[] byArray2 = this.ensureBufferSize(n4, baseNCodec$Context);
        n3 = n2 + n3;
        while (n2 < n3) {
            int n5 = byArray[n2];
            int n6 = n5 >> 4 & 0xF;
            byArray2[baseNCodec$Context.pos++] = this.encodeTable[n6];
            byArray2[baseNCodec$Context.pos++] = this.encodeTable[n5 &= 0xF];
            ++n2;
        }
    }

    @Override
    public boolean isInAlphabet(byte by2) {
        return (by2 & 0xFF) < this.decodeTable.length && this.decodeTable[by2] != -1;
    }

    private void validateTrailingCharacter() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character is a valid base 16 alphabet character but not a possible encoding. Decoding requires at least two characters to create one byte.");
        }
    }
}

