/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.util.Objects;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base32$1;
import org.apache.commons.codec.binary.Base32$Builder;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNCodec$Context;
import org.apache.commons.codec.binary.StringUtils;

public class Base32
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 5;
    private static final int BYTES_PER_ENCODED_BLOCK = 8;
    private static final int BYTES_PER_UNENCODED_BLOCK = 5;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final byte[] ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private static final byte[] HEX_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final byte[] HEX_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86};
    private static final int MASK_5_BITS = 31;
    private static final long MASK_4_BITS = 15L;
    private static final long MASK_3_BITS = 7L;
    private static final long MASK_2_BITS = 3L;
    private static final long MASK_1_BITS = 1L;
    private final byte[] decodeTable;
    private final int encodeSize;
    private final byte[] encodeTable;
    private final byte[] lineSeparator;

    public static Base32$Builder builder() {
        return new Base32$Builder();
    }

    private static byte[] decodeTable(boolean bl2) {
        if (bl2) {
            return HEX_DECODE_TABLE;
        }
        return DECODE_TABLE;
    }

    private static byte[] encodeTable(boolean bl2) {
        if (bl2) {
            return HEX_ENCODE_TABLE;
        }
        return ENCODE_TABLE;
    }

    public Base32() {
        this(false);
    }

    public Base32(boolean bl2) {
        this(0, null, bl2, 61);
    }

    public Base32(boolean bl2, byte by2) {
        this(0, null, bl2, by2);
    }

    public Base32(byte by2) {
        this(false, by2);
    }

    public Base32(int n2) {
        this(n2, CHUNK_SEPARATOR);
    }

    public Base32(int n2, byte[] byArray) {
        this(n2, byArray, false, 61);
    }

    public Base32(int n2, byte[] byArray, boolean bl2) {
        this(n2, byArray, bl2, 61);
    }

    public Base32(int n2, byte[] byArray, boolean bl2, byte by2) {
        this(n2, byArray, bl2, by2, DECODING_POLICY_DEFAULT);
    }

    public Base32(int n2, byte[] byArray, boolean bl2, byte by2, CodecPolicy codecPolicy) {
        this(n2, byArray, Base32.encodeTable(bl2), by2, codecPolicy);
    }

    private Base32(int n2, byte[] byArray, byte[] byArray2, byte by2, CodecPolicy codecPolicy) {
        super(5, 8, n2, Base32.toLength(byArray), by2, codecPolicy);
        Objects.requireNonNull(byArray2, "encodeTable");
        this.encodeTable = byArray2;
        byte[] byArray3 = this.decodeTable = byArray2 == HEX_ENCODE_TABLE ? HEX_DECODE_TABLE : DECODE_TABLE;
        if (n2 > 0) {
            if (byArray == null) {
                throw new IllegalArgumentException("lineLength " + n2 + " > 0, but lineSeparator is null");
            }
            Object object = (byte[])byArray.clone();
            if (this.containsAlphabetOrPad((byte[])object)) {
                object = StringUtils.newStringUtf8(object);
                throw new IllegalArgumentException("lineSeparator must not contain Base32 characters: [" + (String)object + "]");
            }
            this.encodeSize = 8 + ((byte[])object).length;
            this.lineSeparator = object;
        } else {
            this.encodeSize = 8;
            this.lineSeparator = null;
        }
        if (this.isInAlphabet(by2) || Character.isWhitespace(by2)) {
            throw new IllegalArgumentException("pad must not be in alphabet or whitespace");
        }
    }

    @Override
    void decode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof) {
            return;
        }
        if (n3 < 0) {
            baseNCodec$Context.eof = true;
        }
        int n4 = this.encodeSize - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2;
            if ((by2 = byArray[n2++]) == this.pad) {
                baseNCodec$Context.eof = true;
                break;
            }
            byte[] byArray2 = this.ensureBufferSize(n4, baseNCodec$Context);
            if (by2 < 0 || by2 >= this.decodeTable.length || (by2 = this.decodeTable[by2]) < 0) continue;
            baseNCodec$Context.modulus = (baseNCodec$Context.modulus + 1) % 8;
            baseNCodec$Context.lbitWorkArea = (baseNCodec$Context.lbitWorkArea << 5) + (long)by2;
            if (baseNCodec$Context.modulus != 0) continue;
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 32 & 0xFFL);
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 24 & 0xFFL);
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 16 & 0xFFL);
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 8 & 0xFFL);
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea & 0xFFL);
        }
        if (baseNCodec$Context.eof && baseNCodec$Context.modulus > 0) {
            byte[] byArray3 = this.ensureBufferSize(n4, baseNCodec$Context);
            switch (baseNCodec$Context.modulus) {
                case 1: {
                    this.validateTrailingCharacters();
                }
                case 2: {
                    this.validateCharacter(3L, baseNCodec$Context);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 2 & 0xFFL);
                    return;
                }
                case 3: {
                    this.validateTrailingCharacters();
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 7 & 0xFFL);
                    return;
                }
                case 4: {
                    this.validateCharacter(15L, baseNCodec$Context);
                    baseNCodec$Context.lbitWorkArea >>= 4;
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea & 0xFFL);
                    return;
                }
                case 5: {
                    this.validateCharacter(1L, baseNCodec$Context);
                    baseNCodec$Context.lbitWorkArea >>= 1;
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea & 0xFFL);
                    return;
                }
                case 6: {
                    this.validateTrailingCharacters();
                    baseNCodec$Context.lbitWorkArea >>= 6;
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea & 0xFFL);
                    return;
                }
                case 7: {
                    this.validateCharacter(7L, baseNCodec$Context);
                    baseNCodec$Context.lbitWorkArea >>= 3;
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 24 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.lbitWorkArea & 0xFFL);
                    return;
                }
            }
            throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.modulus);
        }
    }

    @Override
    void encode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof) {
            return;
        }
        if (n3 < 0) {
            baseNCodec$Context.eof = true;
            if (baseNCodec$Context.modulus == 0 && this.lineLength == 0) {
                return;
            }
            Base32 base32 = this;
            byte[] byArray2 = base32.ensureBufferSize(base32.encodeSize, baseNCodec$Context);
            int n4 = baseNCodec$Context.pos;
            switch (baseNCodec$Context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 3) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea << 2) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 11) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 6) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 1) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea << 4) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                case 3: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 19) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 14) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 9) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 4) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea << 1) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                case 4: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 27) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 22) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 17) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 12) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 7) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 2) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea << 3) & 0x1F];
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.modulus);
                }
            }
            baseNCodec$Context.currentLinePos += baseNCodec$Context.pos - n4;
            if (this.lineLength > 0 && baseNCodec$Context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, byArray2, baseNCodec$Context.pos, this.lineSeparator.length);
                baseNCodec$Context.pos += this.lineSeparator.length;
            }
            return;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            Base32 base32 = this;
            byte[] byArray3 = base32.ensureBufferSize(base32.encodeSize, baseNCodec$Context);
            baseNCodec$Context.modulus = (baseNCodec$Context.modulus + 1) % 5;
            if ((n5 = byArray[n2++]) < 0) {
                n5 += 256;
            }
            baseNCodec$Context.lbitWorkArea = (baseNCodec$Context.lbitWorkArea << 8) + (long)n5;
            if (baseNCodec$Context.modulus != 0) continue;
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 35) & 0x1F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 30) & 0x1F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 25) & 0x1F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 20) & 0x1F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 15) & 0x1F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 10) & 0x1F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)(baseNCodec$Context.lbitWorkArea >> 5) & 0x1F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[(int)baseNCodec$Context.lbitWorkArea & 0x1F];
            baseNCodec$Context.currentLinePos += 8;
            if (this.lineLength <= 0 || this.lineLength > baseNCodec$Context.currentLinePos) continue;
            System.arraycopy(this.lineSeparator, 0, byArray3, baseNCodec$Context.pos, this.lineSeparator.length);
            baseNCodec$Context.pos += this.lineSeparator.length;
            baseNCodec$Context.currentLinePos = 0;
        }
    }

    byte[] getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public boolean isInAlphabet(byte by2) {
        return by2 >= 0 && by2 < this.decodeTable.length && this.decodeTable[by2] != -1;
    }

    private void validateCharacter(long l2, BaseNCodec$Context baseNCodec$Context) {
        if (this.isStrictDecoding() && (baseNCodec$Context.lbitWorkArea & l2) != 0L) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 32 alphabet but not a possible encoding. Expected the discarded bits from the character to be zero.");
        }
    }

    private void validateTrailingCharacters() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character(s) (before the paddings if any) are valid base 32 alphabet but not a possible encoding. Decoding requires either 2, 4, 5, or 7 trailing 5-bit characters to create bytes.");
        }
    }

    static /* synthetic */ byte[] access$000() {
        return ENCODE_TABLE;
    }

    /* synthetic */ Base32(int n2, byte[] byArray, byte[] byArray2, byte by2, CodecPolicy codecPolicy, Base32$1 base32$1) {
        this(n2, byArray, byArray2, by2, codecPolicy);
    }

    static /* synthetic */ byte[] access$200(boolean bl2) {
        return Base32.decodeTable(bl2);
    }

    static /* synthetic */ byte[] access$300(boolean bl2) {
        return Base32.encodeTable(bl2);
    }
}

