/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base64$1;
import org.apache.commons.codec.binary.Base64$Builder;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNCodec$Context;
import org.apache.commons.codec.binary.BinaryCodec;
import org.apache.commons.codec.binary.StringUtils;

public class Base64
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final int DECODING_TABLE_LENGTH = 256;
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6_BITS = 63;
    private static final int MASK_4_BITS = 15;
    private static final int MASK_2_BITS = 3;
    private final byte[] encodeTable;
    private final byte[] decodeTable;
    private final byte[] lineSeparator;
    private final int encodeSize;
    private final boolean isUrlSafe;

    public static Base64$Builder builder() {
        return new Base64$Builder();
    }

    public static byte[] decodeBase64(byte[] byArray) {
        return new Base64().decode(byArray);
    }

    public static byte[] decodeBase64(String string) {
        return new Base64().decode(string);
    }

    public static BigInteger decodeInteger(byte[] byArray) {
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2) {
        return Base64.encodeBase64(byArray, bl2, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2, boolean bl3) {
        return Base64.encodeBase64(byArray, bl2, bl3, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2, boolean bl3, int n2) {
        if (BinaryCodec.isEmpty(byArray)) {
            return byArray;
        }
        Base64 base64 = bl2 ? new Base64(bl3) : new Base64(0, CHUNK_SEPARATOR, bl3);
        long l2 = base64.getEncodedLength(byArray);
        if (l2 > (long)n2) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l2 + ") than the specified maximum size of " + n2);
        }
        return base64.encode(byArray);
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public static String encodeBase64String(byte[] byArray) {
        return StringUtils.newStringUsAscii(Base64.encodeBase64(byArray, false));
    }

    public static byte[] encodeBase64URLSafe(byte[] byArray) {
        return Base64.encodeBase64(byArray, false, true);
    }

    public static String encodeBase64URLSafeString(byte[] byArray) {
        return StringUtils.newStringUsAscii(Base64.encodeBase64(byArray, false, true));
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        Objects.requireNonNull(bigInteger, "bigInteger");
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInteger), false);
    }

    @Deprecated
    public static boolean isArrayByteBase64(byte[] byArray) {
        return Base64.isBase64(byArray);
    }

    public static boolean isBase64(byte by2) {
        return by2 == 61 || by2 >= 0 && by2 < DECODE_TABLE.length && DECODE_TABLE[by2] != -1;
    }

    public static boolean isBase64(byte[] byArray) {
        for (byte by2 : byArray) {
            if (Base64.isBase64(by2) || Character.isWhitespace(by2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBase64(String string) {
        return Base64.isBase64(StringUtils.getBytesUtf8(string));
    }

    static byte[] toIntegerBytes(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        n2 = n2 + 7 >> 3 << 3;
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n2 / 8) {
            return byArray;
        }
        int n3 = 0;
        int n4 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n3 = 1;
            --n4;
        }
        int n5 = n2 / 8 - n4;
        byte[] byArray2 = new byte[n2 / 8];
        System.arraycopy(byArray, n3, byArray2, n5, n4);
        return byArray2;
    }

    private static byte[] toUrlSafeEncodeTable(boolean bl2) {
        if (bl2) {
            return URL_SAFE_ENCODE_TABLE;
        }
        return STANDARD_ENCODE_TABLE;
    }

    public Base64() {
        this(0);
    }

    public Base64(boolean bl2) {
        this(76, CHUNK_SEPARATOR, bl2);
    }

    public Base64(int n2) {
        this(n2, CHUNK_SEPARATOR);
    }

    public Base64(int n2, byte[] byArray) {
        this(n2, byArray, false);
    }

    public Base64(int n2, byte[] byArray, boolean bl2) {
        this(n2, byArray, 61, Base64.toUrlSafeEncodeTable(bl2), DECODING_POLICY_DEFAULT);
    }

    public Base64(int n2, byte[] byArray, boolean bl2, CodecPolicy codecPolicy) {
        this(n2, byArray, 61, Base64.toUrlSafeEncodeTable(bl2), codecPolicy);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Base64(int n2, byte[] byArray, byte by2, byte[] byArray2, CodecPolicy codecPolicy) {
        super(3, 4, n2, Base64.toLength(byArray), by2, codecPolicy);
        Objects.requireNonNull(byArray2, "encodeTable");
        if (byArray2.length != STANDARD_ENCODE_TABLE.length) {
            throw new IllegalArgumentException("encodeTable must have exactly 64 entries.");
        }
        boolean bl2 = this.isUrlSafe = byArray2 == URL_SAFE_ENCODE_TABLE || Arrays.equals(byArray2, URL_SAFE_ENCODE_TABLE);
        if (byArray2 == STANDARD_ENCODE_TABLE || this.isUrlSafe) {
            this.decodeTable = DECODE_TABLE;
            this.encodeTable = byArray2;
        } else {
            this.encodeTable = (byte[])byArray2.clone();
            this.decodeTable = this.calculateDecodeTable(this.encodeTable);
        }
        if (byArray == null) {
            this.encodeSize = 4;
            this.lineSeparator = null;
            return;
        }
        if (this.containsAlphabetOrPad(byArray = (byte[])byArray.clone())) {
            String string = StringUtils.newStringUtf8(byArray);
            throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + string + "]");
        }
        if (n2 > 0) {
            this.encodeSize = 4 + byArray.length;
            this.lineSeparator = byArray;
            return;
        }
        this.encodeSize = 4;
        this.lineSeparator = null;
    }

    private byte[] calculateDecodeTable(byte[] byArray) {
        byte[] byArray2 = new byte[256];
        Arrays.fill(byArray2, (byte)-1);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[byArray[i2]] = (byte)i2;
        }
        return byArray2;
    }

    @Override
    void decode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof) {
            return;
        }
        if (n3 < 0) {
            baseNCodec$Context.eof = true;
        }
        int n4 = this.encodeSize - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2;
            byte[] byArray2 = this.ensureBufferSize(n4, baseNCodec$Context);
            if ((by2 = byArray[n2++]) == this.pad) {
                baseNCodec$Context.eof = true;
                break;
            }
            if (by2 < 0 || by2 >= this.decodeTable.length || (by2 = this.decodeTable[by2]) < 0) continue;
            baseNCodec$Context.modulus = (baseNCodec$Context.modulus + 1) % 4;
            baseNCodec$Context.ibitWorkArea = (baseNCodec$Context.ibitWorkArea << 6) + by2;
            if (baseNCodec$Context.modulus != 0) continue;
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.ibitWorkArea >> 16);
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.ibitWorkArea >> 8);
            byArray2[baseNCodec$Context.pos++] = (byte)baseNCodec$Context.ibitWorkArea;
        }
        if (baseNCodec$Context.eof && baseNCodec$Context.modulus != 0) {
            byte[] byArray3 = this.ensureBufferSize(n4, baseNCodec$Context);
            switch (baseNCodec$Context.modulus) {
                case 1: {
                    this.validateTrailingCharacter();
                    return;
                }
                case 2: {
                    this.validateCharacter(15, baseNCodec$Context);
                    baseNCodec$Context.ibitWorkArea >>= 4;
                    byArray3[baseNCodec$Context.pos++] = (byte)baseNCodec$Context.ibitWorkArea;
                    return;
                }
                case 3: {
                    this.validateCharacter(3, baseNCodec$Context);
                    baseNCodec$Context.ibitWorkArea >>= 2;
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.ibitWorkArea >> 8);
                    byArray3[baseNCodec$Context.pos++] = (byte)baseNCodec$Context.ibitWorkArea;
                    return;
                }
            }
            throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.modulus);
        }
    }

    @Override
    void encode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof) {
            return;
        }
        if (n3 < 0) {
            baseNCodec$Context.eof = true;
            if (baseNCodec$Context.modulus == 0 && this.lineLength == 0) {
                return;
            }
            Base64 base64 = this;
            byte[] byArray2 = base64.ensureBufferSize(base64.encodeSize, baseNCodec$Context);
            int n4 = baseNCodec$Context.pos;
            switch (baseNCodec$Context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 2 & 0x3F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea << 4 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 10 & 0x3F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 4 & 0x3F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea << 2 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.modulus);
                }
            }
            baseNCodec$Context.currentLinePos += baseNCodec$Context.pos - n4;
            if (this.lineLength > 0 && baseNCodec$Context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, byArray2, baseNCodec$Context.pos, this.lineSeparator.length);
                baseNCodec$Context.pos += this.lineSeparator.length;
            }
            return;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            Base64 base64 = this;
            byte[] byArray3 = base64.ensureBufferSize(base64.encodeSize, baseNCodec$Context);
            baseNCodec$Context.modulus = (baseNCodec$Context.modulus + 1) % 3;
            if ((n5 = byArray[n2++]) < 0) {
                n5 += 256;
            }
            baseNCodec$Context.ibitWorkArea = (baseNCodec$Context.ibitWorkArea << 8) + n5;
            if (baseNCodec$Context.modulus != 0) continue;
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 18 & 0x3F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 12 & 0x3F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 6 & 0x3F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea & 0x3F];
            baseNCodec$Context.currentLinePos += 4;
            if (this.lineLength <= 0 || this.lineLength > baseNCodec$Context.currentLinePos) continue;
            System.arraycopy(this.lineSeparator, 0, byArray3, baseNCodec$Context.pos, this.lineSeparator.length);
            baseNCodec$Context.pos += this.lineSeparator.length;
            baseNCodec$Context.currentLinePos = 0;
        }
    }

    byte[] getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    protected boolean isInAlphabet(byte by2) {
        return by2 >= 0 && by2 < this.decodeTable.length && this.decodeTable[by2] != -1;
    }

    public boolean isUrlSafe() {
        return this.isUrlSafe;
    }

    private void validateCharacter(int n2, BaseNCodec$Context baseNCodec$Context) {
        if (this.isStrictDecoding() && (baseNCodec$Context.ibitWorkArea & n2) != 0) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Expected the discarded bits from the character to be zero.");
        }
    }

    private void validateTrailingCharacter() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Decoding requires at least two trailing 6-bit characters to create bytes.");
        }
    }

    static /* synthetic */ byte[] access$000() {
        return STANDARD_ENCODE_TABLE;
    }

    /* synthetic */ Base64(int n2, byte[] byArray, byte by2, byte[] byArray2, CodecPolicy codecPolicy, Base64$1 base64$1) {
        this(n2, byArray, by2, byArray2, codecPolicy);
    }

    static /* synthetic */ byte[] access$200(boolean bl2) {
        return Base64.toUrlSafeEncodeTable(bl2);
    }
}

