/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNCodec$Context;

public class BaseNCodecOutputStream
extends FilterOutputStream {
    private final boolean doEncode;
    private final BaseNCodec baseNCodec;
    private final byte[] singleByte = new byte[1];
    private final BaseNCodec$Context context = new BaseNCodec$Context();

    public BaseNCodecOutputStream(OutputStream outputStream, BaseNCodec baseNCodec, boolean bl2) {
        super(outputStream);
        this.baseNCodec = baseNCodec;
        this.doEncode = bl2;
    }

    @Override
    public void close() throws IOException {
        this.eof();
        this.flush();
        this.out.close();
    }

    public void eof() {
        if (this.doEncode) {
            this.baseNCodec.encode(this.singleByte, 0, -1, this.context);
            return;
        }
        this.baseNCodec.decode(this.singleByte, 0, -1, this.context);
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    private void flush(boolean bl2) throws IOException {
        byte[] byArray;
        int n2 = this.baseNCodec.available(this.context);
        if (n2 > 0 && (n2 = this.baseNCodec.readResults(byArray = new byte[n2], 0, n2, this.context)) > 0) {
            this.out.write(byArray, 0, n2);
        }
        if (bl2) {
            this.out.flush();
        }
    }

    public boolean isStrictDecoding() {
        return this.baseNCodec.isStrictDecoding();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Objects.requireNonNull(byArray, "array");
        if (n2 < 0 || n3 < 0 || n2 > byArray.length || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 > 0) {
            if (this.doEncode) {
                this.baseNCodec.encode(byArray, n2, n3, this.context);
            } else {
                this.baseNCodec.decode(byArray, n2, n3, this.context);
            }
            this.flush(false);
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.singleByte[0] = (byte)n2;
        BaseNCodecOutputStream baseNCodecOutputStream = this;
        baseNCodecOutputStream.write(baseNCodecOutputStream.singleByte, 0, 1);
    }
}

