/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class BinaryCodec
implements BinaryDecoder,
BinaryEncoder {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int BIT_0 = 1;
    private static final int BIT_1 = 2;
    private static final int BIT_2 = 4;
    private static final int BIT_3 = 8;
    private static final int BIT_4 = 16;
    private static final int BIT_5 = 32;
    private static final int BIT_6 = 64;
    private static final int BIT_7 = 128;
    private static final int[] BITS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    public static byte[] fromAscii(byte[] byArray) {
        if (BinaryCodec.isEmpty(byArray)) {
            return EMPTY_BYTE_ARRAY;
        }
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 >> 3];
        int n3 = 0;
        --n2;
        while (n3 < byArray2.length) {
            for (int i2 = 0; i2 < BITS.length; ++i2) {
                if (byArray[n2 - i2] != 49) continue;
                int n4 = n3;
                byArray2[n4] = (byte)(byArray2[n4] | BITS[i2]);
            }
            ++n3;
            n2 -= 8;
        }
        return byArray2;
    }

    public static byte[] fromAscii(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int n2 = cArray.length;
        byte[] byArray = new byte[n2 >> 3];
        int n3 = 0;
        --n2;
        while (n3 < byArray.length) {
            for (int i2 = 0; i2 < BITS.length; ++i2) {
                if (cArray[n2 - i2] != '1') continue;
                int n4 = n3;
                byArray[n4] = (byte)(byArray[n4] | BITS[i2]);
            }
            ++n3;
            n2 -= 8;
        }
        return byArray;
    }

    static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    public static byte[] toAsciiBytes(byte[] byArray) {
        if (BinaryCodec.isEmpty(byArray)) {
            return EMPTY_BYTE_ARRAY;
        }
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 << 3];
        int n3 = 0;
        int n4 = byArray2.length - 1;
        while (n3 < n2) {
            for (int i2 = 0; i2 < BITS.length; ++i2) {
                byArray2[n4 - i2] = (byArray[n3] & BITS[i2]) == 0 ? 48 : 49;
            }
            ++n3;
            n4 -= 8;
        }
        return byArray2;
    }

    public static char[] toAsciiChars(byte[] byArray) {
        if (BinaryCodec.isEmpty(byArray)) {
            return EMPTY_CHAR_ARRAY;
        }
        int n2 = byArray.length;
        char[] cArray = new char[n2 << 3];
        int n3 = 0;
        int n4 = cArray.length - 1;
        while (n3 < n2) {
            for (int i2 = 0; i2 < BITS.length; ++i2) {
                cArray[n4 - i2] = (byArray[n3] & BITS[i2]) == 0 ? 48 : 49;
            }
            ++n3;
            n4 -= 8;
        }
        return cArray;
    }

    public static String toAsciiString(byte[] byArray) {
        return new String(BinaryCodec.toAsciiChars(byArray));
    }

    @Override
    public byte[] decode(byte[] byArray) {
        return BinaryCodec.fromAscii(byArray);
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return EMPTY_BYTE_ARRAY;
        }
        if (object instanceof byte[]) {
            return BinaryCodec.fromAscii((byte[])object);
        }
        if (object instanceof char[]) {
            return BinaryCodec.fromAscii((char[])object);
        }
        if (object instanceof String) {
            return BinaryCodec.fromAscii(((String)object).toCharArray());
        }
        throw new DecoderException("argument not a byte array");
    }

    @Override
    public byte[] encode(byte[] byArray) {
        return BinaryCodec.toAsciiBytes(byArray);
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof byte[])) {
            throw new EncoderException("argument not a byte array");
        }
        return BinaryCodec.toAsciiChars((byte[])object);
    }

    public byte[] toByteArray(String string) {
        if (string == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return BinaryCodec.fromAscii(string.toCharArray());
    }
}

