/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryDecoder,
BinaryEncoder {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_CHARSET_NAME = CharEncoding.UTF_8;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;

    public static byte[] decodeHex(char[] cArray) throws DecoderException {
        byte[] byArray = new byte[cArray.length >> 1];
        Hex.decodeHex(cArray, byArray, 0);
        return byArray;
    }

    public static int decodeHex(char[] cArray, byte[] byArray, int n2) throws DecoderException {
        int n3 = cArray.length;
        if ((n3 & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        int n4 = n3 >> 1;
        if (byArray.length - n2 < n4) {
            throw new DecoderException("Output array is not large enough to accommodate decoded data.");
        }
        int n5 = 0;
        while (n5 < n3) {
            int n6 = Hex.toDigit(cArray[n5], n5) << 4;
            n6 |= Hex.toDigit(cArray[++n5], n5);
            ++n5;
            byArray[n2] = (byte)n6;
            ++n2;
        }
        return n4;
    }

    public static byte[] decodeHex(String string) throws DecoderException {
        return Hex.decodeHex(string.toCharArray());
    }

    public static char[] encodeHex(byte[] byArray) {
        return Hex.encodeHex(byArray, true);
    }

    public static char[] encodeHex(byte[] byArray, boolean bl2) {
        return Hex.encodeHex(byArray, Hex.toAlphabet(bl2));
    }

    protected static char[] encodeHex(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        return Hex.encodeHex(byArray, 0, n2, cArray, new char[n2 << 1], 0);
    }

    public static char[] encodeHex(byte[] byArray, int n2, int n3, boolean bl2) {
        return Hex.encodeHex(byArray, n2, n3, Hex.toAlphabet(bl2), new char[n3 << 1], 0);
    }

    public static void encodeHex(byte[] byArray, int n2, int n3, boolean bl2, char[] cArray, int n4) {
        Hex.encodeHex(byArray, n2, n3, Hex.toAlphabet(bl2), cArray, n4);
    }

    private static char[] encodeHex(byte[] byArray, int n2, int n3, char[] cArray, char[] cArray2, int n4) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            cArray2[n4++] = cArray[(0xF0 & byArray[i2]) >>> 4];
            cArray2[n4++] = cArray[0xF & byArray[i2]];
        }
        return cArray2;
    }

    public static char[] encodeHex(ByteBuffer byteBuffer) {
        return Hex.encodeHex(byteBuffer, true);
    }

    public static char[] encodeHex(ByteBuffer byteBuffer, boolean bl2) {
        return Hex.encodeHex(byteBuffer, Hex.toAlphabet(bl2));
    }

    protected static char[] encodeHex(ByteBuffer byteBuffer, char[] cArray) {
        return Hex.encodeHex(Hex.toByteArray(byteBuffer), cArray);
    }

    public static String encodeHexString(byte[] byArray) {
        return new String(Hex.encodeHex(byArray));
    }

    public static String encodeHexString(byte[] byArray, boolean bl2) {
        return new String(Hex.encodeHex(byArray, bl2));
    }

    public static String encodeHexString(ByteBuffer byteBuffer) {
        return new String(Hex.encodeHex(byteBuffer));
    }

    public static String encodeHexString(ByteBuffer byteBuffer, boolean bl2) {
        return new String(Hex.encodeHex(byteBuffer, bl2));
    }

    private static char[] toAlphabet(boolean bl2) {
        if (bl2) {
            return DIGITS_LOWER;
        }
        return DIGITS_UPPER;
    }

    private static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] byArray;
        int n2 = byteBuffer.remaining();
        if (byteBuffer.hasArray() && n2 == (byArray = byteBuffer.array()).length) {
            byteBuffer.position(n2);
            return byArray;
        }
        byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    protected static int toDigit(char c2, int n2) throws DecoderException {
        int n3 = Character.digit(c2, 16);
        if (n3 == -1) {
            throw new DecoderException("Illegal hexadecimal character " + c2 + " at index " + n2);
        }
        return n3;
    }

    public Hex() {
        this.charset = DEFAULT_CHARSET;
    }

    public Hex(Charset charset) {
        this.charset = charset;
    }

    public Hex(String string) {
        this(Charset.forName(string));
    }

    @Override
    public byte[] decode(byte[] byArray) throws DecoderException {
        return Hex.decodeHex(new String(byArray, this.getCharset()).toCharArray());
    }

    public byte[] decode(ByteBuffer byteBuffer) throws DecoderException {
        return Hex.decodeHex(new String(Hex.toByteArray(byteBuffer), this.getCharset()).toCharArray());
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object instanceof String) {
            return this.decode(((String)object).toCharArray());
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof ByteBuffer) {
            return this.decode((ByteBuffer)object);
        }
        try {
            return Hex.decodeHex((char[])object);
        }
        catch (ClassCastException classCastException) {
            throw new DecoderException(classCastException.getMessage(), classCastException);
        }
    }

    @Override
    public byte[] encode(byte[] byArray) {
        return Hex.encodeHexString(byArray).getBytes(this.getCharset());
    }

    public byte[] encode(ByteBuffer byteBuffer) {
        return Hex.encodeHexString(byteBuffer).getBytes(this.getCharset());
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object instanceof String) {
            object = ((String)object).getBytes(this.getCharset());
        } else if (object instanceof ByteBuffer) {
            object = Hex.toByteArray((ByteBuffer)object);
        } else {
            try {
                object = (byte[])object;
            }
            catch (ClassCastException classCastException) {
                throw new EncoderException(classCastException.getMessage(), classCastException);
            }
        }
        return Hex.encodeHex((byte[])object);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset.name();
    }

    public String toString() {
        return super.toString() + "[charsetName=" + this.charset + "]";
    }
}

