/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.digest.Blake3$EngineState;
import org.apache.commons.codec.digest.Blake3$Output;

public final class Blake3 {
    private static final int BLOCK_LEN = 64;
    private static final int BLOCK_INTS = 16;
    private static final int KEY_LEN = 32;
    private static final int KEY_INTS = 8;
    private static final int OUT_LEN = 32;
    private static final int CHUNK_LEN = 1024;
    private static final int CHAINING_VALUE_INTS = 8;
    private static final int[] IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int CHUNK_START = 1;
    private static final int CHUNK_END = 2;
    private static final int PARENT = 4;
    private static final int ROOT = 8;
    private static final int KEYED_HASH = 16;
    private static final int DERIVE_KEY_CONTEXT = 32;
    private static final int DERIVE_KEY_MATERIAL = 64;
    private static final byte[][] MSG_SCHEDULE = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {2, 6, 3, 10, 7, 0, 4, 13, 1, 11, 12, 5, 9, 14, 15, 8}, {3, 4, 10, 12, 13, 2, 7, 14, 6, 5, 9, 0, 11, 15, 8, 1}, {10, 7, 12, 9, 14, 3, 13, 15, 4, 0, 11, 2, 5, 8, 1, 6}, {12, 13, 9, 11, 15, 10, 14, 8, 7, 2, 5, 3, 0, 1, 6, 4}, {9, 14, 11, 5, 8, 12, 15, 1, 13, 3, 0, 10, 2, 6, 4, 7}, {11, 15, 5, 0, 1, 9, 8, 6, 14, 10, 2, 12, 3, 4, 7, 13}};
    private final Blake3$EngineState engineState;

    private static void checkBufferArgs(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray);
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Offset must be non-negative");
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("Length must be non-negative");
        }
        int n4 = byArray.length;
        if (n2 > n4 - n3) {
            throw new IndexOutOfBoundsException("Offset " + n2 + " and length " + n3 + " out of bounds with buffer length " + n4);
        }
    }

    private static int[] compress(int[] nArray, int[] nArray2, int n2, long l2, int n3) {
        int[] nArray3 = Arrays.copyOf(nArray, 16);
        System.arraycopy(IV, 0, nArray3, 8, 4);
        nArray3[12] = (int)l2;
        nArray3[13] = (int)(l2 >> 32);
        nArray3[14] = n2;
        nArray3[15] = n3;
        for (n2 = 0; n2 < 7; ++n2) {
            byte[] byArray = MSG_SCHEDULE[n2];
            Blake3.round(nArray3, nArray2, byArray);
        }
        for (n2 = 0; n2 < nArray3.length / 2; ++n2) {
            int n4 = n2;
            nArray3[n4] = nArray3[n4] ^ nArray3[n2 + 8];
            int n5 = n2 + 8;
            nArray3[n5] = nArray3[n5] ^ nArray[n2];
        }
        return nArray3;
    }

    private static void g(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2;
        nArray[n8] = nArray[n8] + (nArray[n3] + n6);
        nArray[n5] = Integer.rotateRight(nArray[n5] ^ nArray[n2], 16);
        int n9 = n4;
        nArray[n9] = nArray[n9] + nArray[n5];
        nArray[n3] = Integer.rotateRight(nArray[n3] ^ nArray[n4], 12);
        int n10 = n2;
        nArray[n10] = nArray[n10] + (nArray[n3] + n7);
        nArray[n5] = Integer.rotateRight(nArray[n5] ^ nArray[n2], 8);
        int n11 = n4;
        nArray[n11] = nArray[n11] + nArray[n5];
        nArray[n3] = Integer.rotateRight(nArray[n3] ^ nArray[n4], 7);
    }

    public static byte[] hash(byte[] byArray) {
        return Blake3.initHash().update(byArray).doFinalize(32);
    }

    public static Blake3 initHash() {
        return new Blake3(IV, 0);
    }

    public static Blake3 initKeyDerivationFunction(byte[] byArray) {
        Objects.requireNonNull(byArray);
        Blake3$EngineState blake3$EngineState = new Blake3$EngineState(IV, 32, null);
        Blake3$EngineState.access$1400(blake3$EngineState, byArray, 0, byArray.length);
        byArray = new byte[32];
        Blake3$EngineState.access$1500(blake3$EngineState, byArray, 0, byArray.length);
        return new Blake3(Blake3.unpackInts(byArray, 8), 64);
    }

    public static Blake3 initKeyedHash(byte[] byArray) {
        Objects.requireNonNull(byArray);
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Blake3 keys must be 32 bytes");
        }
        return new Blake3(Blake3.unpackInts(byArray, 8), 16);
    }

    public static byte[] keyedHash(byte[] byArray, byte[] byArray2) {
        return Blake3.initKeyedHash(byArray).update(byArray2).doFinalize(32);
    }

    private static void packInt(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n3 + i2] = (byte)(n2 >>> (i2 << 3));
        }
    }

    private static int[] parentChainingValue(int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        return Blake3$Output.access$700(Blake3.parentOutput(nArray, nArray2, nArray3, n2));
    }

    private static Blake3$Output parentOutput(int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        nArray = Arrays.copyOf(nArray, 16);
        System.arraycopy(nArray2, 0, nArray, 8, 8);
        return new Blake3$Output((int[])nArray3.clone(), nArray, 0L, 64, n2 | 4, null);
    }

    private static void round(int[] nArray, int[] nArray2, byte[] byArray) {
        Blake3.g(nArray, 0, 4, 8, 12, nArray2[byArray[0]], nArray2[byArray[1]]);
        Blake3.g(nArray, 1, 5, 9, 13, nArray2[byArray[2]], nArray2[byArray[3]]);
        Blake3.g(nArray, 2, 6, 10, 14, nArray2[byArray[4]], nArray2[byArray[5]]);
        Blake3.g(nArray, 3, 7, 11, 15, nArray2[byArray[6]], nArray2[byArray[7]]);
        Blake3.g(nArray, 0, 5, 10, 15, nArray2[byArray[8]], nArray2[byArray[9]]);
        Blake3.g(nArray, 1, 6, 11, 12, nArray2[byArray[10]], nArray2[byArray[11]]);
        Blake3.g(nArray, 2, 7, 8, 13, nArray2[byArray[12]], nArray2[byArray[13]]);
        Blake3.g(nArray, 3, 4, 9, 14, nArray2[byArray[14]], nArray2[byArray[15]]);
    }

    private static int unpackInt(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    private static int[] unpackInts(byte[] byArray, int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            nArray[n3] = Blake3.unpackInt(byArray, n4);
            ++n3;
            n4 += 4;
        }
        return nArray;
    }

    private Blake3(int[] nArray, int n2) {
        this.engineState = new Blake3$EngineState(nArray, n2, null);
    }

    public final Blake3 doFinalize(byte[] byArray) {
        return this.doFinalize(byArray, 0, byArray.length);
    }

    public final Blake3 doFinalize(byte[] byArray, int n2, int n3) {
        Blake3.checkBufferArgs(byArray, n2, n3);
        Blake3$EngineState.access$1500(this.engineState, byArray, n2, n3);
        return this;
    }

    public final byte[] doFinalize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested bytes must be non-negative");
        }
        byte[] byArray = new byte[n2];
        this.doFinalize(byArray);
        return byArray;
    }

    public final Blake3 reset() {
        Blake3$EngineState.access$1600(this.engineState);
        return this;
    }

    public final Blake3 update(byte[] byArray) {
        return this.update(byArray, 0, byArray.length);
    }

    public final Blake3 update(byte[] byArray, int n2, int n3) {
        Blake3.checkBufferArgs(byArray, n2, n3);
        Blake3$EngineState.access$1400(this.engineState, byArray, n2, n3);
        return this;
    }

    static /* synthetic */ int[] access$000(byte[] byArray, int n2) {
        return Blake3.unpackInts(byArray, n2);
    }

    static /* synthetic */ int[] access$200(int[] nArray, int[] nArray2, int n2, long l2, int n3) {
        return Blake3.compress(nArray, nArray2, n2, l2, n3);
    }

    static /* synthetic */ int[] access$400(int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        return Blake3.parentChainingValue(nArray, nArray2, nArray3, n2);
    }

    static /* synthetic */ Blake3$Output access$1000(int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        return Blake3.parentOutput(nArray, nArray2, nArray3, n2);
    }

    static /* synthetic */ void access$1200(int n2, byte[] byArray, int n3, int n4) {
        Blake3.packInt(n2, byArray, n3, n4);
    }
}

