/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.digest.MurmurHash;
import org.apache.commons.codec.digest.MurmurHash3;

public class MurmurHash3$IncrementalHash32x86 {
    private static final int BLOCK_SIZE = 4;
    private final byte[] unprocessed = new byte[3];
    private int unprocessedLength;
    private int totalLen;
    private int hash;

    private static int orBytes(byte by2, byte by3, byte by4, byte by5) {
        return by2 & 0xFF | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 16 | (by5 & 0xFF) << 24;
    }

    public final void add(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 <= 0) {
            return;
        }
        this.totalLen += n3;
        if (this.unprocessedLength + n3 - 4 < 0) {
            System.arraycopy(byArray, n2, this.unprocessed, this.unprocessedLength, n3);
            this.unprocessedLength += n3;
            return;
        }
        if (this.unprocessedLength > 0) {
            switch (this.unprocessedLength) {
                case 1: {
                    n5 = MurmurHash3$IncrementalHash32x86.orBytes(this.unprocessed[0], byArray[n2], byArray[n2 + 1], byArray[n2 + 2]);
                    break;
                }
                case 2: {
                    n5 = MurmurHash3$IncrementalHash32x86.orBytes(this.unprocessed[0], this.unprocessed[1], byArray[n2], byArray[n2 + 1]);
                    break;
                }
                case 3: {
                    n5 = MurmurHash3$IncrementalHash32x86.orBytes(this.unprocessed[0], this.unprocessed[1], this.unprocessed[2], byArray[n2]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unprocessed length should be 1, 2, or 3: " + this.unprocessedLength);
                }
            }
            this.hash = MurmurHash3.access$100(n5, this.hash);
            n4 = 4 - this.unprocessedLength;
            n2 += n4;
            n3 -= n4;
        }
        n5 = n3 >> 2;
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = n2 + (n4 << 2);
            n6 = MurmurHash.getLittleEndianInt(byArray, n6);
            this.hash = MurmurHash3.access$100(n6, this.hash);
        }
        n4 = n5 << 2;
        this.unprocessedLength = n3 - n4;
        if (this.unprocessedLength != 0) {
            System.arraycopy(byArray, n2 + n4, this.unprocessed, 0, this.unprocessedLength);
        }
    }

    public final int end() {
        MurmurHash3$IncrementalHash32x86 murmurHash3$IncrementalHash32x86 = this;
        return murmurHash3$IncrementalHash32x86.finalise(murmurHash3$IncrementalHash32x86.hash, this.unprocessedLength, this.unprocessed, this.totalLen);
    }

    int finalise(int n2, int n3, byte[] byArray, int n4) {
        int n5 = 0;
        switch (n3) {
            case 3: {
                n5 = 0 ^ (byArray[2] & 0xFF) << 16;
            }
            case 2: {
                n5 ^= (byArray[1] & 0xFF) << 8;
            }
            case 1: {
                n5 ^= byArray[0] & 0xFF;
                n5 *= -862048943;
                n5 = Integer.rotateLeft(n5, 15);
                n2 ^= (n5 *= 461845907);
            }
        }
        return MurmurHash3.access$000(n2 ^= n4);
    }

    public final void start(int n2) {
        MurmurHash3$IncrementalHash32x86 murmurHash3$IncrementalHash32x86 = this;
        murmurHash3$IncrementalHash32x86.totalLen = 0;
        murmurHash3$IncrementalHash32x86.unprocessedLength = 0;
        this.hash = n2;
    }
}

