/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.ColognePhonetic$CologneBuffer;
import org.apache.commons.codec.language.ColognePhonetic$CologneInputBuffer;
import org.apache.commons.codec.language.ColognePhonetic$CologneOutputBuffer;

public class ColognePhonetic
implements StringEncoder {
    private static final char[] AEIJOUY = new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'};
    private static final char[] CSZ = new char[]{'C', 'S', 'Z'};
    private static final char[] FPVW = new char[]{'F', 'P', 'V', 'W'};
    private static final char[] GKQ = new char[]{'G', 'K', 'Q'};
    private static final char[] CKQ = new char[]{'C', 'K', 'Q'};
    private static final char[] AHKLOQRUX = new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'};
    private static final char[] SZ = new char[]{'S', 'Z'};
    private static final char[] AHKOQUX = new char[]{'A', 'H', 'K', 'O', 'Q', 'U', 'X'};
    private static final char[] DTX = new char[]{'D', 'T', 'X'};
    private static final char CHAR_IGNORE = '-';

    private static boolean arrayContains(char[] cArray, char c2) {
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    public String colognePhonetic(String object) {
        if (object == null) {
            return null;
        }
        ColognePhonetic colognePhonetic = this;
        object = new ColognePhonetic$CologneInputBuffer(colognePhonetic, colognePhonetic.preprocess((String)object));
        ColognePhonetic$CologneOutputBuffer colognePhonetic$CologneOutputBuffer = new ColognePhonetic$CologneOutputBuffer(this, ((ColognePhonetic$CologneBuffer)object).length() << 1);
        char c2 = '-';
        while (!((ColognePhonetic$CologneBuffer)object).isEmpty()) {
            char c3 = ((ColognePhonetic$CologneInputBuffer)object).removeNext();
            char c4 = !((ColognePhonetic$CologneBuffer)object).isEmpty() ? (char)((ColognePhonetic$CologneInputBuffer)object).getNextChar() : (char)'-';
            if (c3 < 'A' || c3 > 'Z') continue;
            if (ColognePhonetic.arrayContains(AEIJOUY, c3)) {
                colognePhonetic$CologneOutputBuffer.put('0');
            } else if (c3 == 'B' || c3 == 'P' && c4 != 'H') {
                colognePhonetic$CologneOutputBuffer.put('1');
            } else if (!(c3 != 'D' && c3 != 'T' || ColognePhonetic.arrayContains(CSZ, c4))) {
                colognePhonetic$CologneOutputBuffer.put('2');
            } else if (ColognePhonetic.arrayContains(FPVW, c3)) {
                colognePhonetic$CologneOutputBuffer.put('3');
            } else if (ColognePhonetic.arrayContains(GKQ, c3)) {
                colognePhonetic$CologneOutputBuffer.put('4');
            } else if (c3 == 'X' && !ColognePhonetic.arrayContains(CKQ, c2)) {
                colognePhonetic$CologneOutputBuffer.put('4');
                colognePhonetic$CologneOutputBuffer.put('8');
            } else if (c3 == 'S' || c3 == 'Z') {
                colognePhonetic$CologneOutputBuffer.put('8');
            } else if (c3 == 'C') {
                if (colognePhonetic$CologneOutputBuffer.isEmpty()) {
                    if (ColognePhonetic.arrayContains(AHKLOQRUX, c4)) {
                        colognePhonetic$CologneOutputBuffer.put('4');
                    } else {
                        colognePhonetic$CologneOutputBuffer.put('8');
                    }
                } else if (ColognePhonetic.arrayContains(SZ, c2) || !ColognePhonetic.arrayContains(AHKOQUX, c4)) {
                    colognePhonetic$CologneOutputBuffer.put('8');
                } else {
                    colognePhonetic$CologneOutputBuffer.put('4');
                }
            } else if (ColognePhonetic.arrayContains(DTX, c3)) {
                colognePhonetic$CologneOutputBuffer.put('8');
            } else {
                switch (c3) {
                    case 'R': {
                        colognePhonetic$CologneOutputBuffer.put('7');
                        break;
                    }
                    case 'L': {
                        colognePhonetic$CologneOutputBuffer.put('5');
                        break;
                    }
                    case 'M': 
                    case 'N': {
                        colognePhonetic$CologneOutputBuffer.put('6');
                        break;
                    }
                    case 'H': {
                        colognePhonetic$CologneOutputBuffer.put('-');
                    }
                }
            }
            c2 = c3;
        }
        return colognePhonetic$CologneOutputBuffer.toString();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("This method's parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + object.getClass().getName() + ".");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        return this.colognePhonetic(string);
    }

    public boolean isEncodeEqual(String string, String string2) {
        return this.colognePhonetic(string).equals(this.colognePhonetic(string2));
    }

    private char[] preprocess(String object) {
        object = ((String)object).toUpperCase(Locale.GERMAN).toCharArray();
        block5: for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            switch (object[i2]) {
                case 196: {
                    object[i2] = 65;
                    continue block5;
                }
                case 220: {
                    object[i2] = 85;
                    continue block5;
                }
                case 214: {
                    object[i2] = 79;
                }
            }
        }
        return object;
    }
}

