/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.Resources;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.DaitchMokotoffSoundex$Branch;
import org.apache.commons.codec.language.DaitchMokotoffSoundex$Rule;

public class DaitchMokotoffSoundex
implements StringEncoder {
    private static final char NUL = '\u0000';
    private static final String COMMENT = "//";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String MULTILINE_COMMENT_END = "*/";
    private static final String MULTILINE_COMMENT_START = "/*";
    private static final String RESOURCE_FILE = "/org/apache/commons/codec/language/dmrules.txt";
    private static final int MAX_LENGTH = 6;
    private static final Map<Character, List<DaitchMokotoffSoundex$Rule>> RULES = new HashMap<Character, List<DaitchMokotoffSoundex$Rule>>();
    private static final Map<Character, Character> FOLDINGS = new HashMap<Character, Character>();
    private static final Pattern EQUAL = Pattern.compile("=");
    private static final Pattern SPACES = Pattern.compile("\\s+");
    private final boolean folding;

    private static void parseRules(Scanner scanner, String string, Map<Character, List<DaitchMokotoffSoundex$Rule>> map, Map<Character, Character> map2) {
        int n2 = 0;
        boolean bl2 = false;
        while (scanner.hasNextLine()) {
            String string2;
            Object object;
            ++n2;
            Object object2 = object = scanner.nextLine();
            if (bl2) {
                if (!object2.endsWith(MULTILINE_COMMENT_END)) continue;
                bl2 = false;
                continue;
            }
            if (object2.startsWith(MULTILINE_COMMENT_START)) {
                bl2 = true;
                continue;
            }
            int n3 = object2.indexOf(COMMENT);
            if (n3 >= 0) {
                object2 = object2.substring(0, n3);
            }
            if ((object2 = object2.trim()).isEmpty()) continue;
            if (object2.contains("=")) {
                if (((String[])(object2 = EQUAL.split((CharSequence)object2))).length != 2) {
                    throw new IllegalArgumentException("Malformed folding statement split into " + ((String[])object2).length + " parts: " + (String)object + " in " + string);
                }
                String string3 = object2[0];
                string2 = object2[1];
                if (string3.length() != 1 || string2.length() != 1) {
                    throw new IllegalArgumentException("Malformed folding statement - patterns are not single characters: " + (String)object + " in " + string);
                }
                map2.put(Character.valueOf(string3.charAt(0)), Character.valueOf(string2.charAt(0)));
                continue;
            }
            if (((String[])(object2 = SPACES.split((CharSequence)object2))).length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + ((String[])object2).length + " parts: " + (String)object + " in " + string);
            }
            try {
                String string4 = DaitchMokotoffSoundex.stripQuotes(object2[0]);
                string2 = DaitchMokotoffSoundex.stripQuotes(object2[1]);
                object = DaitchMokotoffSoundex.stripQuotes(object2[2]);
                object2 = DaitchMokotoffSoundex.stripQuotes(object2[3]);
                object = new DaitchMokotoffSoundex$Rule(string4, string2, (String)object, (String)object2, null);
                char c3 = DaitchMokotoffSoundex$Rule.access$100((DaitchMokotoffSoundex$Rule)object).charAt(0);
                object2 = map.computeIfAbsent(Character.valueOf(c3), c2 -> new ArrayList());
                object2.add(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Problem parsing line '" + n2 + "' in " + string, illegalArgumentException);
            }
        }
    }

    private static String stripQuotes(String string) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public DaitchMokotoffSoundex() {
        this(true);
    }

    public DaitchMokotoffSoundex(boolean bl2) {
        this.folding = bl2;
    }

    private String cleanup(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (Character.isWhitespace((char)object2) || !Character.isLetter((char)object2)) continue;
            object2 = Character.toLowerCase((char)object2);
            Character c2 = FOLDINGS.get(Character.valueOf((char)object2));
            if (this.folding && c2 != null) {
                object2 = c2.charValue();
            }
            stringBuilder.append((char)object2);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to DaitchMokotoffSoundex encode is not of type java.lang.String");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        if (string == null) {
            return null;
        }
        return this.soundex(string, false)[0];
    }

    public String soundex(String string) {
        return String.join((CharSequence)"|", this.soundex(string, true));
    }

    private String[] soundex(String string, boolean bl2) {
        int n2;
        if (string == null) {
            return null;
        }
        string = this.cleanup(string);
        LinkedHashSet<DaitchMokotoffSoundex$Branch> linkedHashSet = new LinkedHashSet<DaitchMokotoffSoundex$Branch>();
        linkedHashSet.add(new DaitchMokotoffSoundex$Branch(null));
        int n3 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = string.charAt(i2);
            String[] stringArray = string.substring(i2);
            List<DaitchMokotoffSoundex$Rule> object = RULES.get(Character.valueOf((char)n2));
            if (object == null) continue;
            ArrayList<DaitchMokotoffSoundex$Branch> arrayList = bl2 ? new ArrayList<DaitchMokotoffSoundex$Branch>() : Collections.emptyList();
            for (DaitchMokotoffSoundex$Rule daitchMokotoffSoundex$Rule : object) {
                if (!DaitchMokotoffSoundex$Rule.access$300(daitchMokotoffSoundex$Rule, (String)stringArray)) continue;
                if (bl2) {
                    arrayList.clear();
                }
                stringArray = DaitchMokotoffSoundex$Rule.access$400(daitchMokotoffSoundex$Rule, (String)stringArray, n3 == 0);
                boolean bl3 = stringArray.length > 1 && bl2;
                block2: for (DaitchMokotoffSoundex$Branch daitchMokotoffSoundex$Branch : linkedHashSet) {
                    String[] stringArray2 = stringArray;
                    int n4 = stringArray.length;
                    for (int i3 = 0; i3 < n4; ++i3) {
                        String string2 = stringArray2[i3];
                        DaitchMokotoffSoundex$Branch daitchMokotoffSoundex$Branch2 = bl3 ? DaitchMokotoffSoundex$Branch.access$500(daitchMokotoffSoundex$Branch) : daitchMokotoffSoundex$Branch;
                        boolean bl4 = n3 == 109 && n2 == 110 || n3 == 110 && n2 == 109;
                        DaitchMokotoffSoundex$Branch.access$600(daitchMokotoffSoundex$Branch2, string2, bl4);
                        if (!bl2) continue block2;
                        arrayList.add(daitchMokotoffSoundex$Branch2);
                    }
                }
                if (bl2) {
                    linkedHashSet.clear();
                    linkedHashSet.addAll(arrayList);
                }
                i2 += DaitchMokotoffSoundex$Rule.access$700(daitchMokotoffSoundex$Rule) - 1;
                break;
            }
            n3 = n2;
        }
        String[] stringArray = new String[linkedHashSet.size()];
        n2 = 0;
        for (DaitchMokotoffSoundex$Branch daitchMokotoffSoundex$Branch : linkedHashSet) {
            DaitchMokotoffSoundex$Branch.access$800(daitchMokotoffSoundex$Branch);
            stringArray[n2++] = daitchMokotoffSoundex$Branch.toString();
        }
        return stringArray;
    }

    static {
        try (Scanner scanner = new Scanner(Resources.getInputStream(RESOURCE_FILE), CharEncoding.UTF_8);){
            DaitchMokotoffSoundex.parseRules(scanner, RESOURCE_FILE, RULES, FOLDINGS);
        }
        RULES.forEach((c2, list) -> list.sort((daitchMokotoffSoundex$Rule, daitchMokotoffSoundex$Rule2) -> DaitchMokotoffSoundex$Rule.access$700(daitchMokotoffSoundex$Rule2) - DaitchMokotoffSoundex$Rule.access$700(daitchMokotoffSoundex$Rule)));
    }
}

