/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class Metaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOU";
    private static final String FRONTV = "EIY";
    private static final String VARSON = "CSPTG";
    private int maxCodeLen = 4;

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Metaphone encode is not of type java.lang.String");
        }
        return this.metaphone((String)object);
    }

    @Override
    public String encode(String string) {
        return this.metaphone(string);
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    private boolean isLastChar(int n2, int n3) {
        return n3 + 1 == n2;
    }

    public boolean isMetaphoneEqual(String string, String string2) {
        return this.metaphone(string).equals(this.metaphone(string2));
    }

    private boolean isNextChar(StringBuilder stringBuilder, int n2, char c2) {
        boolean bl2 = false;
        if (n2 >= 0 && n2 < stringBuilder.length() - 1) {
            bl2 = stringBuilder.charAt(n2 + 1) == c2;
        }
        return bl2;
    }

    private boolean isPreviousChar(StringBuilder stringBuilder, int n2, char c2) {
        boolean bl2 = false;
        if (n2 > 0 && n2 < stringBuilder.length()) {
            bl2 = stringBuilder.charAt(n2 - 1) == c2;
        }
        return bl2;
    }

    private boolean isVowel(StringBuilder stringBuilder, int n2) {
        return VOWELS.indexOf(stringBuilder.charAt(n2)) >= 0;
    }

    public String metaphone(String object) {
        int n2;
        if (object == null || (n2 = ((String)object).length()) == 0) {
            return "";
        }
        if (n2 == 1) {
            return ((String)object).toUpperCase(Locale.ENGLISH);
        }
        object = ((String)object).toUpperCase(Locale.ENGLISH).toCharArray();
        StringBuilder stringBuilder = new StringBuilder(40);
        StringBuilder stringBuilder2 = new StringBuilder(10);
        switch (object[0]) {
            case 71: 
            case 75: 
            case 80: {
                if (object[1] == 78) {
                    stringBuilder.append((char[])object, 1, ((Object)object).length - 1);
                    break;
                }
                stringBuilder.append((char[])object);
                break;
            }
            case 65: {
                if (object[1] == 69) {
                    stringBuilder.append((char[])object, 1, ((Object)object).length - 1);
                    break;
                }
                stringBuilder.append((char[])object);
                break;
            }
            case 87: {
                if (object[1] == 82) {
                    stringBuilder.append((char[])object, 1, ((Object)object).length - 1);
                    break;
                }
                if (object[1] == 72) {
                    stringBuilder.append((char[])object, 1, ((Object)object).length - 1);
                    stringBuilder.setCharAt(0, 'W');
                    break;
                }
                stringBuilder.append((char[])object);
                break;
            }
            case 88: {
                object[0] = 83;
                stringBuilder.append((char[])object);
                break;
            }
            default: {
                stringBuilder.append((char[])object);
            }
        }
        int n3 = stringBuilder.length();
        block24: for (int i2 = 0; stringBuilder2.length() < this.getMaxCodeLen() && i2 < n3; ++i2) {
            char c2 = stringBuilder.charAt(i2);
            if (c2 != 'C' && this.isPreviousChar(stringBuilder, i2, c2)) continue;
            switch (c2) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': {
                    if (i2 != 0) continue block24;
                    stringBuilder2.append(c2);
                    continue block24;
                }
                case 'B': {
                    if (this.isPreviousChar(stringBuilder, i2, 'M') && this.isLastChar(n3, i2)) continue block24;
                    stringBuilder2.append(c2);
                    continue block24;
                }
                case 'C': {
                    if (this.isPreviousChar(stringBuilder, i2, 'S') && !this.isLastChar(n3, i2) && FRONTV.indexOf(stringBuilder.charAt(i2 + 1)) >= 0) continue block24;
                    if (this.regionMatch(stringBuilder, i2, "CIA")) {
                        stringBuilder2.append('X');
                        continue block24;
                    }
                    if (!this.isLastChar(n3, i2) && FRONTV.indexOf(stringBuilder.charAt(i2 + 1)) >= 0) {
                        stringBuilder2.append('S');
                        continue block24;
                    }
                    if (this.isPreviousChar(stringBuilder, i2, 'S') && this.isNextChar(stringBuilder, i2, 'H')) {
                        stringBuilder2.append('K');
                        continue block24;
                    }
                    if (!this.isNextChar(stringBuilder, i2, 'H') || i2 == 0 && n3 >= 3 && this.isVowel(stringBuilder, 2)) {
                        stringBuilder2.append('K');
                        continue block24;
                    }
                    stringBuilder2.append('X');
                    continue block24;
                }
                case 'D': {
                    if (!this.isLastChar(n3, i2 + 1) && this.isNextChar(stringBuilder, i2, 'G') && FRONTV.indexOf(stringBuilder.charAt(i2 + 2)) >= 0) {
                        stringBuilder2.append('J');
                        i2 += 2;
                        continue block24;
                    }
                    stringBuilder2.append('T');
                    continue block24;
                }
                case 'G': {
                    if (this.isLastChar(n3, i2 + 1) && this.isNextChar(stringBuilder, i2, 'H') || !this.isLastChar(n3, i2 + 1) && this.isNextChar(stringBuilder, i2, 'H') && !this.isVowel(stringBuilder, i2 + 2) || i2 > 0 && (this.regionMatch(stringBuilder, i2, "GN") || this.regionMatch(stringBuilder, i2, "GNED"))) continue block24;
                    c2 = (char)(this.isPreviousChar(stringBuilder, i2, 'G') ? 1 : 0);
                    if (!this.isLastChar(n3, i2) && FRONTV.indexOf(stringBuilder.charAt(i2 + 1)) >= 0 && c2 == '\u0000') {
                        stringBuilder2.append('J');
                        continue block24;
                    }
                    stringBuilder2.append('K');
                    continue block24;
                }
                case 'H': {
                    if (this.isLastChar(n3, i2) || i2 > 0 && VARSON.indexOf(stringBuilder.charAt(i2 - 1)) >= 0 || !this.isVowel(stringBuilder, i2 + 1)) continue block24;
                    stringBuilder2.append('H');
                    continue block24;
                }
                case 'F': 
                case 'J': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'R': {
                    stringBuilder2.append(c2);
                    continue block24;
                }
                case 'K': {
                    if (i2 > 0) {
                        if (this.isPreviousChar(stringBuilder, i2, 'C')) continue block24;
                        stringBuilder2.append(c2);
                        continue block24;
                    }
                    stringBuilder2.append(c2);
                    continue block24;
                }
                case 'P': {
                    if (this.isNextChar(stringBuilder, i2, 'H')) {
                        stringBuilder2.append('F');
                        continue block24;
                    }
                    stringBuilder2.append(c2);
                    continue block24;
                }
                case 'Q': {
                    stringBuilder2.append('K');
                    continue block24;
                }
                case 'S': {
                    if (this.regionMatch(stringBuilder, i2, "SH") || this.regionMatch(stringBuilder, i2, "SIO") || this.regionMatch(stringBuilder, i2, "SIA")) {
                        stringBuilder2.append('X');
                        continue block24;
                    }
                    stringBuilder2.append('S');
                    continue block24;
                }
                case 'T': {
                    if (this.regionMatch(stringBuilder, i2, "TIA") || this.regionMatch(stringBuilder, i2, "TIO")) {
                        stringBuilder2.append('X');
                        continue block24;
                    }
                    if (this.regionMatch(stringBuilder, i2, "TCH")) continue block24;
                    if (this.regionMatch(stringBuilder, i2, "TH")) {
                        stringBuilder2.append('0');
                        continue block24;
                    }
                    stringBuilder2.append('T');
                    continue block24;
                }
                case 'V': {
                    stringBuilder2.append('F');
                    continue block24;
                }
                case 'W': 
                case 'Y': {
                    if (this.isLastChar(n3, i2) || !this.isVowel(stringBuilder, i2 + 1)) continue block24;
                    stringBuilder2.append(c2);
                    continue block24;
                }
                case 'X': {
                    stringBuilder2.append('K');
                    stringBuilder2.append('S');
                    continue block24;
                }
                case 'Z': {
                    stringBuilder2.append('S');
                }
            }
            if (stringBuilder2.length() <= this.getMaxCodeLen()) continue;
            stringBuilder2.setLength(this.getMaxCodeLen());
        }
        return stringBuilder2.toString();
    }

    private boolean regionMatch(StringBuilder charSequence, int n2, String string) {
        boolean bl2 = false;
        if (n2 >= 0 && n2 + string.length() - 1 < charSequence.length()) {
            int n3 = n2;
            charSequence = charSequence.substring(n3, n3 + string.length());
            bl2 = ((String)charSequence).equals(string);
        }
        return bl2;
    }

    public void setMaxCodeLen(int n2) {
        this.maxCodeLen = n2;
    }
}

