/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.Resources;
import org.apache.commons.codec.language.bm.Lang$LangRule;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.ResourceConstants;

public class Lang {
    private static final Map<NameType, Lang> LANGS = new EnumMap<NameType, Lang>(NameType.class);
    private static final String LANGUAGE_RULES_RN = "/org/apache/commons/codec/language/bm/%s_lang.txt";
    private static final Pattern PLUS = Pattern.compile("\\+");
    private final Languages languages;
    private final List<Lang$LangRule> rules;

    public static Lang instance(NameType nameType) {
        return LANGS.get((Object)nameType);
    }

    public static Lang loadFromResource(String string, Languages languages) {
        ArrayList<Lang$LangRule> arrayList = new ArrayList<Lang$LangRule>();
        try (Scanner scanner = new Scanner(Resources.getInputStream(string), ResourceConstants.ENCODING);){
            boolean bl2 = false;
            while (scanner.hasNextLine()) {
                Object object;
                String[] stringArray = object = scanner.nextLine();
                if (bl2) {
                    if (!stringArray.endsWith("*/")) continue;
                    bl2 = false;
                    continue;
                }
                if (stringArray.startsWith("/*")) {
                    bl2 = true;
                    continue;
                }
                int n2 = stringArray.indexOf("//");
                if (n2 >= 0) {
                    stringArray = stringArray.substring(0, n2);
                }
                if ((stringArray = stringArray.trim()).isEmpty()) continue;
                if ((stringArray = ResourceConstants.SPACES.split((CharSequence)stringArray)).length != 3) {
                    throw new IllegalArgumentException("Malformed line '" + (String)object + "' in language resource '" + string + "'");
                }
                object = Pattern.compile(stringArray[0]);
                String[] stringArray2 = PLUS.split(stringArray[1]);
                boolean bl3 = stringArray[2].equals("true");
                arrayList.add(new Lang$LangRule((Pattern)object, new HashSet<String>(Arrays.asList(stringArray2)), bl3, null));
            }
        }
        return new Lang(arrayList, languages);
    }

    private Lang(List<Lang$LangRule> list, Languages languages) {
        this.rules = Collections.unmodifiableList(list);
        this.languages = languages;
    }

    public String guessLanguage(String object) {
        if (((Languages$LanguageSet)(object = this.guessLanguages((String)object))).isSingleton()) {
            return ((Languages$LanguageSet)object).getAny();
        }
        return "any";
    }

    public Languages$LanguageSet guessLanguages(String object) {
        object = ((String)object).toLowerCase(Locale.ENGLISH);
        HashSet<String> hashSet = new HashSet<String>(this.languages.getLanguages());
        this.rules.forEach(arg_0 -> Lang.lambda$guessLanguages$0((String)object, hashSet, arg_0));
        object = Languages$LanguageSet.from(hashSet);
        if (object.equals(Languages.NO_LANGUAGES)) {
            return Languages.ANY_LANGUAGE;
        }
        return object;
    }

    private static /* synthetic */ void lambda$guessLanguages$0(String string, Set set, Lang$LangRule lang$LangRule) {
        if (lang$LangRule.matches(string)) {
            if (Lang$LangRule.access$100(lang$LangRule)) {
                set.retainAll(Lang$LangRule.access$200(lang$LangRule));
                return;
            }
            set.removeAll(Lang$LangRule.access$200(lang$LangRule));
        }
    }

    static {
        for (NameType nameType : NameType.values()) {
            LANGS.put(nameType, Lang.loadFromResource(String.format(LANGUAGE_RULES_RN, nameType.getName()), Languages.getInstance(nameType)));
        }
    }
}

