/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.language.bm.Lang;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine$PhonemeBuilder;
import org.apache.commons.codec.language.bm.PhoneticEngine$RulesApplication;
import org.apache.commons.codec.language.bm.ResourceConstants;
import org.apache.commons.codec.language.bm.Rule;
import org.apache.commons.codec.language.bm.Rule$Phoneme;
import org.apache.commons.codec.language.bm.RuleType;

public class PhoneticEngine {
    private static final int DEFAULT_MAX_PHONEMES = 20;
    private static final Map<NameType, Set<String>> NAME_PREFIXES = new EnumMap<NameType, Set<String>>(NameType.class);
    private static final Pattern QUOTE = Pattern.compile("'");
    private final Lang lang;
    private final NameType nameType;
    private final RuleType ruleType;
    private final boolean concat;
    private final int maxPhonemes;

    private static String join(List<String> list, String string) {
        return list.stream().collect(Collectors.joining(string));
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl2) {
        this(nameType, ruleType, bl2, 20);
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl2, int n2) {
        if (ruleType == RuleType.RULES) {
            throw new IllegalArgumentException("ruleType must not be " + (Object)((Object)RuleType.RULES));
        }
        this.nameType = nameType;
        this.ruleType = ruleType;
        this.concat = bl2;
        this.lang = Lang.instance(nameType);
        this.maxPhonemes = n2;
    }

    private PhoneticEngine$PhonemeBuilder applyFinalRules(PhoneticEngine$PhonemeBuilder phoneticEngine$PhonemeBuilder, Map<String, List<Rule>> map) {
        Objects.requireNonNull(map, "finalRules");
        if (map.isEmpty()) {
            return phoneticEngine$PhonemeBuilder;
        }
        TreeMap treeMap = new TreeMap(Rule$Phoneme.COMPARATOR);
        phoneticEngine$PhonemeBuilder.getPhonemes().forEach(object -> {
            PhoneticEngine$PhonemeBuilder phoneticEngine$PhonemeBuilder = PhoneticEngine$PhonemeBuilder.empty(((Rule$Phoneme)object).getLanguages());
            object = ((Rule$Phoneme)object).getPhonemeText();
            int n2 = 0;
            while (n2 < object.length()) {
                PhoneticEngine$RulesApplication phoneticEngine$RulesApplication = new PhoneticEngine$RulesApplication(map, (CharSequence)object, phoneticEngine$PhonemeBuilder, n2, this.maxPhonemes).invoke();
                boolean bl2 = phoneticEngine$RulesApplication.isFound();
                phoneticEngine$PhonemeBuilder = phoneticEngine$RulesApplication.getPhonemeBuilder();
                if (!bl2) {
                    int n3 = n2;
                    phoneticEngine$PhonemeBuilder.append(object.subSequence(n3, n3 + 1));
                }
                n2 = phoneticEngine$RulesApplication.getI();
            }
            phoneticEngine$PhonemeBuilder.getPhonemes().forEach(rule$Phoneme -> {
                if (treeMap.containsKey(rule$Phoneme)) {
                    Rule$Phoneme rule$Phoneme2 = (Rule$Phoneme)treeMap.remove(rule$Phoneme);
                    Rule$Phoneme rule$Phoneme3 = rule$Phoneme = rule$Phoneme2.mergeWithLanguage(rule$Phoneme.getLanguages());
                    treeMap.put(rule$Phoneme3, rule$Phoneme3);
                    return;
                }
                Rule$Phoneme rule$Phoneme4 = rule$Phoneme;
                treeMap.put(rule$Phoneme4, rule$Phoneme4);
            });
        });
        return new PhoneticEngine$PhonemeBuilder(treeMap.keySet(), null);
    }

    public String encode(String string) {
        Languages$LanguageSet languages$LanguageSet = this.lang.guessLanguages(string);
        return this.encode(string, languages$LanguageSet);
    }

    public String encode(String string, Languages$LanguageSet object) {
        Object object2;
        Object object3;
        Map<String, List<Rule>> map = Rule.getInstanceMap(this.nameType, RuleType.RULES, (Languages$LanguageSet)object);
        Map<String, List<Rule>> map2 = Rule.getInstanceMap(this.nameType, this.ruleType, "common");
        Map<String, List<Rule>> map3 = Rule.getInstanceMap(this.nameType, this.ruleType, (Languages$LanguageSet)object);
        string = string.toLowerCase(Locale.ENGLISH).replace('-', ' ').trim();
        if (this.nameType == NameType.GENERIC) {
            if (string.startsWith("d'")) {
                String string2 = string.substring(2);
                String string3 = "d" + string2;
                return "(" + this.encode(string2) + ")-(" + this.encode(string3) + ")";
            }
            object3 = NAME_PREFIXES.get((Object)this.nameType).iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (!string.startsWith((String)object2 + " ")) continue;
                object = string.substring(((String)object2).length() + 1);
                object3 = (String)object2 + (String)object;
                return "(" + this.encode((String)object) + ")-(" + this.encode((String)object3) + ")";
            }
        }
        object3 = Arrays.asList(ResourceConstants.SPACES.split(string));
        object2 = new ArrayList();
        switch (this.nameType) {
            case SEPHARDIC: {
                object3.forEach(stringArray -> {
                    stringArray = QUOTE.split((CharSequence)stringArray, -1);
                    object2.add(stringArray[((String[])stringArray).length - 1]);
                });
                object2.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case ASHKENAZI: {
                object2.addAll(object3);
                object2.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case GENERIC: {
                object2.addAll(object3);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable case: " + (Object)((Object)this.nameType));
            }
        }
        if (this.concat) {
            string = PhoneticEngine.join((List<String>)object2, " ");
        } else if (object2.size() == 1) {
            string = (String)object3.iterator().next();
        } else if (!object2.isEmpty()) {
            object = new StringBuilder();
            object2.forEach(arg_0 -> this.lambda$encode$3((StringBuilder)object, arg_0));
            return ((StringBuilder)object).substring(1);
        }
        object = PhoneticEngine$PhonemeBuilder.empty((Languages$LanguageSet)object);
        int n2 = 0;
        while (n2 < string.length()) {
            object = new PhoneticEngine$RulesApplication(map, string, (PhoneticEngine$PhonemeBuilder)object, n2, this.maxPhonemes).invoke();
            n2 = ((PhoneticEngine$RulesApplication)object).getI();
            object = ((PhoneticEngine$RulesApplication)object).getPhonemeBuilder();
        }
        object = this.applyFinalRules((PhoneticEngine$PhonemeBuilder)object, map2);
        object = this.applyFinalRules((PhoneticEngine$PhonemeBuilder)object, map3);
        return ((PhoneticEngine$PhonemeBuilder)object).makeString();
    }

    public Lang getLang() {
        return this.lang;
    }

    public int getMaxPhonemes() {
        return this.maxPhonemes;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean isConcat() {
        return this.concat;
    }

    private /* synthetic */ void lambda$encode$3(StringBuilder stringBuilder, String string) {
        stringBuilder.append("-").append(this.encode(string));
    }

    static {
        NAME_PREFIXES.put(NameType.ASHKENAZI, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bar", "ben", "da", "de", "van", "von"))));
        NAME_PREFIXES.put(NameType.SEPHARDIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("al", "el", "da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
        NAME_PREFIXES.put(NameType.GENERIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
    }
}

