/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.Resources;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.ResourceConstants;
import org.apache.commons.codec.language.bm.Rule$1;
import org.apache.commons.codec.language.bm.Rule$2;
import org.apache.commons.codec.language.bm.Rule$Phoneme;
import org.apache.commons.codec.language.bm.Rule$PhonemeExpr;
import org.apache.commons.codec.language.bm.Rule$PhonemeList;
import org.apache.commons.codec.language.bm.Rule$RPattern;
import org.apache.commons.codec.language.bm.RuleType;

public class Rule {
    private static final String PIPE = "|";
    public static final Rule$RPattern ALL_STRINGS_RMATCHER = charSequence -> true;
    @Deprecated
    public static final String ALL = "ALL";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String HASH_INCLUDE = "#include";
    private static final int HASH_INCLUDE_LENGTH = 8;
    private static final Pattern AROUND_PLUS = Pattern.compile("[+]");
    private static final Pattern AROUND_PIPE = Pattern.compile("[|]");
    private static final Map<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>> RULES = new EnumMap<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>>(NameType.class);
    private final Rule$RPattern lContext;
    private final String pattern;
    private final Rule$PhonemeExpr phoneme;
    private final Rule$RPattern rContext;

    private static boolean contains(CharSequence charSequence, char c2) {
        return charSequence.chars().anyMatch(n2 -> n2 == c2);
    }

    private static String createResourceName(NameType nameType, RuleType ruleType, String string) {
        return String.format("/org/apache/commons/codec/language/bm/%s_%s_%s.txt", nameType.getName(), ruleType.getName(), string);
    }

    private static Scanner createScanner(NameType object, RuleType ruleType, String string) {
        object = Rule.createResourceName(object, ruleType, string);
        return new Scanner(Resources.getInputStream((String)object), ResourceConstants.ENCODING);
    }

    private static Scanner createScanner(String string) {
        string = String.format("/org/apache/commons/codec/language/bm/%s.txt", string);
        return new Scanner(Resources.getInputStream(string), ResourceConstants.ENCODING);
    }

    private static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        int n3 = charSequence2.length();
        if (n3 > (n2 = charSequence.length())) {
            return false;
        }
        --n2;
        --n3;
        while (n3 >= 0) {
            if (charSequence.charAt(n2) != charSequence2.charAt(n3)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public static List<Rule> getInstance(NameType object, RuleType object2, Languages$LanguageSet languages$LanguageSet) {
        object = Rule.getInstanceMap((NameType)((Object)object), object2, languages$LanguageSet);
        object2 = new ArrayList();
        object.values().forEach(arg_0 -> Rule.lambda$getInstance$3((List)object2, arg_0));
        return object2;
    }

    public static List<Rule> getInstance(NameType nameType, RuleType ruleType, String string) {
        return Rule.getInstance(nameType, ruleType, Languages$LanguageSet.from(new HashSet<String>(Arrays.asList(string))));
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType ruleType, Languages$LanguageSet languages$LanguageSet) {
        if (languages$LanguageSet.isSingleton()) {
            return Rule.getInstanceMap(nameType, ruleType, languages$LanguageSet.getAny());
        }
        return Rule.getInstanceMap(nameType, ruleType, "any");
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType ruleType, String string) {
        Map<String, List<Rule>> map = RULES.get((Object)nameType).get((Object)ruleType).get(string);
        if (map == null) {
            throw new IllegalArgumentException(String.format("No rules found for %s, %s, '%s'.", nameType.getName(), ruleType.getName(), string));
        }
        return map;
    }

    private static Rule$Phoneme parsePhoneme(String object) {
        int n2 = ((String)object).indexOf("[");
        if (n2 >= 0) {
            if (!((String)object).endsWith("]")) {
                throw new IllegalArgumentException("Phoneme expression contains a '[' but does not end in ']'");
            }
            String string = ((String)object).substring(0, n2);
            object = ((String)object).substring(n2 + 1, ((String)object).length() - 1);
            object = new HashSet<String>(Arrays.asList(AROUND_PLUS.split((CharSequence)object)));
            return new Rule$Phoneme(string, Languages$LanguageSet.from((Set<String>)object));
        }
        return new Rule$Phoneme((CharSequence)object, Languages.ANY_LANGUAGE);
    }

    static Rule$PhonemeExpr parsePhonemeExpr(String string) {
        if (string.startsWith("(")) {
            String[] stringArray;
            if (!string.endsWith(")")) {
                throw new IllegalArgumentException("Phoneme starting with '(' must end with ')'");
            }
            ArrayList<Rule$Phoneme> arrayList = new ArrayList<Rule$Phoneme>();
            string = string.substring(1, string.length() - 1);
            String[] stringArray2 = stringArray = AROUND_PIPE.split(string);
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray2[i2];
                arrayList.add(Rule.parsePhoneme(string2));
            }
            if (stringArray.length > 1 && stringArray[0].length() != 0 && string.startsWith(PIPE) || stringArray[stringArray.length - 1].length() != 0 && string.endsWith(PIPE)) {
                arrayList.add(new Rule$Phoneme("", Languages.ANY_LANGUAGE));
            }
            return new Rule$PhonemeList(arrayList);
        }
        return Rule.parsePhoneme(string);
    }

    private static Map<String, List<Rule>> parseRules(Scanner scanner, String string2) {
        HashMap<String, List<Rule>> hashMap = new HashMap<String, List<Rule>>();
        int n2 = 0;
        boolean bl2 = false;
        while (scanner.hasNextLine()) {
            ++n2;
            Object object = scanner.nextLine();
            Object object2 = object;
            if (bl2) {
                if (!object2.endsWith("*/")) continue;
                bl2 = false;
                continue;
            }
            if (object2.startsWith("/*")) {
                bl2 = true;
                continue;
            }
            int n3 = object2.indexOf("//");
            if (n3 >= 0) {
                object2 = object2.substring(0, n3);
            }
            if ((object2 = object2.trim()).isEmpty()) continue;
            if (object2.startsWith(HASH_INCLUDE)) {
                if ((object2 = object2.substring(HASH_INCLUDE_LENGTH).trim()).contains(" ")) {
                    throw new IllegalArgumentException("Malformed import statement '" + (String)object + "' in " + string2);
                }
                object = Rule.createScanner((String)object2);
                try {
                    hashMap.putAll(Rule.parseRules((Scanner)object, string2 + "->" + (String)object2));
                    continue;
                }
                finally {
                    if (object != null) {
                        ((Scanner)object).close();
                    }
                    continue;
                }
            }
            if (((String[])(object2 = ResourceConstants.SPACES.split((CharSequence)object2))).length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + ((String[])object2).length + " parts: " + (String)object + " in " + string2);
            }
            try {
                object = Rule.stripQuotes(object2[0]);
                String string3 = Rule.stripQuotes(object2[1]);
                String string4 = Rule.stripQuotes(object2[2]);
                object2 = Rule.parsePhonemeExpr(Rule.stripQuotes(object2[3]));
                int n4 = n2;
                object = new Rule$1((String)object, string3, string4, (Rule$PhonemeExpr)object2, n4, string2, (String)object, string3, string4);
                object2 = ((Rule)object).pattern.substring(0, 1);
                object2 = hashMap.computeIfAbsent((String)object2, string -> new ArrayList());
                object2.add(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Problem parsing line '" + n2 + "' in " + string2, illegalArgumentException);
            }
        }
        return hashMap;
    }

    private static Rule$RPattern pattern(String string) {
        boolean bl2;
        boolean bl3 = string.startsWith("^");
        String string2 = string.substring(bl3 ? 1 : 0, (bl2 = string.endsWith("$")) ? string.length() - 1 : string.length());
        boolean bl4 = string2.contains("[");
        if (!bl4) {
            if (bl3 && bl2) {
                if (string2.isEmpty()) {
                    return charSequence -> charSequence.length() == 0;
                }
                return charSequence -> charSequence.equals(string2);
            }
            if ((bl3 || bl2) && string2.isEmpty()) {
                return ALL_STRINGS_RMATCHER;
            }
            if (bl3) {
                return charSequence -> Rule.startsWith(charSequence, string2);
            }
            if (bl2) {
                return charSequence -> Rule.endsWith(charSequence, string2);
            }
        } else {
            bl4 = string2.startsWith("[");
            boolean bl5 = string2.endsWith("]");
            if (bl4 && bl5 && !(string2 = string2.substring(1, string2.length() - 1)).contains("[")) {
                bl4 = string2.startsWith("^");
                if (bl4) {
                    string2 = string2.substring(1);
                }
                boolean bl6 = bl4 = !bl4;
                if (bl3 && bl2) {
                    return charSequence -> charSequence.length() == 1 && Rule.contains(string2, charSequence.charAt(0)) == bl4;
                }
                if (bl3) {
                    return charSequence -> charSequence.length() > 0 && Rule.contains(string2, charSequence.charAt(0)) == bl4;
                }
                if (bl2) {
                    return charSequence -> {
                        if (charSequence.length() > 0) {
                            CharSequence charSequence2 = charSequence;
                            if (Rule.contains(string2, charSequence2.charAt(charSequence2.length() - 1)) == bl4) {
                                return true;
                            }
                        }
                        return false;
                    };
                }
            }
        }
        return new Rule$2(string);
    }

    private static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence2.length(); ++i2) {
            if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private static String stripQuotes(String string) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Rule(String string, String string2, String string3, Rule$PhonemeExpr rule$PhonemeExpr) {
        this.pattern = string;
        this.lContext = Rule.pattern(string2 + "$");
        this.rContext = Rule.pattern("^" + string3);
        this.phoneme = rule$PhonemeExpr;
    }

    public Rule$RPattern getLContext() {
        return this.lContext;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Rule$PhonemeExpr getPhoneme() {
        return this.phoneme;
    }

    public Rule$RPattern getRContext() {
        return this.rContext;
    }

    public boolean patternAndContextMatches(CharSequence charSequence, int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Can not match pattern at negative indexes");
        }
        int n3 = this.pattern.length();
        if ((n3 = n2 + n3) > charSequence.length()) {
            return false;
        }
        if (!charSequence.subSequence(n2, n3).equals(this.pattern)) {
            return false;
        }
        if (!this.rContext.isMatch(charSequence.subSequence(n3, charSequence.length()))) {
            return false;
        }
        return this.lContext.isMatch(charSequence.subSequence(0, n2));
    }

    private static /* synthetic */ void lambda$getInstance$3(List list, List list2) {
        list.addAll(list2);
    }

    static {
        for (NameType nameType : NameType.values()) {
            EnumMap enumMap = new EnumMap(RuleType.class);
            for (RuleType ruleType : RuleType.values()) {
                HashMap<String, Map<String, List<Rule>>> hashMap = new HashMap<String, Map<String, List<Rule>>>();
                Object object = Languages.getInstance(nameType);
                ((Languages)object).getLanguages().forEach(string -> {
                    block8: {
                        try {
                            block7: {
                                Scanner scanner = Rule.createScanner(nameType, ruleType, string);
                                try {
                                    hashMap.put((String)string, Rule.parseRules(scanner, Rule.createResourceName(nameType, ruleType, string)));
                                    if (scanner == null) break block7;
                                    scanner.close();
                                    break block8;
                                }
                                catch (Throwable throwable) {
                                    if (scanner != null) {
                                        try {
                                            scanner.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            return;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw new IllegalStateException("Problem processing " + Rule.createResourceName(nameType, ruleType, string), illegalStateException);
                        }
                    }
                });
                if (!ruleType.equals((Object)RuleType.RULES)) {
                    object = Rule.createScanner(nameType, ruleType, "common");
                    try {
                        hashMap.put("common", Rule.parseRules((Scanner)object, Rule.createResourceName(nameType, ruleType, "common")));
                    }
                    finally {
                        if (object != null) {
                            ((Scanner)object).close();
                        }
                    }
                }
                enumMap.put(ruleType, Collections.unmodifiableMap(hashMap));
            }
            RULES.put(nameType, Collections.unmodifiableMap(enumMap));
        }
    }
}

