/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.commons.codec.net.RFC1522Codec;

public class QCodec
extends RFC1522Codec
implements StringDecoder,
StringEncoder {
    private static final BitSet PRINTABLE_CHARS;
    private static final byte SPACE = 32;
    private static final byte UNDERSCORE = 95;
    private boolean encodeBlanks;

    public QCodec() {
        this(StandardCharsets.UTF_8);
    }

    public QCodec(Charset charset) {
        super(charset);
    }

    public QCodec(String string) {
        this(Charset.forName(string));
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be decoded using Q codec");
    }

    @Override
    public String decode(String string) throws DecoderException {
        try {
            return this.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DecoderException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    @Override
    protected byte[] doDecoding(byte[] byArray) throws DecoderException {
        int n2;
        if (byArray == null) {
            return null;
        }
        boolean bl2 = false;
        byte[] byArray2 = byArray;
        int n3 = byArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            byte by2 = byArray2[n2];
            if (by2 != 95) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            byArray2 = new byte[byArray.length];
            for (n3 = 0; n3 < byArray.length; ++n3) {
                n2 = byArray[n3];
                byArray2[n3] = n2 != 95 ? n2 : 32;
            }
            return QuotedPrintableCodec.decodeQuotedPrintable(byArray2);
        }
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    @Override
    protected byte[] doEncoding(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byArray = QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray);
        if (this.encodeBlanks) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] != 32) continue;
                byArray[i2] = 95;
            }
        }
        return byArray;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be encoded using Q codec");
    }

    @Override
    public String encode(String string) throws EncoderException {
        return this.encode(string, this.getCharset());
    }

    public String encode(String string, Charset charset) throws EncoderException {
        return this.encodeText(string, charset);
    }

    public String encode(String string, String string2) throws EncoderException {
        try {
            return this.encodeText(string, string2);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new EncoderException(unsupportedCharsetException.getMessage(), unsupportedCharsetException);
        }
    }

    @Override
    protected String getEncoding() {
        return "Q";
    }

    public boolean isEncodeBlanks() {
        return this.encodeBlanks;
    }

    public void setEncodeBlanks(boolean bl2) {
        this.encodeBlanks = bl2;
    }

    static {
        int n2;
        PRINTABLE_CHARS = new BitSet(256);
        PRINTABLE_CHARS.set(32);
        PRINTABLE_CHARS.set(33);
        PRINTABLE_CHARS.set(34);
        PRINTABLE_CHARS.set(35);
        PRINTABLE_CHARS.set(36);
        PRINTABLE_CHARS.set(37);
        PRINTABLE_CHARS.set(38);
        PRINTABLE_CHARS.set(39);
        PRINTABLE_CHARS.set(40);
        PRINTABLE_CHARS.set(41);
        PRINTABLE_CHARS.set(42);
        PRINTABLE_CHARS.set(43);
        PRINTABLE_CHARS.set(44);
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(47);
        for (n2 = 48; n2 <= 57; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        PRINTABLE_CHARS.set(58);
        PRINTABLE_CHARS.set(59);
        PRINTABLE_CHARS.set(60);
        PRINTABLE_CHARS.set(62);
        PRINTABLE_CHARS.set(64);
        for (n2 = 65; n2 <= 90; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        PRINTABLE_CHARS.set(91);
        PRINTABLE_CHARS.set(92);
        PRINTABLE_CHARS.set(93);
        PRINTABLE_CHARS.set(94);
        PRINTABLE_CHARS.set(96);
        for (n2 = 97; n2 <= 122; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        PRINTABLE_CHARS.set(123);
        PRINTABLE_CHARS.set(124);
        PRINTABLE_CHARS.set(125);
        PRINTABLE_CHARS.set(126);
    }
}

