/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.StringUtils;

abstract class RFC1522Codec {
    protected static final char SEP = '?';
    protected static final String POSTFIX = "?=";
    protected static final String PREFIX = "=?";
    protected final Charset charset;

    RFC1522Codec(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "charset");
    }

    protected String decodeText(String object) throws DecoderException, UnsupportedEncodingException {
        if (object == null) {
            return null;
        }
        if (!((String)object).startsWith(PREFIX) || !((String)object).endsWith(POSTFIX)) {
            throw new DecoderException("RFC 1522 violation: malformed encoded content");
        }
        int n2 = ((String)object).length() - 2;
        int n3 = ((String)object).indexOf(63, 2);
        if (n3 == n2) {
            throw new DecoderException("RFC 1522 violation: charset token not found");
        }
        String string = ((String)object).substring(2, n3);
        if (string.isEmpty()) {
            throw new DecoderException("RFC 1522 violation: charset not specified");
        }
        int n4 = n3 + 1;
        if ((n3 = ((String)object).indexOf(63, n4)) == n2) {
            throw new DecoderException("RFC 1522 violation: encoding token not found");
        }
        String string2 = ((String)object).substring(n4, n3);
        if (!this.getEncoding().equalsIgnoreCase(string2)) {
            throw new DecoderException("This codec cannot decode " + string2 + " encoded content");
        }
        n4 = n3 + 1;
        n3 = ((String)object).indexOf(63, n4);
        object = StringUtils.getBytesUsAscii(((String)object).substring(n4, n3));
        object = this.doDecoding((byte[])object);
        return new String((byte[])object, string);
    }

    protected abstract byte[] doDecoding(byte[] var1) throws DecoderException;

    protected abstract byte[] doEncoding(byte[] var1) throws EncoderException;

    protected String encodeText(String string, Charset charset) throws EncoderException {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PREFIX);
        stringBuilder.append(charset);
        stringBuilder.append('?');
        stringBuilder.append(this.getEncoding());
        stringBuilder.append('?');
        stringBuilder.append(StringUtils.newStringUsAscii(this.doEncoding(string.getBytes(charset))));
        stringBuilder.append(POSTFIX);
        return stringBuilder.toString();
    }

    protected String encodeText(String string, String string2) throws EncoderException {
        if (string == null) {
            return null;
        }
        return this.encodeText(string, Charset.forName(string2));
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    protected abstract String getEncoding();
}

