/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class Charsets {
    private static final SortedMap<String, Charset> STANDARD_CHARSET_MAP;
    @Deprecated
    public static final Charset ISO_8859_1;
    @Deprecated
    public static final Charset US_ASCII;
    @Deprecated
    public static final Charset UTF_16;
    @Deprecated
    public static final Charset UTF_16BE;
    @Deprecated
    public static final Charset UTF_16LE;
    @Deprecated
    public static final Charset UTF_8;

    public static boolean isAlias(Charset charset, String string) {
        block2: {
            block3: {
                if (string == null) break block2;
                if (charset.name().equalsIgnoreCase(string)) break block3;
                if (!charset.aliases().stream().anyMatch(string::equalsIgnoreCase)) break block2;
            }
            return true;
        }
        return false;
    }

    public static boolean isUTF8(Charset charset) {
        return Charsets.isUTF8Alias(Charsets.toCharset(charset).name());
    }

    private static boolean isUTF8Alias(String string) {
        return Charsets.isAlias(StandardCharsets.UTF_8, string);
    }

    public static SortedMap<String, Charset> requiredCharsets() {
        return STANDARD_CHARSET_MAP;
    }

    public static Charset toCharset(Charset charset) {
        if (charset == null) {
            return Charset.defaultCharset();
        }
        return charset;
    }

    public static Charset toCharset(Charset charset, Charset charset2) {
        if (charset == null) {
            return charset2;
        }
        return charset;
    }

    public static Charset toCharset(String string) throws UnsupportedCharsetException {
        return Charsets.toCharset(string, Charset.defaultCharset());
    }

    public static Charset toCharset(String string, Charset charset) throws UnsupportedCharsetException {
        if (string == null) {
            return charset;
        }
        return Charset.forName(string);
    }

    public static Charset toCharsetDefault(String string, Charset charset) {
        try {
            return Charsets.toCharset(string);
        }
        catch (RuntimeException runtimeException) {
            return Charsets.toCharset(charset);
        }
    }

    @Deprecated
    public Charsets() {
    }

    static {
        TreeMap<String, Charset> treeMap = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
        treeMap.put(StandardCharsets.ISO_8859_1.name(), StandardCharsets.ISO_8859_1);
        treeMap.put(StandardCharsets.US_ASCII.name(), StandardCharsets.US_ASCII);
        treeMap.put(StandardCharsets.UTF_16.name(), StandardCharsets.UTF_16);
        treeMap.put(StandardCharsets.UTF_16BE.name(), StandardCharsets.UTF_16BE);
        treeMap.put(StandardCharsets.UTF_16LE.name(), StandardCharsets.UTF_16LE);
        treeMap.put(StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8);
        STANDARD_CHARSET_MAP = Collections.unmodifiableSortedMap(treeMap);
        ISO_8859_1 = StandardCharsets.ISO_8859_1;
        US_ASCII = StandardCharsets.US_ASCII;
        UTF_16 = StandardCharsets.UTF_16;
        UTF_16BE = StandardCharsets.UTF_16BE;
        UTF_16LE = StandardCharsets.UTF_16LE;
        UTF_8 = StandardCharsets.UTF_8;
    }
}

