/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

final class CloseableURLConnection
extends URLConnection
implements AutoCloseable {
    private final URLConnection urlConnection;

    static CloseableURLConnection open(URI uRI) throws IOException {
        return CloseableURLConnection.open(Objects.requireNonNull(uRI, "uri").toURL());
    }

    static CloseableURLConnection open(URL uRL) throws IOException {
        return new CloseableURLConnection(uRL.openConnection());
    }

    CloseableURLConnection(URLConnection uRLConnection) {
        super(Objects.requireNonNull(uRLConnection, "urlConnection").getURL());
        this.urlConnection = uRLConnection;
    }

    @Override
    public final void addRequestProperty(String string, String string2) {
        this.urlConnection.addRequestProperty(string, string2);
    }

    @Override
    public final void close() {
        IOUtils.close(this.urlConnection);
    }

    @Override
    public final void connect() throws IOException {
        this.urlConnection.connect();
    }

    public final boolean equals(Object object) {
        return this.urlConnection.equals(object);
    }

    @Override
    public final boolean getAllowUserInteraction() {
        return this.urlConnection.getAllowUserInteraction();
    }

    @Override
    public final int getConnectTimeout() {
        return this.urlConnection.getConnectTimeout();
    }

    @Override
    public final Object getContent() throws IOException {
        return this.urlConnection.getContent();
    }

    public final Object getContent(Class[] classArray) throws IOException {
        return this.urlConnection.getContent(classArray);
    }

    @Override
    public final String getContentEncoding() {
        return this.urlConnection.getContentEncoding();
    }

    @Override
    public final int getContentLength() {
        return this.urlConnection.getContentLength();
    }

    @Override
    public final long getContentLengthLong() {
        return this.urlConnection.getContentLengthLong();
    }

    @Override
    public final String getContentType() {
        return this.urlConnection.getContentType();
    }

    @Override
    public final long getDate() {
        return this.urlConnection.getDate();
    }

    @Override
    public final boolean getDefaultUseCaches() {
        return this.urlConnection.getDefaultUseCaches();
    }

    @Override
    public final boolean getDoInput() {
        return this.urlConnection.getDoInput();
    }

    @Override
    public final boolean getDoOutput() {
        return this.urlConnection.getDoOutput();
    }

    @Override
    public final long getExpiration() {
        return this.urlConnection.getExpiration();
    }

    @Override
    public final String getHeaderField(int n2) {
        return this.urlConnection.getHeaderField(n2);
    }

    @Override
    public final String getHeaderField(String string) {
        return this.urlConnection.getHeaderField(string);
    }

    @Override
    public final long getHeaderFieldDate(String string, long l2) {
        return this.urlConnection.getHeaderFieldDate(string, l2);
    }

    @Override
    public final int getHeaderFieldInt(String string, int n2) {
        return this.urlConnection.getHeaderFieldInt(string, n2);
    }

    @Override
    public final String getHeaderFieldKey(int n2) {
        return this.urlConnection.getHeaderFieldKey(n2);
    }

    @Override
    public final long getHeaderFieldLong(String string, long l2) {
        return this.urlConnection.getHeaderFieldLong(string, l2);
    }

    @Override
    public final Map<String, List<String>> getHeaderFields() {
        return this.urlConnection.getHeaderFields();
    }

    @Override
    public final long getIfModifiedSince() {
        return this.urlConnection.getIfModifiedSince();
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return this.urlConnection.getInputStream();
    }

    @Override
    public final long getLastModified() {
        return this.urlConnection.getLastModified();
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        return this.urlConnection.getOutputStream();
    }

    @Override
    public final Permission getPermission() throws IOException {
        return this.urlConnection.getPermission();
    }

    @Override
    public final int getReadTimeout() {
        return this.urlConnection.getReadTimeout();
    }

    @Override
    public final Map<String, List<String>> getRequestProperties() {
        return this.urlConnection.getRequestProperties();
    }

    @Override
    public final String getRequestProperty(String string) {
        return this.urlConnection.getRequestProperty(string);
    }

    @Override
    public final URL getURL() {
        return this.urlConnection.getURL();
    }

    @Override
    public final boolean getUseCaches() {
        return this.urlConnection.getUseCaches();
    }

    public final int hashCode() {
        return this.urlConnection.hashCode();
    }

    @Override
    public final void setAllowUserInteraction(boolean bl2) {
        this.urlConnection.setAllowUserInteraction(bl2);
    }

    @Override
    public final void setConnectTimeout(int n2) {
        this.urlConnection.setConnectTimeout(n2);
    }

    @Override
    public final void setDefaultUseCaches(boolean bl2) {
        this.urlConnection.setDefaultUseCaches(bl2);
    }

    @Override
    public final void setDoInput(boolean bl2) {
        this.urlConnection.setDoInput(bl2);
    }

    @Override
    public final void setDoOutput(boolean bl2) {
        this.urlConnection.setDoOutput(bl2);
    }

    @Override
    public final void setIfModifiedSince(long l2) {
        this.urlConnection.setIfModifiedSince(l2);
    }

    @Override
    public final void setReadTimeout(int n2) {
        this.urlConnection.setReadTimeout(n2);
    }

    @Override
    public final void setRequestProperty(String string, String string2) {
        this.urlConnection.setRequestProperty(string, string2);
    }

    @Override
    public final void setUseCaches(boolean bl2) {
        this.urlConnection.setUseCaches(bl2);
    }

    @Override
    public final String toString() {
        return this.urlConnection.toString();
    }
}

