/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileSystem;
import org.apache.commons.io.IOCase;

public class FilenameUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EMPTY_STRING = "";
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_NAME_SEPARATOR = '/';
    private static final char WINDOWS_NAME_SEPARATOR = '\\';
    private static final char SYSTEM_NAME_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.flipSeparator(SYSTEM_NAME_SEPARATOR);
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final int IPV4_MAX_OCTET_VALUE = 255;
    private static final int IPV6_MAX_HEX_GROUPS = 8;
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int BASE_16 = 16;
    private static final Pattern REG_NAME_PART_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-]*$");

    public static String concat(String string, String string2) {
        int n2 = FilenameUtils.getPrefixLength(string2);
        if (n2 < 0) {
            return null;
        }
        if (n2 > 0) {
            return FilenameUtils.normalize(string2);
        }
        if (string == null) {
            return null;
        }
        n2 = string.length();
        if (n2 == 0) {
            return FilenameUtils.normalize(string2);
        }
        char c2 = string.charAt(n2 - 1);
        n2 = c2;
        if (FilenameUtils.isSeparator(c2)) {
            return FilenameUtils.normalize(string + string2);
        }
        return FilenameUtils.normalize(string + '/' + string2);
    }

    public static boolean directoryContains(String string, String string2) {
        if (FilenameUtils.isEmpty(string) || FilenameUtils.isEmpty(string2)) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(string, string2)) {
            return false;
        }
        char c2 = FilenameUtils.toSeparator(string.charAt(0) == '/');
        String string3 = string;
        string = string3.charAt(string3.length() - 1) == c2 ? string : string + c2;
        return IOCase.SYSTEM.checkStartsWith(string2, string);
    }

    private static String doGetFullPath(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= string.length()) {
            if (bl2) {
                return FilenameUtils.getPrefix(string);
            }
            return string;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        if (n3 < 0) {
            return string.substring(0, n2);
        }
        if (!(bl2 = n3 + (bl2 ? 1 : 0))) {
            bl2 += 1;
        }
        return string.substring(0, bl2 ? 1 : 0);
    }

    private static String doGetPath(String string, int n2) {
        if (string == null) {
            return null;
        }
        int n3 = FilenameUtils.getPrefixLength(string);
        if (n3 < 0) {
            return null;
        }
        int n4 = FilenameUtils.indexOfLastSeparator(string);
        n2 = n4 + n2;
        if (n3 >= string.length() || n4 < 0 || n3 >= n2) {
            return EMPTY_STRING;
        }
        return FilenameUtils.requireNonNullChars(string.substring(n3, n2));
    }

    private static String doNormalize(String string, char c2, boolean bl2) {
        int n2;
        if (string == null) {
            return null;
        }
        FilenameUtils.requireNonNullChars(string);
        int n3 = string.length();
        if (n3 == 0) {
            return string;
        }
        int n4 = FilenameUtils.getPrefixLength(string);
        if (n4 < 0) {
            return null;
        }
        char[] cArray = new char[n3 + 2];
        string.getChars(0, string.length(), cArray, 0);
        int n5 = FilenameUtils.flipSeparator(c2);
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] != n5) continue;
            cArray[n2] = c2;
        }
        n2 = 1;
        if (cArray[n3 - 1] != c2) {
            cArray[n3++] = c2;
            n2 = 0;
        }
        int n6 = n5 = n4 != 0 ? n4 : 1;
        while (n5 < n3) {
            if (cArray[n5] == c2 && cArray[n5 - 1] == c2) {
                System.arraycopy(cArray, n5, cArray, n5 - 1, n3 - n5);
                --n3;
                --n5;
            }
            ++n5;
        }
        for (n5 = n4 + 1; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != '.' || n5 != n4 + 1 && cArray[n5 - 2] != c2) continue;
            if (n5 == n3 - 1) {
                n2 = 1;
            }
            System.arraycopy(cArray, n5 + 1, cArray, n5 - 1, n3 - n5);
            n3 -= 2;
            --n5;
        }
        block3: for (n5 = n4 + 2; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != '.' || cArray[n5 - 2] != '.' || n5 != n4 + 2 && cArray[n5 - 3] != c2) continue;
            if (n5 == n4 + 2) {
                return null;
            }
            if (n5 == n3 - 1) {
                n2 = 1;
            }
            for (int i2 = n5 - 4; i2 >= n4; --i2) {
                if (cArray[i2] != c2) continue;
                System.arraycopy(cArray, n5 + 1, cArray, i2 + 1, n3 - n5);
                n3 -= n5 - i2;
                n5 = i2 + 1;
                continue block3;
            }
            System.arraycopy(cArray, n5 + 1, cArray, n4, n3 - n5);
            n3 -= n5 + 1 - n4;
            n5 = n4 + 1;
        }
        if (n3 <= 0) {
            return EMPTY_STRING;
        }
        if (n3 <= n4) {
            return new String(cArray, 0, n3);
        }
        if (n2 != 0 && bl2) {
            return new String(cArray, 0, n3);
        }
        return new String(cArray, 0, n3 - 1);
    }

    public static boolean equals(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SENSITIVE);
    }

    public static boolean equals(String string, String string2, boolean bl2, IOCase iOCase) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (bl2) {
            if ((string = FilenameUtils.normalize(string)) == null) {
                return false;
            }
            if ((string2 = FilenameUtils.normalize(string2)) == null) {
                return false;
            }
        }
        return IOCase.value(iOCase, IOCase.SENSITIVE).checkEquals(string, string2);
    }

    public static boolean equalsNormalized(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SYSTEM);
    }

    public static boolean equalsOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SYSTEM);
    }

    static char flipSeparator(char c2) {
        if (c2 == '/') {
            return '\\';
        }
        if (c2 == '\\') {
            return '/';
        }
        throw new IllegalArgumentException(String.valueOf(c2));
    }

    private static int getAdsCriticalOffset(String string) {
        int n2 = string.lastIndexOf(SYSTEM_NAME_SEPARATOR);
        int n3 = string.lastIndexOf(OTHER_SEPARATOR);
        if (n2 == -1) {
            if (n3 == -1) {
                return 0;
            }
            return n3 + 1;
        }
        if (n3 == -1) {
            return n2 + 1;
        }
        return Math.max(n2, n3) + 1;
    }

    public static String getBaseName(String string) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string));
    }

    public static String getExtension(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return EMPTY_STRING;
        }
        return string.substring(n2 + 1);
    }

    public static String getFullPath(String string) {
        return FilenameUtils.doGetFullPath(string, true);
    }

    public static String getFullPathNoEndSeparator(String string) {
        return FilenameUtils.doGetFullPath(string, false);
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        return FilenameUtils.requireNonNullChars(string).substring(FilenameUtils.indexOfLastSeparator(string) + 1);
    }

    public static String getPath(String string) {
        return FilenameUtils.doGetPath(string, 1);
    }

    public static String getPathNoEndSeparator(String string) {
        return FilenameUtils.doGetPath(string, 0);
    }

    public static String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 > string.length()) {
            FilenameUtils.requireNonNullChars(string);
            return string + '/';
        }
        return FilenameUtils.requireNonNullChars(string.substring(0, n2));
    }

    public static int getPrefixLength(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        int n3 = string.charAt(0);
        if (n3 == 58) {
            return -1;
        }
        if (n2 == 1) {
            if (n3 == 126) {
                return 2;
            }
            if (FilenameUtils.isSeparator((char)n3)) {
                return 1;
            }
            return 0;
        }
        if (n3 == 126) {
            int n4 = string.indexOf(47, 1);
            n3 = string.indexOf(92, 1);
            if (n4 == -1 && n3 == -1) {
                return n2 + 1;
            }
            n4 = n4 == -1 ? n3 : n4;
            n3 = n3 == -1 ? n4 : n3;
            return Math.min(n4, n3) + 1;
        }
        char c2 = string.charAt(1);
        if (c2 == ':') {
            char c3 = Character.toUpperCase((char)n3);
            n3 = c3;
            if (c3 >= 'A' && n3 <= 90) {
                if (n2 == 2 && !FileSystem.getCurrent().supportsDriveLetter()) {
                    return 0;
                }
                if (n2 == 2 || !FilenameUtils.isSeparator(string.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            if (n3 == 47) {
                return 1;
            }
            return -1;
        }
        if (!FilenameUtils.isSeparator((char)n3) || !FilenameUtils.isSeparator(c2)) {
            if (FilenameUtils.isSeparator((char)n3)) {
                return 1;
            }
            return 0;
        }
        n3 = string.indexOf(47, 2);
        n2 = string.indexOf(92, 2);
        if (n3 == -1 && n2 == -1 || n3 == 2 || n2 == 2) {
            return -1;
        }
        n3 = n3 == -1 ? n2 : n3;
        n2 = n2 == -1 ? n3 : n2;
        if (FilenameUtils.isValidHostName(string = string.substring(2, (n2 = Math.min(n3, n2) + 1) - 1))) {
            return n2;
        }
        return -1;
    }

    public static int indexOfExtension(String string) throws IllegalArgumentException {
        int n2;
        if (string == null) {
            return -1;
        }
        if (FilenameUtils.isSystemWindows() && (n2 = string.indexOf(58, FilenameUtils.getAdsCriticalOffset(string))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        n2 = string.lastIndexOf(46);
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        if (n3 > n2) {
            return -1;
        }
        return n2;
    }

    public static int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isExtension(String string, Collection<String> collection) {
        if (string == null) {
            return false;
        }
        FilenameUtils.requireNonNullChars(string);
        if (collection == null || collection.isEmpty()) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        return collection.contains(FilenameUtils.getExtension(string));
    }

    public static boolean isExtension(String string, String string2) {
        if (string == null) {
            return false;
        }
        FilenameUtils.requireNonNullChars(string);
        if (FilenameUtils.isEmpty(string2)) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        return FilenameUtils.getExtension(string).equals(string2);
    }

    public static boolean isExtension(String string, String ... stringArray) {
        if (string == null) {
            return false;
        }
        FilenameUtils.requireNonNullChars(string);
        if (stringArray == null || stringArray.length == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        string = FilenameUtils.getExtension(string);
        return Stream.of(stringArray).anyMatch(string::equals);
    }

    private static boolean isIPv4Address(String object) {
        if (!((Matcher)(object = IPV4_PATTERN.matcher((CharSequence)object))).matches() || ((Matcher)object).groupCount() != 4) {
            return false;
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            String string = ((Matcher)object).group(i2);
            int n2 = Integer.parseInt(string);
            if (n2 > 255) {
                return false;
            }
            if (string.length() <= 1 || !string.startsWith("0")) continue;
            return false;
        }
        return true;
    }

    private static boolean isIPv6Address(String string) {
        boolean bl2 = string.contains("::");
        if (bl2 && string.indexOf("::") != string.lastIndexOf("::")) {
            return false;
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(":") && !string.endsWith("::")) {
            return false;
        }
        String[] stringArray = string.split(":");
        if (bl2) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            if (string.endsWith("::")) {
                arrayList.add(EMPTY_STRING);
            } else if (string.startsWith("::") && !arrayList.isEmpty()) {
                arrayList.remove(0);
            }
            stringArray = arrayList.toArray(EMPTY_STRING_ARRAY);
        }
        if (stringArray.length > 8) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.isEmpty()) {
                if (++n3 > 1) {
                    return false;
                }
            } else {
                int n4;
                n3 = 0;
                if (i2 == stringArray.length - 1 && string2.contains(".")) {
                    if (!FilenameUtils.isIPv4Address(string2)) {
                        return false;
                    }
                    n2 += 2;
                    continue;
                }
                if (string2.length() > 4) {
                    return false;
                }
                try {
                    n4 = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (n4 < 0 || n4 > 65535) {
                    return false;
                }
            }
            ++n2;
        }
        return n2 <= 8 && (n2 >= 8 || bl2);
    }

    private static boolean isRFC3986HostName(String stringArray) {
        stringArray = stringArray.split("\\.", -1);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].isEmpty()) {
                return i2 == stringArray.length - 1;
            }
            if (REG_NAME_PART_PATTERN.matcher(stringArray[i2]).matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    static boolean isSystemWindows() {
        return SYSTEM_NAME_SEPARATOR == '\\';
    }

    private static boolean isValidHostName(String string) {
        return FilenameUtils.isIPv6Address(string) || FilenameUtils.isRFC3986HostName(string);
    }

    public static String normalize(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_NAME_SEPARATOR, true);
    }

    public static String normalize(String string, boolean bl2) {
        return FilenameUtils.doNormalize(string, FilenameUtils.toSeparator(bl2), true);
    }

    public static String normalizeNoEndSeparator(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_NAME_SEPARATOR, false);
    }

    public static String normalizeNoEndSeparator(String string, boolean bl2) {
        return FilenameUtils.doNormalize(string, FilenameUtils.toSeparator(bl2), false);
    }

    public static String removeExtension(String string) {
        if (string == null) {
            return null;
        }
        FilenameUtils.requireNonNullChars(string);
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    private static String requireNonNullChars(String string) {
        if (string.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Null character present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
        return string;
    }

    public static String separatorsToSystem(String string) {
        return FileSystem.getCurrent().normalizeSeparators(string);
    }

    public static String separatorsToUnix(String string) {
        return FileSystem.LINUX.normalizeSeparators(string);
    }

    public static String separatorsToWindows(String string) {
        return FileSystem.WINDOWS.normalizeSeparators(string);
    }

    static String[] splitOnTokens(String object) {
        if (((String)object).indexOf(63) == -1 && ((String)object).indexOf(42) == -1) {
            return new String[]{object};
        }
        object = ((String)object).toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = 0;
        for (Object object3 : object) {
            if (object3 == 63 || object3 == 42) {
                if (stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                if (object3 == 63) {
                    arrayList.add("?");
                } else if (object2 != 42) {
                    arrayList.add("*");
                }
            } else {
                stringBuilder.append((char)object3);
            }
            object2 = object3;
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    private static char toSeparator(boolean bl2) {
        if (bl2) {
            return '/';
        }
        return '\\';
    }

    public static boolean wildcardMatch(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SENSITIVE);
    }

    public static boolean wildcardMatch(String string, String stringArray, IOCase iOCase) {
        if (string == null && stringArray == null) {
            return true;
        }
        if (string == null || stringArray == null) {
            return false;
        }
        iOCase = IOCase.value(iOCase, IOCase.SENSITIVE);
        stringArray = FilenameUtils.splitOnTokens((String)stringArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayDeque<int[]> arrayDeque = new ArrayDeque<int[]>(stringArray.length);
        do {
            if (!arrayDeque.isEmpty()) {
                int[] nArray = (int[])arrayDeque.pop();
                n4 = nArray[0];
                n3 = nArray[1];
                n2 = 1;
            }
            while (n4 < stringArray.length) {
                if (stringArray[n4].equals("?")) {
                    if (++n3 > string.length()) break;
                    n2 = 0;
                } else if (stringArray[n4].equals("*")) {
                    n2 = 1;
                    if (n4 == stringArray.length - 1) {
                        n3 = string.length();
                    }
                } else {
                    if (n2 != 0) {
                        if ((n3 = iOCase.checkIndexOf(string, n3, stringArray[n4])) == -1) break;
                        n2 = iOCase.checkIndexOf(string, n3 + 1, stringArray[n4]);
                        if (n2 >= 0) {
                            arrayDeque.push(new int[]{n4, n2});
                        }
                    } else if (!iOCase.checkRegionMatches(string, n3, stringArray[n4])) break;
                    n3 += stringArray[n4].length();
                    n2 = 0;
                }
                ++n4;
            }
            if (n4 != stringArray.length || n3 != string.length()) continue;
            return true;
        } while (!arrayDeque.isEmpty());
        return false;
    }

    public static boolean wildcardMatchOnSystem(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SYSTEM);
    }

    @Deprecated
    public FilenameUtils() {
    }
}

