/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.CloseableURLConnection;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.channels.FileChannels;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;
import org.apache.commons.io.output.AppendableWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public class IOUtils {
    public static final int CR = 13;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int EOF = -1;
    public static final int LF = 10;
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal<char[]> SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static BufferedInputStream buffer(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream);
    }

    public static BufferedInputStream buffer(InputStream inputStream, int n2) {
        Objects.requireNonNull(inputStream, "inputStream");
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream, n2);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        if (outputStream instanceof BufferedOutputStream) {
            return (BufferedOutputStream)outputStream;
        }
        return new BufferedOutputStream(outputStream);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream, int n2) {
        Objects.requireNonNull(outputStream, "outputStream");
        if (outputStream instanceof BufferedOutputStream) {
            return (BufferedOutputStream)outputStream;
        }
        return new BufferedOutputStream(outputStream, n2);
    }

    public static BufferedReader buffer(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static BufferedReader buffer(Reader reader, int n2) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader, n2);
    }

    public static BufferedWriter buffer(Writer writer) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer);
    }

    public static BufferedWriter buffer(Writer writer, int n2) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer, n2);
    }

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int n2) {
        return new byte[n2];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int n2) {
        return new char[n2];
    }

    static void clear() {
        SCRATCH_BYTE_BUFFER_RW.remove();
        SCRATCH_CHAR_BUFFER_RW.remove();
        Arrays.fill(SCRATCH_BYTE_BUFFER_WO, (byte)0);
        Arrays.fill(SCRATCH_CHAR_BUFFER_WO, '\u0000');
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(Closeable ... closeableArray) throws IOExceptionList {
        IOConsumer.forAll(IOUtils::close, closeableArray);
    }

    public static void close(Closeable closeable, IOConsumer<IOException> iOConsumer) throws IOException {
        block5: {
            if (closeable != null) {
                try {
                    closeable.close();
                    return;
                }
                catch (IOException iOException) {
                    if (iOConsumer != null) {
                        iOConsumer.accept(iOException);
                    }
                    return;
                }
                catch (Exception exception) {
                    if (iOConsumer == null) break block5;
                    iOConsumer.accept(new IOException(exception));
                }
            }
        }
    }

    public static void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    private static void closeQ(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray != null) {
            IOUtils.closeQuietly(Arrays.stream(closeableArray));
        }
    }

    public static void closeQuietly(Closeable closeable, Consumer<Exception> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                    return;
                }
                catch (Exception exception) {
                    if (consumer == null) break block3;
                    consumer.accept(exception);
                }
            }
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQ(inputStream);
    }

    public static void closeQuietly(Iterable<Closeable> iterable) {
        if (iterable != null) {
            iterable.forEach(IOUtils::closeQuietly);
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQ(outputStream);
    }

    public static void closeQuietly(Reader reader) {
        IOUtils.closeQ(reader);
    }

    public static void closeQuietly(Selector selector) {
        IOUtils.closeQ(selector);
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        IOUtils.closeQ(serverSocket);
    }

    public static void closeQuietly(Socket socket) {
        IOUtils.closeQ(socket);
    }

    public static void closeQuietly(Stream<Closeable> stream) {
        if (stream != null) {
            stream.forEach(IOUtils::closeQuietly);
        }
    }

    public static void closeQuietly(Writer writer) {
        IOUtils.closeQ(writer);
    }

    public static long consume(InputStream inputStream) throws IOException {
        return IOUtils.copyLarge(inputStream, NullOutputStream.INSTANCE);
    }

    public static long consume(Reader reader) throws IOException {
        return IOUtils.copyLarge(reader, NullWriter.INSTANCE);
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        if (inputStream == inputStream2) {
            return true;
        }
        if (inputStream == null || inputStream2 == null) {
            return false;
        }
        return FileChannels.contentEquals(Channels.newChannel(inputStream), Channels.newChannel(inputStream2), 8192);
    }

    private static boolean contentEquals(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static boolean contentEquals(Reader reader, Reader reader2) throws IOException {
        if (reader == reader2) {
            return true;
        }
        if (reader == null || reader2 == null) {
            return false;
        }
        char[] cArray = IOUtils.getScratchCharArray();
        char[] cArray2 = IOUtils.charArray();
        block0: while (true) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                int n5;
                if (n4 >= 8192) continue block0;
                if (n2 == n4) {
                    while ((n5 = reader.read(cArray, n2, 8192 - n2)) == 0) {
                    }
                    if (n5 == -1) {
                        return n3 == n4 && reader2.read() == -1;
                    }
                    n2 += n5;
                }
                if (n3 == n4) {
                    while ((n5 = reader2.read(cArray2, n3, 8192 - n3)) == 0) {
                    }
                    if (n5 == -1) {
                        return n2 == n4 && reader.read() == -1;
                    }
                    n3 += n5;
                }
                if (cArray[n4] != cArray2[n4]) {
                    return false;
                }
                ++n4;
            }
            break;
        }
    }

    private static boolean contentEquals(Stream<?> stream, Stream<?> stream2) {
        if (stream == stream2) {
            return true;
        }
        if (stream == null || stream2 == null) {
            return false;
        }
        return IOUtils.contentEquals(stream.iterator(), stream2.iterator());
    }

    private static boolean contentEqualsIgnoreEOL(BufferedReader bufferedReader, BufferedReader bufferedReader2) {
        if (bufferedReader == bufferedReader2) {
            return true;
        }
        if (bufferedReader == null || bufferedReader2 == null) {
            return false;
        }
        return IOUtils.contentEquals(bufferedReader.lines(), bufferedReader2.lines());
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) throws UncheckedIOException {
        if (reader == reader2) {
            return true;
        }
        if (reader == null || reader2 == null) {
            return false;
        }
        return IOUtils.contentEqualsIgnoreEOL(IOUtils.toBufferedReader(reader), IOUtils.toBufferedReader(reader2));
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(n2));
    }

    @Deprecated
    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        IOUtils.copy(inputStream, writer, Charset.defaultCharset());
    }

    public static void copy(InputStream inputStream, Writer writer, Charset charset) throws IOException {
        IOUtils.copy((Reader)new InputStreamReader(inputStream, Charsets.toCharset(charset)), writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        IOUtils.copy(inputStream, writer, Charsets.toCharset(string));
    }

    public static QueueInputStream copy(java.io.ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        Objects.requireNonNull(byteArrayOutputStream, "outputStream");
        QueueInputStream queueInputStream = new QueueInputStream();
        byteArrayOutputStream.writeTo(queueInputStream.newQueueOutputStream());
        return queueInputStream;
    }

    public static long copy(Reader reader, Appendable appendable) throws IOException {
        return IOUtils.copy(reader, appendable, CharBuffer.allocate(8192));
    }

    public static long copy(Reader reader, Appendable appendable, CharBuffer charBuffer) throws IOException {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(charBuffer))) {
            charBuffer.flip();
            appendable.append(charBuffer, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    @Deprecated
    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        IOUtils.copy(reader, outputStream, Charset.defaultCharset());
    }

    public static void copy(Reader reader, OutputStream closeable, Charset charset) throws IOException {
        closeable = new OutputStreamWriter((OutputStream)closeable, Charsets.toCharset(charset));
        IOUtils.copy(reader, (Writer)closeable);
        ((OutputStreamWriter)closeable).flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) throws IOException {
        IOUtils.copy(reader, outputStream, Charsets.toCharset(string));
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copy(URL uRL, File object) throws IOException {
        object = Files.newOutputStream(Objects.requireNonNull(object, "file").toPath(), new OpenOption[0]);
        try {
            long l2 = IOUtils.copy(uRL, (OutputStream)object);
            return l2;
        }
        finally {
            if (object != null) {
                ((OutputStream)object).close();
            }
        }
    }

    public static long copy(URL object, OutputStream outputStream) throws IOException {
        object = Objects.requireNonNull(object, "url").openStream();
        try {
            long l2 = IOUtils.copyLarge((InputStream)object, outputStream);
            return l2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, l2, l3, IOUtils.getScratchByteArray());
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) throws IOException {
        int n2;
        int n3;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n4 = n3 = byArray.length;
        if (l3 > 0L && l3 < (long)n3) {
            n4 = (int)l3;
        }
        long l4 = 0L;
        while (n4 > 0 && -1 != (n2 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n4 = (int)Math.min(l3 - l4, (long)n3);
        }
        return l4;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        return IOUtils.copyLarge(reader, writer, IOUtils.getScratchCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) throws IOException {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3) throws IOException {
        return IOUtils.copyLarge(reader, writer, l2, l3, IOUtils.getScratchCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3, char[] cArray) throws IOException {
        int n2;
        if (l2 > 0L) {
            IOUtils.skipFully(reader, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n3 = cArray.length;
        if (l3 > 0L && l3 < (long)cArray.length) {
            n3 = (int)l3;
        }
        long l4 = 0L;
        while (n3 > 0 && -1 != (n2 = reader.read(cArray, 0, n3))) {
            writer.write(cArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n3 = (int)Math.min(l3 - l4, (long)cArray.length);
        }
        return l4;
    }

    private static byte[] fill0(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        return byArray;
    }

    private static char[] fill0(char[] cArray) {
        Arrays.fill(cArray, '\u0000');
        return cArray;
    }

    static byte[] getScratchByteArray() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_RW.get());
    }

    static byte[] getScratchByteArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_WO);
    }

    static char[] getScratchCharArray() {
        return IOUtils.fill0(SCRATCH_CHAR_BUFFER_RW.get());
    }

    static char[] getScratchCharArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_CHAR_BUFFER_WO);
    }

    public static int length(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        return byArray.length;
    }

    public static int length(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        return cArray.length;
    }

    public static int length(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        return charSequence.length();
    }

    public static int length(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        return objectArray.length;
    }

    public static LineIterator lineIterator(InputStream inputStream, Charset charset) {
        return new LineIterator(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static LineIterator lineIterator(InputStream inputStream, String string) {
        return IOUtils.lineIterator(inputStream, Charsets.toCharset(string));
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        return IOUtils.read(inputStream::read, byArray, n2, n3);
    }

    static int read(IOTriFunction<byte[], Integer, Integer, Integer> iOTriFunction, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n4 = n3; n4 > 0; n4 -= n5) {
            n5 = n3 - n4;
            if (-1 == (n5 = iOTriFunction.apply(byArray, n2 + n5, n4).intValue())) break;
        }
        return n3 - n4;
    }

    public static int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n2;
        int n3 = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && -1 != (n2 = readableByteChannel.read(byteBuffer))) {
        }
        return n3 - byteBuffer.remaining();
    }

    public static int read(Reader reader, char[] cArray) throws IOException {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static int read(Reader reader, char[] cArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n4 = n3; n4 > 0; n4 -= n5) {
            n5 = n3 - n4;
            if (-1 == (n5 = reader.read(cArray, n2 + n5, n4))) break;
        }
        return n3 - n4;
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = IOUtils.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static byte[] readFully(InputStream inputStream, int n2) throws IOException {
        byte[] byArray = IOUtils.byteArray(n2);
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
        return byArray;
    }

    public static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        int n3 = IOUtils.read(readableByteChannel, byteBuffer);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    public static void readFully(Reader reader, char[] cArray) throws IOException {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static void readFully(Reader reader, char[] cArray, int n2, int n3) throws IOException {
        int n4 = IOUtils.read(reader, cArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static List<String> readLines(CharSequence object) throws UncheckedIOException {
        object = new CharSequenceReader((CharSequence)object);
        try {
            List<String> list = IOUtils.readLines((Reader)object);
            return list;
        }
        finally {
            ((CharSequenceReader)object).close();
        }
    }

    @Deprecated
    public static List<String> readLines(InputStream inputStream) throws UncheckedIOException {
        return IOUtils.readLines(inputStream, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) throws UncheckedIOException {
        return IOUtils.readLines(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static List<String> readLines(InputStream inputStream, String string) throws UncheckedIOException {
        return IOUtils.readLines(inputStream, Charsets.toCharset(string));
    }

    public static List<String> readLines(Reader reader) throws UncheckedIOException {
        return IOUtils.toBufferedReader(reader).lines().collect(Collectors.toList());
    }

    public static byte[] resourceToByteArray(String string) throws IOException {
        return IOUtils.resourceToByteArray(string, null);
    }

    public static byte[] resourceToByteArray(String string, ClassLoader classLoader) throws IOException {
        return IOUtils.toByteArray(IOUtils.resourceToURL(string, classLoader));
    }

    public static String resourceToString(String string, Charset charset) throws IOException {
        return IOUtils.resourceToString(string, charset, null);
    }

    public static String resourceToString(String string, Charset charset, ClassLoader classLoader) throws IOException {
        return IOUtils.toString(IOUtils.resourceToURL(string, classLoader), charset);
    }

    public static URL resourceToURL(String string) throws IOException {
        return IOUtils.resourceToURL(string, null);
    }

    public static URL resourceToURL(String string, ClassLoader object) throws IOException {
        if ((object = object == null ? IOUtils.class.getResource(string) : ((ClassLoader)object).getResource(string)) == null) {
            throw new IOException("Resource not found: " + string);
        }
        return object;
    }

    public static long skip(InputStream inputStream, long l2) throws IOException {
        return IOUtils.skip(inputStream, l2, IOUtils::getScratchByteArrayWriteOnly);
    }

    public static long skip(InputStream inputStream, long l2, Supplier<byte[]> supplier) throws IOException {
        byte[] byArray;
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(byArray = supplier.get(), 0, (int)Math.min(l3, (long)byArray.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static long skip(ReadableByteChannel readableByteChannel, long l2) throws IOException {
        long l3;
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(l2, 8192L));
        for (l3 = l2; l3 > 0L; l3 -= (long)n2) {
            byteBuffer.position(0);
            byteBuffer.limit((int)Math.min(l3, 8192L));
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 == -1) break;
        }
        return l2 - l3;
    }

    public static long skip(Reader reader, long l2) throws IOException {
        char[] cArray;
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)reader.read(cArray = IOUtils.getScratchCharArrayWriteOnly(), 0, (int)Math.min(l3, (long)cArray.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        long l3 = IOUtils.skip(inputStream, l2, IOUtils::getScratchByteArrayWriteOnly);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(InputStream inputStream, long l2, Supplier<byte[]> supplier) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(inputStream, l2, supplier);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(ReadableByteChannel readableByteChannel, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(readableByteChannel, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(Reader reader, long l2) throws IOException {
        long l3 = IOUtils.skip(reader, l2);
        if (l3 != l2) {
            throw new EOFException("Chars to skip: " + l2 + " actual: " + l3);
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, n2);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static BufferedReader toBufferedReader(Reader reader, int n2) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader, n2);
    }

    public static byte[] toByteArray(InputStream object) throws IOException {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = UnsynchronizedByteArrayOutputStream.builder().get();){
            try (ThresholdingOutputStream thresholdingOutputStream2 = new ThresholdingOutputStream(Integer.MAX_VALUE, thresholdingOutputStream -> {
                throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", Integer.MAX_VALUE));
            }, thresholdingOutputStream -> unsynchronizedByteArrayOutputStream);){
                IOUtils.copy((InputStream)object, (OutputStream)thresholdingOutputStream2);
                object = ((AbstractByteArrayOutputStream)unsynchronizedByteArrayOutputStream).toByteArray();
            }
            return object;
        }
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) throws IOException {
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return IOUtils.toByteArray(Objects.requireNonNull(inputStream, "input")::read, n2);
    }

    public static byte[] toByteArray(InputStream inputStream, long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + l2);
        }
        return IOUtils.toByteArray(inputStream, (int)l2);
    }

    static byte[] toByteArray(IOTriFunction<byte[], Integer, Integer, Integer> iOTriFunction, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + n2);
        }
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = IOUtils.byteArray(n2);
        for (n3 = 0; n3 < n2 && (n4 = iOTriFunction.apply(byArray, n3, n2 - n3).intValue()) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Unexpected read size, current: " + n3 + ", expected: " + n2);
        }
        return byArray;
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader) throws IOException {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader object, Charset charset) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            IOUtils.copy((Reader)object, (OutputStream)byteArrayOutputStream, charset);
            object = ((AbstractByteArrayOutputStream)byteArrayOutputStream).toByteArray();
            return object;
        }
    }

    public static byte[] toByteArray(Reader reader, String string) throws IOException {
        return IOUtils.toByteArray(reader, Charsets.toCharset(string));
    }

    @Deprecated
    public static byte[] toByteArray(String string) {
        return string.getBytes(Charset.defaultCharset());
    }

    public static byte[] toByteArray(URI uRI) throws IOException {
        return IOUtils.toByteArray(uRI.toURL());
    }

    public static byte[] toByteArray(URL object) throws IOException {
        object = CloseableURLConnection.open((URL)object);
        try {
            byte[] byArray = IOUtils.toByteArray((URLConnection)object);
            return byArray;
        }
        finally {
            if (object != null) {
                ((CloseableURLConnection)object).close();
            }
        }
    }

    public static byte[] toByteArray(URLConnection object) throws IOException {
        object = ((URLConnection)object).getInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)object);
            return byArray;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    @Deprecated
    public static char[] toCharArray(InputStream inputStream) throws IOException {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream inputStream, Charset charset) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter, charset);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) throws IOException {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(string));
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    @Deprecated
    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence charSequence, Charset charset) {
        return IOUtils.toInputStream(charSequence.toString(), charset);
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtils.toInputStream(charSequence, Charsets.toCharset(string));
    }

    @Deprecated
    public static InputStream toInputStream(String string) {
        return IOUtils.toInputStream(string, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(charset)));
    }

    public static InputStream toInputStream(String string, String string2) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(string2)));
    }

    @Deprecated
    public static String toString(byte[] byArray) {
        return new String(byArray, Charset.defaultCharset());
    }

    public static String toString(byte[] byArray, String string) {
        return new String(byArray, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(InputStream inputStream) throws IOException {
        return IOUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static String toString(InputStream object, Charset charset) throws IOException {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy((InputStream)object, (Writer)stringBuilderWriter, charset);
            object = stringBuilderWriter.toString();
            return object;
        }
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        return IOUtils.toString(inputStream, Charsets.toCharset(string));
    }

    public static String toString(IOSupplier<InputStream> iOSupplier, Charset charset) throws IOException {
        return IOUtils.toString(iOSupplier, charset, () -> {
            throw new NullPointerException("input");
        });
    }

    public static String toString(IOSupplier<InputStream> object, Charset object2, IOSupplier<String> iOSupplier) throws IOException {
        if (object == null) {
            return iOSupplier.get();
        }
        object = object.get();
        try {
            object2 = object != null ? IOUtils.toString((InputStream)object, (Charset)object2) : iOSupplier.get();
            return object2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public static String toString(Reader object) throws IOException {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy((Reader)object, (Writer)stringBuilderWriter);
            object = stringBuilderWriter.toString();
            return object;
        }
    }

    @Deprecated
    public static String toString(URI uRI) throws IOException {
        return IOUtils.toString(uRI, Charset.defaultCharset());
    }

    public static String toString(URI uRI, Charset charset) throws IOException {
        return IOUtils.toString(uRI.toURL(), Charsets.toCharset(charset));
    }

    public static String toString(URI uRI, String string) throws IOException {
        return IOUtils.toString(uRI, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(URL uRL) throws IOException {
        return IOUtils.toString(uRL, Charset.defaultCharset());
    }

    public static String toString(URL uRL, Charset charset) throws IOException {
        return IOUtils.toString(uRL::openStream, charset);
    }

    public static String toString(URL uRL, String string) throws IOException {
        return IOUtils.toString(uRL, Charsets.toCharset(string));
    }

    public static void write(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    @Deprecated
    public static void write(byte[] byArray, Writer writer) throws IOException {
        IOUtils.write(byArray, writer, Charset.defaultCharset());
    }

    public static void write(byte[] byArray, Writer writer, Charset charset) throws IOException {
        if (byArray != null) {
            writer.write(new String(byArray, Charsets.toCharset(charset)));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) throws IOException {
        IOUtils.write(byArray, writer, Charsets.toCharset(string));
    }

    @Deprecated
    public static void write(char[] cArray, OutputStream outputStream) throws IOException {
        IOUtils.write(cArray, outputStream, Charset.defaultCharset());
    }

    public static void write(char[] cArray, OutputStream outputStream, Charset charset) throws IOException {
        if (cArray != null) {
            IOUtils.write(new String(cArray), outputStream, charset);
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) throws IOException {
        IOUtils.write(cArray, outputStream, Charsets.toCharset(string));
    }

    public static void write(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    @Deprecated
    public static void write(CharSequence charSequence, OutputStream outputStream) throws IOException {
        IOUtils.write(charSequence, outputStream, Charset.defaultCharset());
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, Charset charset) throws IOException {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), outputStream, charset);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) throws IOException {
        IOUtils.write(charSequence, outputStream, Charsets.toCharset(string));
    }

    public static void write(CharSequence charSequence, Writer writer) throws IOException {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), writer);
        }
    }

    @Deprecated
    public static void write(String string, OutputStream outputStream) throws IOException {
        IOUtils.write(string, outputStream, Charset.defaultCharset());
    }

    public static void write(String string, OutputStream outputStream, Charset charset) throws IOException {
        if (string != null) {
            Channels.newChannel(outputStream).write(Charsets.toCharset(charset).encode(string));
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) throws IOException {
        IOUtils.write(string, outputStream, Charsets.toCharset(string2));
    }

    public static void write(String string, Writer writer) throws IOException {
        if (string != null) {
            writer.write(string);
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream) throws IOException {
        IOUtils.write(stringBuffer, outputStream, null);
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) throws IOException {
        if (stringBuffer != null) {
            IOUtils.write(stringBuffer.toString(), outputStream, Charsets.toCharset(string));
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, Writer writer) throws IOException {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void writeChunked(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            int n2 = byArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 8192);
                outputStream.write(byArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    public static void writeChunked(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            int n2 = cArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 8192);
                writer.write(cArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    @Deprecated
    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream) throws IOException {
        IOUtils.writeLines(collection, string, outputStream, Charset.defaultCharset());
    }

    public static void writeLines(Collection<?> object, String object2, OutputStream outputStream, Charset charset) throws IOException {
        if (object == null) {
            return;
        }
        if (object2 == null) {
            object2 = System.lineSeparator();
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            charset = StandardCharsets.UTF_16BE;
        }
        object2 = ((String)object2).getBytes(charset);
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) {
                IOUtils.write(e2.toString(), outputStream, charset);
            }
            outputStream.write((byte[])object2);
        }
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, String string2) throws IOException {
        IOUtils.writeLines(collection, string, outputStream, Charsets.toCharset(string2));
    }

    public static void writeLines(Collection<?> object, String string, Writer writer) throws IOException {
        if (object == null) {
            return;
        }
        if (string == null) {
            string = System.lineSeparator();
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) {
                writer.write(e2.toString());
            }
            writer.write(string);
        }
    }

    public static Writer writer(Appendable appendable) {
        Objects.requireNonNull(appendable, "appendable");
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        if (appendable instanceof StringBuilder) {
            return new StringBuilderWriter((StringBuilder)appendable);
        }
        return new AppendableWriter<Appendable>(appendable);
    }

    @Deprecated
    public IOUtils() {
    }
}

