/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.channels.FileChannels;

public class RandomAccessFiles {
    public static boolean contentEquals(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException {
        long l2;
        if (Objects.equals(randomAccessFile, randomAccessFile2)) {
            return true;
        }
        long l3 = RandomAccessFiles.length(randomAccessFile);
        if (l3 != (l2 = RandomAccessFiles.length(randomAccessFile2))) {
            return false;
        }
        if (l3 == 0L && l2 == 0L) {
            return true;
        }
        return FileChannels.contentEquals((SeekableByteChannel)randomAccessFile.getChannel(), (SeekableByteChannel)randomAccessFile2.getChannel(), 8192);
    }

    private static long length(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile != null) {
            return randomAccessFile.length();
        }
        return 0L;
    }

    public static byte[] read(RandomAccessFile randomAccessFile, long l2, int n2) throws IOException {
        randomAccessFile.seek(l2);
        return IOUtils.toByteArray(randomAccessFile::read, n2);
    }

    public static RandomAccessFile reset(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        return randomAccessFile;
    }

    @Deprecated
    public RandomAccessFiles() {
    }
}

