/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class StreamIterator<E>
implements AutoCloseable,
Iterator<E> {
    private final Iterator<E> iterator;
    private final Stream<E> stream;
    private boolean closed;

    public static <T> StreamIterator<T> iterator(Stream<T> stream) {
        return new StreamIterator<T>(stream);
    }

    private StreamIterator(Stream<E> stream) {
        this.stream = Objects.requireNonNull(stream, "stream");
        this.iterator = stream.iterator();
    }

    @Override
    public final void close() {
        this.closed = true;
        this.stream.close();
    }

    @Override
    public final boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean bl2 = this.iterator.hasNext();
        if (!bl2) {
            this.close();
        }
        return bl2;
    }

    @Override
    public final E next() {
        E e2 = this.iterator.next();
        if (e2 == null) {
            this.close();
        }
        return e2;
    }
}

