/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.time.Duration;
import org.apache.commons.io.ThreadUtils;

final class ThreadMonitor
implements Runnable {
    private final Thread thread;
    private final Duration timeout;

    static Thread start(Duration duration) {
        return ThreadMonitor.start(Thread.currentThread(), duration);
    }

    static Thread start(Thread thread, Duration duration) {
        if (duration.isZero() || duration.isNegative()) {
            return null;
        }
        thread = new Thread((Runnable)new ThreadMonitor(thread, duration), ThreadMonitor.class.getSimpleName());
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    static void stop(Thread thread) {
        if (thread != null) {
            thread.interrupt();
        }
    }

    private ThreadMonitor(Thread thread, Duration duration) {
        this.thread = thread;
        this.timeout = duration;
    }

    @Override
    public final void run() {
        try {
            ThreadUtils.sleep(this.timeout);
            this.thread.interrupt();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

