/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.time.Duration;
import java.time.Instant;

public final class ThreadUtils {
    private static int getNanosOfMilli(Duration duration) {
        return duration.getNano() % 1000000;
    }

    public static void sleep(Duration duration) throws InterruptedException {
        try {
            long l2;
            long l3 = System.nanoTime();
            long l4 = l3 + duration.toNanos();
            Duration duration2 = duration;
            do {
                Thread.sleep(duration2.toMillis(), ThreadUtils.getNanosOfMilli(duration2));
                l2 = System.nanoTime();
                duration2 = Duration.ofNanos(l4 - l2);
            } while (l2 - l4 < 0L);
            return;
        }
        catch (ArithmeticException arithmeticException) {
            Instant instant = Instant.now().plus(duration);
            Duration duration3 = duration;
            do {
                Thread.sleep(duration3.toMillis(), ThreadUtils.getNanosOfMilli(duration3));
            } while (!(duration3 = Duration.between(Instant.now(), instant)).isNegative());
            return;
        }
    }

    @Deprecated
    public ThreadUtils() {
    }
}

