/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.input.BufferedFileChannelInputStream;
import org.apache.commons.io.output.RandomAccessFileOutputStream;
import org.apache.commons.io.output.RandomAccessFileOutputStream$Builder;

public abstract class AbstractOrigin$AbstractRandomAccessFileOrigin<T extends RandomAccessFile, B extends AbstractOrigin$AbstractRandomAccessFileOrigin<T, B>>
extends AbstractOrigin<T, B> {
    public AbstractOrigin$AbstractRandomAccessFileOrigin(T t2) {
        super(t2);
    }

    @Override
    public byte[] getByteArray() throws IOException {
        long l2 = ((RandomAccessFile)this.origin).length();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("Origin too large.");
        }
        return RandomAccessFiles.read((RandomAccessFile)this.origin, 0L, (int)l2);
    }

    @Override
    public byte[] getByteArray(long l2, int n2) throws IOException {
        return RandomAccessFiles.read((RandomAccessFile)this.origin, l2, n2);
    }

    @Override
    public CharSequence getCharSequence(Charset charset) throws IOException {
        return new String(((AbstractOrigin)this).getByteArray(), charset);
    }

    @Override
    public InputStream getInputStream(OpenOption ... openOptionArray) throws IOException {
        return BufferedFileChannelInputStream.builder().setFileChannel(((RandomAccessFile)this.origin).getChannel()).get();
    }

    @Override
    public OutputStream getOutputStream(OpenOption ... openOptionArray) throws IOException {
        return ((RandomAccessFileOutputStream$Builder)RandomAccessFileOutputStream.builder().setRandomAccessFile((RandomAccessFile)this.origin)).get();
    }

    public T getRandomAccessFile(OpenOption ... openOptionArray) {
        return (T)((RandomAccessFile)this.get());
    }

    @Override
    public Reader getReader(Charset charset) throws IOException {
        return new InputStreamReader(((AbstractOrigin)this).getInputStream(new OpenOption[0]), Charsets.toCharset(charset));
    }

    @Override
    public Writer getWriter(Charset charset, OpenOption ... openOptionArray) throws IOException {
        return new OutputStreamWriter(((AbstractOrigin)this).getOutputStream(openOptionArray), Charsets.toCharset(charset));
    }

    @Override
    public long size() throws IOException {
        return ((RandomAccessFile)this.origin).length();
    }
}

