/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;

public final class FileChannels {
    @Deprecated
    public static boolean contentEquals(FileChannel fileChannel, FileChannel fileChannel2, int n2) throws IOException {
        return FileChannels.contentEquals((SeekableByteChannel)fileChannel, (SeekableByteChannel)fileChannel2, n2);
    }

    public static boolean contentEquals(ReadableByteChannel readableByteChannel, ReadableByteChannel readableByteChannel2, int n2) throws IOException {
        if (Objects.equals(readableByteChannel, readableByteChannel2)) {
            return true;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n2);
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (true) {
            if (!bl3) {
                n3 = FileChannels.readToLimit(readableByteChannel, byteBuffer);
                byteBuffer.clear();
                boolean bl4 = bl2 = n3 == 0;
            }
            if (!bl2) {
                n4 = FileChannels.readToLimit(readableByteChannel2, byteBuffer2);
                byteBuffer2.clear();
                boolean bl5 = bl3 = n4 == 0;
            }
            if (n3 == -1 && n4 == -1) {
                return byteBuffer.equals(byteBuffer2);
            }
            if (n3 == 0 || n4 == 0) {
                Thread.yield();
                continue;
            }
            if (n3 != n4) {
                return false;
            }
            if (!byteBuffer.equals(byteBuffer2)) break;
        }
        return false;
    }

    public static boolean contentEquals(SeekableByteChannel seekableByteChannel, SeekableByteChannel seekableByteChannel2, int n2) throws IOException {
        long l2;
        if (Objects.equals(seekableByteChannel, seekableByteChannel2)) {
            return true;
        }
        long l3 = FileChannels.size(seekableByteChannel);
        if (l3 != (l2 = FileChannels.size(seekableByteChannel2))) {
            return false;
        }
        return l3 == 0L && l2 == 0L || FileChannels.contentEquals((ReadableByteChannel)seekableByteChannel, (ReadableByteChannel)seekableByteChannel2, n2);
    }

    private static int readToLimit(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n2;
        if (!byteBuffer.hasRemaining()) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        while (byteBuffer.hasRemaining() && (n2 = readableByteChannel.read(byteBuffer)) != -1) {
            if (n2 == 0) {
                Thread.yield();
                continue;
            }
            n3 += n2;
        }
        if (n3 != 0) {
            return n3;
        }
        return -1;
    }

    private static long size(SeekableByteChannel seekableByteChannel) throws IOException {
        if (seekableByteChannel != null) {
            return seekableByteChannel.size();
        }
        return 0L;
    }

    private FileChannels() {
    }
}

