/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;

public class CopyDirectoryVisitor
extends CountingPathVisitor {
    private final CopyOption[] copyOptions;
    private final Path sourceDirectory;
    private final Path targetDirectory;

    private static CopyOption[] toCopyOption(CopyOption ... copyOptionArray) {
        if (copyOptionArray == null) {
            return PathUtils.EMPTY_COPY_OPTIONS;
        }
        return (CopyOption[])copyOptionArray.clone();
    }

    public CopyDirectoryVisitor(Counters$PathCounters counters$PathCounters, Path path, Path path2, CopyOption ... copyOptionArray) {
        super(counters$PathCounters);
        this.sourceDirectory = path;
        this.targetDirectory = path2;
        this.copyOptions = CopyDirectoryVisitor.toCopyOption(copyOptionArray);
    }

    public CopyDirectoryVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2, Path path, Path path2, CopyOption ... copyOptionArray) {
        super(counters$PathCounters, pathFilter, pathFilter2);
        this.sourceDirectory = path;
        this.targetDirectory = path2;
        this.copyOptions = CopyDirectoryVisitor.toCopyOption(copyOptionArray);
    }

    protected void copy(Path path, Path path2) throws IOException {
        Files.copy(path, path2, this.copyOptions);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CopyDirectoryVisitor)object;
        return Arrays.equals(this.copyOptions, ((CopyDirectoryVisitor)object).copyOptions) && Objects.equals(this.sourceDirectory, ((CopyDirectoryVisitor)object).sourceDirectory) && Objects.equals(this.targetDirectory, ((CopyDirectoryVisitor)object).targetDirectory);
    }

    public CopyOption[] getCopyOptions() {
        return (CopyOption[])this.copyOptions.clone();
    }

    public Path getSourceDirectory() {
        return this.sourceDirectory;
    }

    public Path getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + Arrays.hashCode(this.copyOptions);
        return n2 * 31 + Objects.hash(this.sourceDirectory, this.targetDirectory);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        Path path2 = this.resolveRelativeAsString(path);
        if (Files.notExists(path2, new LinkOption[0])) {
            Files.createDirectory(path2, new FileAttribute[0]);
        }
        return super.preVisitDirectory(path, basicFileAttributes);
    }

    private Path resolveRelativeAsString(Path path) {
        return PathUtils.resolve(this.targetDirectory, this.sourceDirectory.relativize(path));
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        Path path2 = this.resolveRelativeAsString(path);
        if (this.accept(path, basicFileAttributes)) {
            this.copy(path, path2);
            this.updateFileCounters(path2, basicFileAttributes);
        }
        return FileVisitResult.CONTINUE;
    }
}

