/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.CountingPathVisitor$AbstractBuilder;
import org.apache.commons.io.file.CountingPathVisitor$Builder;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.SimplePathVisitor;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SymbolicLinkFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.function.IOBiFunction;

public class CountingPathVisitor
extends SimplePathVisitor {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Counters$PathCounters pathCounters;
    private final PathFilter fileFilter;
    private final PathFilter directoryFilter;
    private final UnaryOperator<Path> directoryPostTransformer;

    static IOFileFilter defaultDirectoryFilter() {
        return TrueFileFilter.INSTANCE;
    }

    static UnaryOperator<Path> defaultDirectoryTransformer() {
        return UnaryOperator.identity();
    }

    static IOFileFilter defaultFileFilter() {
        return new SymbolicLinkFileFilter(FileVisitResult.TERMINATE, FileVisitResult.CONTINUE);
    }

    static Counters$PathCounters defaultPathCounters() {
        return Counters.longPathCounters();
    }

    public static CountingPathVisitor withBigIntegerCounters() {
        return ((CountingPathVisitor$Builder)new CountingPathVisitor$Builder().setPathCounters(Counters.bigIntegerPathCounters())).get();
    }

    public static CountingPathVisitor withLongCounters() {
        return ((CountingPathVisitor$Builder)new CountingPathVisitor$Builder().setPathCounters(Counters.longPathCounters())).get();
    }

    CountingPathVisitor(CountingPathVisitor$AbstractBuilder<?, ?> countingPathVisitor$AbstractBuilder) {
        super(countingPathVisitor$AbstractBuilder);
        this.pathCounters = countingPathVisitor$AbstractBuilder.getPathCounters();
        this.fileFilter = countingPathVisitor$AbstractBuilder.getFileFilter();
        this.directoryFilter = countingPathVisitor$AbstractBuilder.getDirectoryFilter();
        this.directoryPostTransformer = countingPathVisitor$AbstractBuilder.getDirectoryPostTransformer();
    }

    public CountingPathVisitor(Counters$PathCounters counters$PathCounters) {
        this((CountingPathVisitor$AbstractBuilder<?, ?>)new CountingPathVisitor$Builder().setPathCounters(counters$PathCounters));
    }

    public CountingPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2) {
        this.pathCounters = Objects.requireNonNull(counters$PathCounters, "pathCounters");
        this.fileFilter = Objects.requireNonNull(pathFilter, "fileFilter");
        this.directoryFilter = Objects.requireNonNull(pathFilter2, "directoryFilter");
        this.directoryPostTransformer = UnaryOperator.identity();
    }

    @Deprecated
    public CountingPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2, IOBiFunction<Path, IOException, FileVisitResult> iOBiFunction) {
        super(iOBiFunction);
        this.pathCounters = Objects.requireNonNull(counters$PathCounters, "pathCounters");
        this.fileFilter = Objects.requireNonNull(pathFilter, "fileFilter");
        this.directoryFilter = Objects.requireNonNull(pathFilter2, "directoryFilter");
        this.directoryPostTransformer = UnaryOperator.identity();
    }

    protected boolean accept(Path path, BasicFileAttributes basicFileAttributes) {
        return Files.exists(path, new LinkOption[0]) && this.fileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CountingPathVisitor)) {
            return false;
        }
        object = (CountingPathVisitor)object;
        return Objects.equals(this.pathCounters, ((CountingPathVisitor)object).pathCounters);
    }

    public Counters$PathCounters getPathCounters() {
        return this.pathCounters;
    }

    public int hashCode() {
        return Objects.hash(this.pathCounters);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        CountingPathVisitor countingPathVisitor = this;
        countingPathVisitor.updateDirCounter((Path)countingPathVisitor.directoryPostTransformer.apply(path), iOException);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path object, BasicFileAttributes basicFileAttributes) throws IOException {
        if ((object = this.directoryFilter.accept((Path)object, basicFileAttributes)) != FileVisitResult.CONTINUE) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    public String toString() {
        return this.pathCounters.toString();
    }

    protected void updateDirCounter(Path path, IOException iOException) {
        this.pathCounters.getDirectoryCounter().increment();
    }

    protected void updateFileCounters(Path path, BasicFileAttributes basicFileAttributes) {
        this.pathCounters.getFileCounter().increment();
        this.pathCounters.getByteCounter().add(basicFileAttributes.size());
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.accept(path, basicFileAttributes)) {
            this.updateFileCounters(path, basicFileAttributes);
        }
        return FileVisitResult.CONTINUE;
    }
}

