/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.PathUtils$1;

final class PathUtils$RelativeSortedPaths {
    final boolean equals;
    final List<Path> relativeFileList1;
    final List<Path> relativeFileList2;

    private static boolean equalsIgnoreFileSystem(List<Path> object, List<Path> object2) {
        if (object.size() != object2.size()) {
            return false;
        }
        object = object.iterator();
        object2 = object2.iterator();
        while (object.hasNext() && object2.hasNext()) {
            if (PathUtils$RelativeSortedPaths.equalsIgnoreFileSystem((Path)object.next(), (Path)object2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsIgnoreFileSystem(Path object, Path object2) {
        Object object3;
        Object object4 = object.getFileSystem();
        if (object4 == (object3 = object2.getFileSystem())) {
            return object.equals(object2);
        }
        object4 = ((FileSystem)object4).getSeparator();
        object3 = ((FileSystem)object3).getSeparator();
        object = object.toString();
        object2 = object2.toString();
        if (Objects.equals(object4, object3)) {
            return Objects.equals(object, object2);
        }
        return PathUtils$RelativeSortedPaths.extractKey((String)object4, (String)object).equals(PathUtils$RelativeSortedPaths.extractKey((String)object3, (String)object2));
    }

    static String extractKey(String string, String string2) {
        return string2.replaceAll("\\" + string, ">");
    }

    private PathUtils$RelativeSortedPaths(Path path, Path path2, int n2, LinkOption[] linkOptionArray, FileVisitOption[] object) throws IOException {
        List<Path> list = null;
        List<Path> list2 = null;
        if (path == null && path2 == null) {
            this.equals = true;
        } else if (path == null ^ path2 == null) {
            this.equals = false;
        } else {
            boolean bl2 = Files.notExists(path, linkOptionArray);
            boolean bl3 = Files.notExists(path2, linkOptionArray);
            if (bl2 || bl3) {
                this.equals = bl2 && bl3;
            } else {
                AccumulatorPathVisitor accumulatorPathVisitor = PathUtils.access$000(path, n2, (FileVisitOption[])object);
                object = PathUtils.access$000(path2, n2, (FileVisitOption[])object);
                if (accumulatorPathVisitor.getDirList().size() != ((AccumulatorPathVisitor)object).getDirList().size() || accumulatorPathVisitor.getFileList().size() != ((AccumulatorPathVisitor)object).getFileList().size()) {
                    this.equals = false;
                } else {
                    List<Path> list3;
                    List<Path> list4 = accumulatorPathVisitor.relativizeDirectories(path, true, null);
                    if (!PathUtils$RelativeSortedPaths.equalsIgnoreFileSystem(list4, list3 = ((AccumulatorPathVisitor)object).relativizeDirectories(path2, true, null))) {
                        this.equals = false;
                    } else {
                        list = accumulatorPathVisitor.relativizeFiles(path, true, null);
                        list2 = ((AccumulatorPathVisitor)object).relativizeFiles(path2, true, null);
                        this.equals = PathUtils$RelativeSortedPaths.equalsIgnoreFileSystem(list, list2);
                    }
                }
            }
        }
        this.relativeFileList1 = list;
        this.relativeFileList2 = list2;
    }

    /* synthetic */ PathUtils$RelativeSortedPaths(Path path, Path path2, int n2, LinkOption[] linkOptionArray, FileVisitOption[] fileVisitOptionArray, PathUtils$1 pathUtils$1) throws IOException {
        this(path, path2, n2, linkOptionArray, fileVisitOptionArray);
    }
}

