/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.AccumulatorPathVisitor$Builder;
import org.apache.commons.io.file.CleaningPathVisitor;
import org.apache.commons.io.file.CopyDirectoryVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.DirectoryStreamFilter;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils$RelativeSortedPaths;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.file.attribute.FileTimes;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOSupplier;

public final class PathUtils {
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTE_ARRAY = new FileAttribute[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    @Deprecated
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    static final LinkOption NULL_LINK_OPTION = null;
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    private static AccumulatorPathVisitor accumulate(Path path, int n2, FileVisitOption[] fileVisitOptionArray) throws IOException {
        return PathUtils.visitFileTree(((AccumulatorPathVisitor$Builder)AccumulatorPathVisitor.builder().setDirectoryPostTransformer(PathUtils::stripTrailingSeparator)).get(), path, PathUtils.toFileVisitOptionSet(fileVisitOptionArray), n2);
    }

    public static Counters$PathCounters cleanDirectory(Path path) throws IOException {
        return PathUtils.cleanDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters cleanDirectory(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        return PathUtils.visitFileTree(new CleaningPathVisitor(Counters.longPathCounters(), deleteOptionArray, new String[0]), path).getPathCounters();
    }

    private static int compareLastModifiedTimeTo(Path path, FileTime fileTime, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.getLastModifiedTime(path, linkOptionArray).compareTo(fileTime);
    }

    public static boolean contentEquals(FileSystem object, FileSystem object2) throws IOException {
        if (Objects.equals(object, object2)) {
            return true;
        }
        object = PathUtils.toSortedList(((FileSystem)object).getRootDirectories());
        object2 = PathUtils.toSortedList(((FileSystem)object2).getRootDirectories());
        if (object.size() != object2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < object.size(); ++i2) {
            if (PathUtils.directoryAndFileContentEquals((Path)object.get(i2), (Path)object2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static long copy(IOSupplier<InputStream> object, Path path, CopyOption ... copyOptionArray) throws IOException {
        object = object.get();
        try {
            long l2 = Files.copy((InputStream)object, path, copyOptionArray);
            return l2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public static Counters$PathCounters copyDirectory(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        path = path.toAbsolutePath();
        return PathUtils.visitFileTree(new CopyDirectoryVisitor(Counters.longPathCounters(), path, path2, copyOptionArray), path).getPathCounters();
    }

    public static Path copyFile(URL uRL, Path path, CopyOption ... copyOptionArray) throws IOException {
        PathUtils.copy(uRL::openStream, path, copyOptionArray);
        return path;
    }

    public static Path copyFileToDirectory(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        Path path3 = Objects.requireNonNull(path.getFileName(), "source file name");
        path2 = PathUtils.resolve(path2, path3);
        return Files.copy(path, path2, copyOptionArray);
    }

    public static Path copyFileToDirectory(URL uRL, Path path, CopyOption ... copyOptionArray) throws IOException {
        path = path.resolve(FilenameUtils.getName(uRL.getFile()));
        PathUtils.copy(uRL::openStream, path, copyOptionArray);
        return path;
    }

    public static Counters$PathCounters countDirectory(Path path) throws IOException {
        return PathUtils.visitFileTree(CountingPathVisitor.withLongCounters(), path).getPathCounters();
    }

    public static Counters$PathCounters countDirectoryAsBigInteger(Path path) throws IOException {
        return PathUtils.visitFileTree(CountingPathVisitor.withBigIntegerCounters(), path).getPathCounters();
    }

    public static Path createParentDirectories(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return PathUtils.createParentDirectories(path, LinkOption.NOFOLLOW_LINKS, fileAttributeArray);
    }

    public static Path createParentDirectories(Path path, LinkOption linkOption, FileAttribute<?> ... fileAttributeArray) throws IOException {
        path = PathUtils.getParent(path);
        path = linkOption == LinkOption.NOFOLLOW_LINKS ? path : PathUtils.readIfSymbolicLink(path);
        if (path == null) {
            return null;
        }
        boolean bl2 = linkOption == null ? Files.exists(path, new LinkOption[0]) : Files.exists(path, linkOption);
        if (bl2) {
            return path;
        }
        return Files.createDirectories(path, fileAttributeArray);
    }

    public static Path current() {
        return Paths.get(".", new String[0]);
    }

    public static Counters$PathCounters delete(Path path) throws IOException {
        return PathUtils.delete(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters delete(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            return PathUtils.deleteDirectory(path, deleteOptionArray);
        }
        return PathUtils.deleteFile(path, deleteOptionArray);
    }

    public static Counters$PathCounters delete(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws IOException {
        if (Files.isDirectory(path, linkOptionArray)) {
            return PathUtils.deleteDirectory(path, linkOptionArray, deleteOptionArray);
        }
        return PathUtils.deleteFile(path, linkOptionArray, deleteOptionArray);
    }

    public static Counters$PathCounters deleteDirectory(Path path) throws IOException {
        return PathUtils.deleteDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters deleteDirectory(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        LinkOption[] linkOptionArray = PathUtils.noFollowLinkOptionArray();
        return PathUtils.withPosixFileAttributes(PathUtils.getParent(path), linkOptionArray, PathUtils.overrideReadOnly(deleteOptionArray), posixFileAttributes -> PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptionArray, deleteOptionArray, new String[0]), path).getPathCounters());
    }

    public static Counters$PathCounters deleteDirectory(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptionArray, deleteOptionArray, new String[0]), path).getPathCounters();
    }

    public static Counters$PathCounters deleteFile(Path path) throws IOException {
        return PathUtils.deleteFile(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters deleteFile(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        return PathUtils.deleteFile(path, PathUtils.noFollowLinkOptionArray(), deleteOptionArray);
    }

    public static Counters$PathCounters deleteFile(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws NoSuchFileException, IOException {
        if (Files.isDirectory(path, linkOptionArray)) {
            throw new NoSuchFileException(path.toString());
        }
        Counters$PathCounters counters$PathCounters = Counters.longPathCounters();
        boolean bl2 = PathUtils.exists(path, linkOptionArray);
        long l2 = bl2 && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
        try {
            if (Files.deleteIfExists(path)) {
                counters$PathCounters.getFileCounter().increment();
                counters$PathCounters.getByteCounter().add(l2);
                return counters$PathCounters;
            }
        }
        catch (AccessDeniedException accessDeniedException) {}
        Path path2 = PathUtils.getParent(path);
        PosixFileAttributes posixFileAttributes = null;
        try {
            if (PathUtils.overrideReadOnly(deleteOptionArray)) {
                posixFileAttributes = PathUtils.readPosixFileAttributes(path2, linkOptionArray);
                PathUtils.setReadOnly(path, false, linkOptionArray);
            }
            long l3 = l2 = (bl2 = PathUtils.exists(path, linkOptionArray)) && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
            if (Files.deleteIfExists(path)) {
                counters$PathCounters.getFileCounter().increment();
                counters$PathCounters.getByteCounter().add(l2);
            }
        }
        finally {
            if (posixFileAttributes != null) {
                Files.setPosixFilePermissions(path2, posixFileAttributes.permissions());
            }
        }
        return counters$PathCounters;
    }

    public static void deleteOnExit(Path path) {
        Objects.requireNonNull(path).toFile().deleteOnExit();
    }

    public static boolean directoryAndFileContentEquals(Path path, Path path2) throws IOException {
        return PathUtils.directoryAndFileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryAndFileContentEquals(Path path2, Path path3, LinkOption[] linkOptionArray, OpenOption[] openOptionArray, FileVisitOption[] object) throws IOException {
        if (path2 == null && path3 == null) {
            return true;
        }
        if (path2 == null || path3 == null) {
            return false;
        }
        if (PathUtils.notExists(path2, new LinkOption[0]) && PathUtils.notExists(path3, new LinkOption[0])) {
            return true;
        }
        object = new PathUtils$RelativeSortedPaths(path2, path3, Integer.MAX_VALUE, linkOptionArray, (FileVisitOption[])object, null);
        if (!object.equals) {
            return false;
        }
        Object object2 = object.relativeFileList1;
        object = object.relativeFileList2;
        boolean bl2 = PathUtils.isSameFileSystem(path2, path3);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Path path4 = (Path)object2.next();
            int n2 = bl2 ? Collections.binarySearch(object, path4) : Collections.binarySearch(object, path4, Comparator.comparing(path -> PathUtils$RelativeSortedPaths.extractKey(path.getFileSystem().getSeparator(), path.toString())));
            if (n2 < 0) {
                throw new IllegalStateException("Unexpected mismatch.");
            }
            if (bl2 && !PathUtils.fileContentEquals(path2.resolve(path4), path3.resolve(path4), linkOptionArray, openOptionArray)) {
                return false;
            }
            if (PathUtils.fileContentEquals(path2.resolve(path4.toString()), path3.resolve(path4.toString()), linkOptionArray, openOptionArray)) continue;
            return false;
        }
        return true;
    }

    public static boolean directoryContentEquals(Path path, Path path2) throws IOException {
        return PathUtils.directoryContentEquals(path, path2, Integer.MAX_VALUE, EMPTY_LINK_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryContentEquals(Path path, Path path2, int n2, LinkOption[] linkOptionArray, FileVisitOption[] fileVisitOptionArray) throws IOException {
        return new PathUtils$RelativeSortedPaths((Path)path, (Path)path2, (int)n2, (LinkOption[])linkOptionArray, (FileVisitOption[])fileVisitOptionArray, null).equals;
    }

    private static boolean exists(Path path, LinkOption ... linkOptionArray) {
        return path != null && (linkOptionArray != null ? Files.exists(path, linkOptionArray) : Files.exists(path, new LinkOption[0]));
    }

    public static boolean fileContentEquals(Path path, Path path2) throws IOException {
        return PathUtils.fileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean fileContentEquals(Path object, Path object2, LinkOption[] object3, OpenOption[] openOptionArray) throws IOException {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Path path = object.normalize();
        Path path2 = object2.normalize();
        boolean bl2 = PathUtils.exists(path, (LinkOption[])object3);
        if (bl2 != PathUtils.exists(path2, (LinkOption[])object3)) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (Files.isDirectory(path, (LinkOption[])object3)) {
            throw new IOException("Can't compare directories, only files: " + path);
        }
        if (Files.isDirectory(path2, (LinkOption[])object3)) {
            throw new IOException("Can't compare directories, only files: " + path2);
        }
        if (Files.size(path) != Files.size(path2)) {
            return false;
        }
        if (PathUtils.isSameFileSystem((Path)object, (Path)object2) && object.equals(object2)) {
            return true;
        }
        try {
            object = RandomAccessFileMode.READ_ONLY.create(object.toRealPath((LinkOption[])object3));
            try {
                boolean bl3;
                block34: {
                    object2 = RandomAccessFileMode.READ_ONLY.create(object2.toRealPath((LinkOption[])object3));
                    try {
                        bl3 = RandomAccessFiles.contentEquals((RandomAccessFile)object, (RandomAccessFile)object2);
                        if (object2 == null) break block34;
                    }
                    catch (Throwable throwable) {
                        if (object2 != null) {
                            try {
                                ((RandomAccessFile)object2).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ((RandomAccessFile)object2).close();
                }
                return bl3;
            }
            finally {
                if (object != null) {
                    ((RandomAccessFile)object).close();
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object2 = Files.newInputStream(path, openOptionArray);
            try {
                block35: {
                    object3 = Files.newInputStream(path2, openOptionArray);
                    try {
                        bl2 = IOUtils.contentEquals((InputStream)object2, (InputStream)object3);
                        if (object3 == null) break block35;
                    }
                    catch (Throwable throwable) {
                        if (object3 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    ((InputStream)object3).close();
                }
                return bl2;
            }
            finally {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
        }
    }

    public static Path[] filter(PathFilter pathFilter, Path ... pathArray) {
        Objects.requireNonNull(pathFilter, "filter");
        if (pathArray == null) {
            return EMPTY_PATH_ARRAY;
        }
        return PathUtils.filterPaths(pathFilter, Stream.of(pathArray), Collectors.toList()).toArray(EMPTY_PATH_ARRAY);
    }

    private static <R, A> R filterPaths(PathFilter pathFilter, Stream<Path> stream, Collector<? super Path, A, R> collector) {
        Objects.requireNonNull(pathFilter, "filter");
        Objects.requireNonNull(collector, "collector");
        if (stream == null) {
            return Stream.empty().collect(collector);
        }
        return stream.filter(path -> {
            try {
                if (path != null) {
                    Path path2 = path;
                    if (pathFilter.accept(path2, PathUtils.readBasicFileAttributes(path2)) == FileVisitResult.CONTINUE) {
                        return true;
                    }
                }
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }).collect(collector);
    }

    public static List<AclEntry> getAclEntryList(Path object) throws IOException {
        if ((object = PathUtils.getAclFileAttributeView((Path)object, new LinkOption[0])) == null) {
            return null;
        }
        return object.getAcl();
    }

    public static AclFileAttributeView getAclFileAttributeView(Path path, LinkOption ... linkOptionArray) {
        return Files.getFileAttributeView(path, AclFileAttributeView.class, linkOptionArray);
    }

    public static String getBaseName(Path path) {
        if (path == null) {
            return null;
        }
        if ((path = path.getFileName()) != null) {
            return FilenameUtils.removeExtension(path.toString());
        }
        return null;
    }

    public static DosFileAttributeView getDosFileAttributeView(Path path, LinkOption ... linkOptionArray) {
        return Files.getFileAttributeView(path, DosFileAttributeView.class, linkOptionArray);
    }

    public static String getExtension(Path object) {
        if ((object = PathUtils.getFileNameString((Path)object)) != null) {
            return FilenameUtils.getExtension((String)object);
        }
        return null;
    }

    public static <R> R getFileName(Path path, Function<Path, R> function) {
        if ((path = path != null ? path.getFileName() : null) != null) {
            return function.apply(path);
        }
        return null;
    }

    public static String getFileNameString(Path path) {
        return PathUtils.getFileName(path, Path::toString);
    }

    public static FileTime getLastModifiedFileTime(File file) throws IOException {
        return PathUtils.getLastModifiedFileTime(file.toPath(), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(Path path, FileTime fileTime, LinkOption ... linkOptionArray) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            return PathUtils.getLastModifiedTime(path, linkOptionArray);
        }
        return fileTime;
    }

    public static FileTime getLastModifiedFileTime(Path path, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.getLastModifiedFileTime(path, null, linkOptionArray);
    }

    public static FileTime getLastModifiedFileTime(URI uRI) throws IOException {
        return PathUtils.getLastModifiedFileTime(Paths.get(uRI), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(URL uRL) throws IOException, URISyntaxException {
        return PathUtils.getLastModifiedFileTime(uRL.toURI());
    }

    private static FileTime getLastModifiedTime(Path path, LinkOption ... linkOptionArray) throws IOException {
        return Files.getLastModifiedTime(Objects.requireNonNull(path, "path"), linkOptionArray);
    }

    private static Path getParent(Path path) {
        if (path == null) {
            return null;
        }
        return path.getParent();
    }

    public static PosixFileAttributeView getPosixFileAttributeView(Path path, LinkOption ... linkOptionArray) {
        return Files.getFileAttributeView(path, PosixFileAttributeView.class, linkOptionArray);
    }

    public static Path getTempDirectory() {
        return Paths.get(FileUtils.getTempDirectoryPath(), new String[0]);
    }

    public static boolean isDirectory(Path path, LinkOption ... linkOptionArray) {
        return path != null && Files.isDirectory(path, linkOptionArray);
    }

    public static boolean isEmpty(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return PathUtils.isEmptyDirectory(path);
        }
        return PathUtils.isEmptyFile(path);
    }

    public static boolean isEmptyDirectory(Path iterable) throws IOException {
        iterable = Files.newDirectoryStream((Path)iterable);
        try {
            boolean bl2 = !iterable.iterator().hasNext();
            return bl2;
        }
        finally {
            if (iterable != null) {
                iterable.close();
            }
        }
    }

    public static boolean isEmptyFile(Path path) throws IOException {
        return Files.size(path) <= 0L;
    }

    public static boolean isNewer(Path path, ChronoZonedDateTime<?> chronoZonedDateTime, LinkOption ... linkOptionArray) throws IOException {
        Objects.requireNonNull(chronoZonedDateTime, "czdt");
        return PathUtils.isNewer(path, chronoZonedDateTime.toInstant(), linkOptionArray);
    }

    public static boolean isNewer(Path path, FileTime fileTime, LinkOption ... linkOptionArray) throws IOException {
        if (PathUtils.notExists(path, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(path, fileTime, linkOptionArray) > 0;
    }

    public static boolean isNewer(Path path, Instant instant, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.isNewer(path, FileTime.from(instant), linkOptionArray);
    }

    public static boolean isNewer(Path path, long l2, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.isNewer(path, FileTime.fromMillis(l2), linkOptionArray);
    }

    public static boolean isNewer(Path path, Path path2) throws IOException {
        return PathUtils.isNewer(path, PathUtils.getLastModifiedTime(path2, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isOlder(Path path, FileTime fileTime, LinkOption ... linkOptionArray) throws IOException {
        if (PathUtils.notExists(path, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(path, fileTime, linkOptionArray) < 0;
    }

    public static boolean isOlder(Path path, Instant instant, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.isOlder(path, FileTime.from(instant), linkOptionArray);
    }

    public static boolean isOlder(Path path, long l2, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.isOlder(path, FileTime.fromMillis(l2), linkOptionArray);
    }

    public static boolean isOlder(Path path, Path path2) throws IOException {
        return PathUtils.isOlder(path, PathUtils.getLastModifiedTime(path2, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isPosix(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.exists(path, linkOptionArray) && PathUtils.readPosixFileAttributes(path, linkOptionArray) != null;
    }

    public static boolean isRegularFile(Path path, LinkOption ... linkOptionArray) {
        return path != null && Files.isRegularFile(path, linkOptionArray);
    }

    static boolean isSameFileSystem(Path path, Path path2) {
        return path.getFileSystem() == path2.getFileSystem();
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, PathFilter pathFilter) throws IOException {
        return Files.newDirectoryStream(path, new DirectoryStreamFilter(pathFilter));
    }

    public static OutputStream newOutputStream(Path path, boolean bl2) throws IOException {
        return PathUtils.newOutputStream(path, EMPTY_LINK_OPTION_ARRAY, bl2 ? OPEN_OPTIONS_APPEND : OPEN_OPTIONS_TRUNCATE);
    }

    static OutputStream newOutputStream(Path path, LinkOption[] linkOptionArray, OpenOption ... object) throws IOException {
        if (!PathUtils.exists(path, linkOptionArray)) {
            PathUtils.createParentDirectories(path, linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray[0] : NULL_LINK_OPTION, new FileAttribute[0]);
        }
        object = new ArrayList<OpenOption>(Arrays.asList(object != null ? object : EMPTY_OPEN_OPTION_ARRAY));
        object.addAll(Arrays.asList(linkOptionArray != null ? linkOptionArray : EMPTY_LINK_OPTION_ARRAY));
        return Files.newOutputStream(path, object.toArray(EMPTY_OPEN_OPTION_ARRAY));
    }

    public static LinkOption[] noFollowLinkOptionArray() {
        return (LinkOption[])NOFOLLOW_LINK_OPTION_ARRAY.clone();
    }

    private static boolean notExists(Path path, LinkOption ... linkOptionArray) {
        return Files.notExists(Objects.requireNonNull(path, "path"), linkOptionArray);
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptionArray) {
        if (deleteOptionArray == null) {
            return false;
        }
        return Stream.of(deleteOptionArray).anyMatch(deleteOption -> deleteOption == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) {
        try {
            if (path == null) {
                return null;
            }
            return Files.readAttributes(path, clazz, linkOptionArray);
        }
        catch (IOException | UnsupportedOperationException exception) {
            return null;
        }
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.readAttributes(path, BasicFileAttributes.class, linkOptionArray);
    }

    @Deprecated
    public static BasicFileAttributes readBasicFileAttributesUnchecked(Path path) {
        return PathUtils.readBasicFileAttributes(path, EMPTY_LINK_OPTION_ARRAY);
    }

    public static DosFileAttributes readDosFileAttributes(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.readAttributes(path, DosFileAttributes.class, linkOptionArray);
    }

    private static Path readIfSymbolicLink(Path path) throws IOException {
        if (path != null) {
            if (Files.isSymbolicLink(path)) {
                return Files.readSymbolicLink(path);
            }
            return path;
        }
        return null;
    }

    public static BasicFileAttributes readOsFileAttributes(Path path, LinkOption ... linkOptionArray) {
        PosixFileAttributes posixFileAttributes = PathUtils.readPosixFileAttributes(path, linkOptionArray);
        if (posixFileAttributes != null) {
            return posixFileAttributes;
        }
        return PathUtils.readDosFileAttributes(path, linkOptionArray);
    }

    public static PosixFileAttributes readPosixFileAttributes(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.readAttributes(path, PosixFileAttributes.class, linkOptionArray);
    }

    public static String readString(Path path, Charset charset) throws IOException {
        return new String(Files.readAllBytes(path), Charsets.toCharset(charset));
    }

    static List<Path> relativize(Collection<Path> stream, Path path, boolean bl2, Comparator<? super Path> comparator) {
        stream = stream.stream().map(path::relativize);
        if (bl2) {
            stream = comparator == null ? stream.sorted() : stream.sorted(comparator);
        }
        return stream.collect(Collectors.toList());
    }

    private static Path requireExists(Path path, String string, LinkOption ... linkOptionArray) {
        Objects.requireNonNull(path, string);
        if (!PathUtils.exists(path, linkOptionArray)) {
            throw new IllegalArgumentException("File system element for parameter '" + string + "' does not exist: '" + path + "'");
        }
        return path;
    }

    static Path resolve(Path path, Path object) {
        Object object2;
        Object object3 = path.getFileSystem();
        if (object3 == (object2 = object.getFileSystem())) {
            return path.resolve((Path)object);
        }
        object2 = ((FileSystem)object2).getSeparator();
        object3 = ((FileSystem)object3).getSeparator();
        object = object.toString();
        return path.resolve((String)(Objects.equals(object2, object3) ? object : ((String)object).replace((CharSequence)object2, (CharSequence)object3)));
    }

    private static boolean setDosReadOnly(Path object, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        if ((object = PathUtils.getDosFileAttributeView((Path)object, linkOptionArray)) != null) {
            object.setReadOnly(bl2);
            return true;
        }
        return false;
    }

    public static void setLastModifiedTime(Path path, Path path2) throws IOException {
        Objects.requireNonNull(path, "sourceFile");
        Files.setLastModifiedTime(path2, PathUtils.getLastModifiedTime(path, new LinkOption[0]));
    }

    private static boolean setPosixDeletePermissions(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.setPosixPermissions(path, bl2, Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), linkOptionArray);
    }

    private static boolean setPosixPermissions(Path path, boolean bl2, List<PosixFilePermission> list, LinkOption ... object) throws IOException {
        if (path != null) {
            object = Files.getPosixFilePermissions(path, object);
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>((Collection<PosixFilePermission>)object);
            if (bl2) {
                hashSet.addAll(list);
            } else {
                hashSet.removeAll(list);
            }
            if (!hashSet.equals(object)) {
                Files.setPosixFilePermissions(path, hashSet);
            }
            return true;
        }
        return false;
    }

    private static void setPosixReadOnlyFile(Path path, boolean bl2, LinkOption ... object) throws IOException {
        object = Files.getPosixFilePermissions(path, (LinkOption[])object);
        List<PosixFilePermission> list = Arrays.asList(PosixFilePermission.OWNER_READ);
        List<PosixFilePermission> list2 = Arrays.asList(PosixFilePermission.OWNER_WRITE);
        if (bl2) {
            object.addAll(list);
            object.removeAll(list2);
        } else {
            object.addAll(list);
            object.addAll(list2);
        }
        Files.setPosixFilePermissions(path, (Set<PosixFilePermission>)object);
    }

    public static Path setReadOnly(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        try {
            if (PathUtils.setDosReadOnly(path, bl2, linkOptionArray)) {
                return path;
            }
        }
        catch (IOException iOException) {}
        Path path2 = PathUtils.getParent(path);
        if (!PathUtils.isPosix(path2, linkOptionArray)) {
            throw new IOException(String.format("DOS or POSIX file operations not available for '%s', linkOptions %s", path, Arrays.toString(linkOptionArray)));
        }
        if (bl2) {
            PathUtils.setPosixReadOnlyFile(path, bl2, linkOptionArray);
            PathUtils.setPosixDeletePermissions(path2, false, linkOptionArray);
        } else {
            PathUtils.setPosixDeletePermissions(path2, true, linkOptionArray);
        }
        return path;
    }

    public static long sizeOf(Path path) throws IOException {
        PathUtils.requireExists(path, "path", new LinkOption[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return PathUtils.sizeOfDirectory(path);
        }
        return Files.size(path);
    }

    public static BigInteger sizeOfAsBigInteger(Path path) throws IOException {
        PathUtils.requireExists(path, "path", new LinkOption[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return PathUtils.sizeOfDirectoryAsBigInteger(path);
        }
        return BigInteger.valueOf(Files.size(path));
    }

    public static long sizeOfDirectory(Path path) throws IOException {
        return PathUtils.countDirectory(path).getByteCounter().getLong();
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(Path path) throws IOException {
        return PathUtils.countDirectoryAsBigInteger(path).getByteCounter().getBigInteger();
    }

    private static Path stripTrailingSeparator(Path path) {
        String string = path.getFileSystem().getSeparator();
        String string2 = PathUtils.getFileNameString(path);
        if (string2 != null && string2.endsWith(string)) {
            return path.resolveSibling(string2.substring(0, string2.length() - 1));
        }
        return path;
    }

    static Set<FileVisitOption> toFileVisitOptionSet(FileVisitOption ... fileVisitOptionArray) {
        if (fileVisitOptionArray == null) {
            return EnumSet.noneOf(FileVisitOption.class);
        }
        return Stream.of(fileVisitOptionArray).collect(Collectors.toSet());
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    private static List<Path> toSortedList(Iterable<Path> iterable) {
        iterable = PathUtils.toList(iterable);
        Collections.sort(iterable);
        return iterable;
    }

    public static Path touch(Path path) throws IOException {
        Objects.requireNonNull(path, "file");
        if (!Files.exists(path, new LinkOption[0])) {
            PathUtils.createParentDirectories(path, new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        } else {
            FileTimes.setLastModifiedTime(path);
        }
        return path;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, Path path) throws IOException {
        Files.walkFileTree(path, t2);
        return t2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, Path path, Set<FileVisitOption> set, int n2) throws IOException {
        Files.walkFileTree(path, set, n2, t2);
        return t2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, String string, String ... stringArray) throws IOException {
        return PathUtils.visitFileTree(t2, Paths.get(string, stringArray));
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, URI uRI) throws IOException {
        return PathUtils.visitFileTree(t2, Paths.get(uRI));
    }

    public static boolean waitFor(Path path, Duration comparable, LinkOption ... linkOptionArray) {
        Objects.requireNonNull(path, "file");
        comparable = Instant.now().plus((TemporalAmount)((Object)comparable));
        boolean bl2 = false;
        try {
            while (!PathUtils.exists(path, linkOptionArray)) {
                Instant instant = Instant.now();
                if (instant.isAfter((Instant)comparable)) {
                    return false;
                }
                try {
                    ThreadUtils.sleep(Duration.ofMillis(Math.min(100L, ((Instant)comparable).minusMillis(instant.toEpochMilli()).toEpochMilli())));
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
        return PathUtils.exists(path, linkOptionArray);
    }

    public static Stream<Path> walk(Path path2, PathFilter pathFilter, int n2, boolean bl2, FileVisitOption ... fileVisitOptionArray) throws IOException {
        return Files.walk(path2, n2, fileVisitOptionArray).filter(path -> pathFilter.accept((Path)path, bl2 ? PathUtils.readBasicFileAttributesUnchecked(path) : null) == FileVisitResult.CONTINUE);
    }

    private static <R> R withPosixFileAttributes(Path path, LinkOption[] linkOptionArray, boolean bl2, IOFunction<PosixFileAttributes, R> iOFunction) throws IOException {
        PosixFileAttributes posixFileAttributes = bl2 ? PathUtils.readPosixFileAttributes(path, linkOptionArray) : null;
        try {
            iOFunction = iOFunction.apply(posixFileAttributes);
            return (R)iOFunction;
        }
        finally {
            if (posixFileAttributes != null && path != null && Files.exists(path, linkOptionArray)) {
                Files.setPosixFilePermissions(path, posixFileAttributes.permissions());
            }
        }
    }

    public static Path writeString(Path path, CharSequence charSequence, Charset charset, OpenOption ... openOptionArray) throws IOException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(charSequence, "charSequence");
        Files.write(path, String.valueOf(charSequence).getBytes(Charsets.toCharset(charset)), openOptionArray);
        return path;
    }

    private PathUtils() {
    }

    static /* synthetic */ AccumulatorPathVisitor access$000(Path path, int n2, FileVisitOption[] fileVisitOptionArray) throws IOException {
        return PathUtils.accumulate(path, n2, fileVisitOptionArray);
    }
}

