/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file.spi;

import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FileSystemProviders {
    private static final String SCHEME_FILE = "file";
    private static final FileSystemProviders INSTALLED = new FileSystemProviders(FileSystemProvider.installedProviders());
    private final List<FileSystemProvider> providers;

    public static FileSystemProvider getFileSystemProvider(Path path) {
        return Objects.requireNonNull(path, "path").getFileSystem().provider();
    }

    public static FileSystemProviders installed() {
        return INSTALLED;
    }

    private FileSystemProviders(List<FileSystemProvider> list) {
        this.providers = list != null ? list : Collections.emptyList();
    }

    public FileSystemProvider getFileSystemProvider(String string) {
        Objects.requireNonNull(string, "scheme");
        if (string.equalsIgnoreCase(SCHEME_FILE)) {
            return FileSystems.getDefault().provider();
        }
        return this.providers.stream().filter(fileSystemProvider -> fileSystemProvider.getScheme().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public FileSystemProvider getFileSystemProvider(URI uRI) {
        return this.getFileSystemProvider(Objects.requireNonNull(uRI, "uri").getScheme());
    }

    public FileSystemProvider getFileSystemProvider(URL uRL) {
        return this.getFileSystemProvider(Objects.requireNonNull(uRL, "url").getProtocol());
    }
}

