/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.function.IOSupplier;

public abstract class AbstractFileFilter
implements PathVisitor,
IOFileFilter {
    private final FileVisitResult onAccept;
    private final FileVisitResult onReject;

    static FileVisitResult toDefaultFileVisitResult(boolean bl2) {
        if (bl2) {
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.TERMINATE;
    }

    public AbstractFileFilter() {
        this(FileVisitResult.CONTINUE, FileVisitResult.TERMINATE);
    }

    protected AbstractFileFilter(FileVisitResult fileVisitResult, FileVisitResult fileVisitResult2) {
        this.onAccept = fileVisitResult;
        this.onReject = fileVisitResult2;
    }

    @Override
    public boolean accept(File file) {
        Objects.requireNonNull(file, "file");
        return this.accept(file.getParentFile(), file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        Objects.requireNonNull(string, "name");
        return this.accept(new File(file, string));
    }

    void append(List<?> list, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i2));
        }
    }

    void append(Object[] objectArray, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(objectArray[i2]);
        }
    }

    FileVisitResult get(IOSupplier<FileVisitResult> iOSupplier) {
        try {
            return iOSupplier.get();
        }
        catch (IOException iOException) {
            return this.handle(iOException);
        }
    }

    protected FileVisitResult handle(Throwable throwable) {
        return FileVisitResult.TERMINATE;
    }

    boolean isDirectory(File file) {
        return file != null && file.isDirectory();
    }

    boolean isFile(File file) {
        return file != null && file.isFile();
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return this.accept(path, basicFileAttributes);
    }

    FileVisitResult toFileVisitResult(boolean bl2) {
        if (bl2) {
            return this.onAccept;
        }
        return this.onReject;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return this.accept(path, basicFileAttributes);
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

