/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PrefixFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 8533897440809599867L;
    private final String[] prefixes;
    private final IOCase isCase;

    public PrefixFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(List<String> list, IOCase iOCase) {
        Objects.requireNonNull(list, "prefixes");
        this.prefixes = list.toArray(EMPTY_STRING_ARRAY);
        this.isCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String ... stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String string, IOCase iOCase) {
        Objects.requireNonNull(string, "prefix");
        this.prefixes = new String[]{string};
        this.isCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String[] stringArray, IOCase iOCase) {
        Objects.requireNonNull(stringArray, "prefixes");
        this.prefixes = (String[])stringArray.clone();
        this.isCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file == null ? null : file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        return this.accept(string);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        PrefixFileFilter prefixFileFilter = this;
        return prefixFileFilter.toFileVisitResult(((AbstractFileFilter)prefixFileFilter).accept(PathUtils.getFileName(path, Path::toFile)));
    }

    private boolean accept(String string) {
        return Stream.of(this.prefixes).anyMatch(string2 -> this.isCase.checkStartsWith(string, (String)string2));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        PrefixFileFilter prefixFileFilter = this;
        prefixFileFilter.append(prefixFileFilter.prefixes, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

