/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class RegexFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 4269646126155225062L;
    private final Pattern pattern;
    private final transient Function<Path, String> pathToString;

    private static Pattern compile(String string, int n2) {
        Objects.requireNonNull(string, "pattern");
        return Pattern.compile(string, n2);
    }

    private static int toFlags(IOCase iOCase) {
        if (IOCase.isCaseSensitive(iOCase)) {
            return 0;
        }
        return 2;
    }

    public RegexFileFilter(Pattern pattern) {
        this(pattern, PathUtils::getFileNameString);
    }

    public RegexFileFilter(Pattern pattern, Function<Path, String> function) {
        Objects.requireNonNull(pattern, "pattern");
        this.pattern = pattern;
        this.pathToString = function != null ? function : Objects::toString;
    }

    public RegexFileFilter(String string) {
        this(string, 0);
    }

    public RegexFileFilter(String string, int n2) {
        this(RegexFileFilter.compile(string, n2));
    }

    public RegexFileFilter(String string, IOCase iOCase) {
        this(RegexFileFilter.compile(string, RegexFileFilter.toFlags(iOCase)));
    }

    @Override
    public boolean accept(File file, String string) {
        return this.pattern.matcher(string).matches();
    }

    @Override
    public FileVisitResult accept(Path object, BasicFileAttributes basicFileAttributes) {
        return this.toFileVisitResult((object = this.pathToString.apply((Path)object)) != null && this.pattern.matcher((CharSequence)object).matches());
    }

    @Override
    public String toString() {
        return "RegexFileFilter [pattern=" + this.pattern + "]";
    }
}

