/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SuffixFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -3389157631240246157L;
    private final String[] suffixes;
    private final IOCase ioCase;

    public SuffixFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(List<String> list, IOCase iOCase) {
        Objects.requireNonNull(list, "suffixes");
        this.suffixes = list.toArray(EMPTY_STRING_ARRAY);
        this.ioCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String ... stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String string, IOCase iOCase) {
        Objects.requireNonNull(string, "suffix");
        this.suffixes = new String[]{string};
        this.ioCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String[] stringArray, IOCase iOCase) {
        Objects.requireNonNull(stringArray, "suffixes");
        this.suffixes = (String[])stringArray.clone();
        this.ioCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        return this.accept(string);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        SuffixFileFilter suffixFileFilter = this;
        return suffixFileFilter.toFileVisitResult(suffixFileFilter.accept(PathUtils.getFileNameString(path)));
    }

    private boolean accept(String string) {
        return Stream.of(this.suffixes).anyMatch(string2 -> this.ioCase.checkEndsWith(string, (String)string2));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        SuffixFileFilter suffixFileFilter = this;
        suffixFileFilter.append(suffixFileFilter.suffixes, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

