/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

@Deprecated
public class WildcardFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -5037645902506953517L;
    private final String[] wildcards;

    public WildcardFilter(List<String> list) {
        Objects.requireNonNull(list, "wildcards");
        this.wildcards = list.toArray(EMPTY_STRING_ARRAY);
    }

    public WildcardFilter(String string) {
        Objects.requireNonNull(string, "wildcard");
        this.wildcards = new String[]{string};
    }

    public WildcardFilter(String ... stringArray) {
        Objects.requireNonNull(stringArray, "wildcards");
        this.wildcards = (String[])stringArray.clone();
    }

    @Override
    public boolean accept(File file) {
        if (this.isDirectory(file)) {
            return false;
        }
        return Stream.of(this.wildcards).anyMatch(string -> FilenameUtils.wildcardMatch(file.getName(), string));
    }

    @Override
    public boolean accept(File file, String string) {
        if (file != null && new File(file, string).isDirectory()) {
            return false;
        }
        return Stream.of(this.wildcards).anyMatch(string2 -> FilenameUtils.wildcardMatch(string, string2));
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return FileVisitResult.TERMINATE;
        }
        return WildcardFilter.toDefaultFileVisitResult(Stream.of(this.wildcards).anyMatch(string -> FilenameUtils.wildcardMatch(PathUtils.getFileNameString(path), string)));
    }
}

