/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Objects;
import java.util.function.BinaryOperator;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOBinaryOperator<T>
extends IOBiFunction<T, T, T> {
    public static <T> IOBinaryOperator<T> maxBy(IOComparator<? super T> iOComparator) {
        Objects.requireNonNull(iOComparator);
        return (object, object2) -> {
            if (iOComparator.compare(object, object2) >= 0) {
                return object;
            }
            return object2;
        };
    }

    public static <T> IOBinaryOperator<T> minBy(IOComparator<? super T> iOComparator) {
        Objects.requireNonNull(iOComparator);
        return (object, object2) -> {
            if (iOComparator.compare(object, object2) <= 0) {
                return object;
            }
            return object2;
        };
    }

    default public BinaryOperator<T> asBinaryOperator() {
        return (object, object2) -> Uncheck.apply(this, object, object2);
    }
}

