/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.function.Constants;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOFunction<T, R> {
    public static <T> IOFunction<T, T> identity() {
        return Constants.IO_FUNCTION_ID;
    }

    default public IOConsumer<T> andThen(Consumer<? super R> consumer) {
        Objects.requireNonNull(consumer, "after");
        return object -> consumer.accept((R)this.apply(object));
    }

    default public <V> IOFunction<T, V> andThen(Function<? super R, ? extends V> function) {
        Objects.requireNonNull(function, "after");
        return object -> function.apply((R)this.apply(object));
    }

    default public IOConsumer<T> andThen(IOConsumer<? super R> iOConsumer) {
        Objects.requireNonNull(iOConsumer, "after");
        return object -> iOConsumer.accept((R)this.apply(object));
    }

    default public <V> IOFunction<T, V> andThen(IOFunction<? super R, ? extends V> iOFunction) {
        Objects.requireNonNull(iOFunction, "after");
        return object -> iOFunction.apply((R)this.apply(object));
    }

    public R apply(T var1) throws IOException;

    default public Function<T, R> asFunction() {
        return object -> Uncheck.apply(this, object);
    }

    default public <V> IOFunction<V, R> compose(Function<? super V, ? extends T> function) {
        Objects.requireNonNull(function, "before");
        return object -> this.apply(function.apply((Object)object));
    }

    default public <V> IOFunction<V, R> compose(IOFunction<? super V, ? extends T> iOFunction) {
        Objects.requireNonNull(iOFunction, "before");
        return object -> this.apply(iOFunction.apply((Object)object));
    }

    default public IOSupplier<R> compose(IOSupplier<? extends T> iOSupplier) {
        Objects.requireNonNull(iOSupplier, "before");
        return () -> this.apply(iOSupplier.get());
    }

    default public IOSupplier<R> compose(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "before");
        return () -> this.apply(supplier.get());
    }
}

